/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3;

import fr.geraidv3.L10n;
import fr.geraidv3.LookAndFeelTheme;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.setting_menu.PlatformSettingsHandler;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.Raid;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

@ExcludeFromJacocoGeneratedReport
public final class GeRaidV3 {
    private static JFrame _frame;
    private static TimeZone _localTimeZone;

    public static void main(String[] args) {
        GeRaidV3.setLocale();
        LookAndFeelTheme.setup();
        SwingUtilities.invokeLater(() -> SessionLauncher.init(args));
    }

    public static JFrame getRootFrame() {
        return _frame;
    }

    public static TimeZone getLocaleTimeZone() {
        return _localTimeZone;
    }

    public static void setLocaleForTests() {
        Locale locale = new Locale.Builder().setLanguage("fr").setRegion("FR").build();
        L10n.setLocale(locale);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        _localTimeZone = TimeZone.getDefault();
    }

    private static void setLocale() {
        _localTimeZone = TimeZone.getDefault();
        Locale locale = new Locale.Builder().setLanguage("fr").setRegion("FR").build();
        L10n.setLocale(locale);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @ExcludeFromJacocoGeneratedReport
    public static final class SessionLauncher {
        public static String getVersion() {
            String string;
            InputStream inputStream = Raid.class.getResourceAsStream("/fr/geraidv3/version.txt");
            assert (inputStream != null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                string = reader.readLine();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return "0.0.0";
                }
            }
            reader.close();
            return string;
        }

        static void init(String[] args) {
            _frame = new DesktopView();
            DesktopView desktop = (DesktopView)GeRaidV3.getRootFrame();
            desktop.setDefaultCloseOperation(3);
            desktop.setExtendedState(6);
            desktop.setIconImages(Arrays.asList(new ImageIcon(desktop.getClass().getClassLoader().getResource("fr/geraidv3/icon/logo24.png")).getImage(), new ImageIcon(desktop.getClass().getClassLoader().getResource("fr/geraidv3/icon/logo32.png")).getImage(), new ImageIcon(desktop.getClass().getClassLoader().getResource("fr/geraidv3/icon/logo64.png")).getImage(), new ImageIcon(desktop.getClass().getClassLoader().getResource("fr/geraidv3/icon/logo128.png")).getImage()));
            SessionLauncher._configureGlobalSettingsIfNeeded(desktop);
            desktop.setVisible(true);
            desktop.initialise(args);
        }

        private static void _configureGlobalSettingsIfNeeded(DesktopView desktop) {
            if (!PlatformSettingsHandler.isExistNotEmptyGlobalSettingsDirectory()) {
                try {
                    PlatformSettingsHandler.createGlobalSettingsDirectoryIfNeeded();
                    desktop.initializeGlobalSettings();
                    boolean validated = desktop.configureGlobalSettings();
                    if (!validated) {
                        System.exit(0);
                    }
                }
                catch (IOException ignored) {
                    String directory = PlatformSettingsHandler.getGlobalSettingsDirectory();
                    ErrorPane.showMessageDialog(desktop, L10n.getString("session_launcher.error_config_directory", directory));
                    System.exit(1);
                }
            }
        }
    }
}

