/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.AbstractTextFieldListener;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.categorie.CategorieVector;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

@ExcludeFromJacocoGeneratedReport
public final class CategoryEditorDialog
extends GDialog {
    private final transient Categorie _category;
    private final transient CategorieVector _categories;
    private final transient Consumer<CategorieVector> _updateCallback;
    private final boolean _isCreation;
    private JTextField _longNameTextField;
    private JTextField _shortNameTextField;
    private JLabel _errorLabel;
    private JButton _validationButton;

    public CategoryEditorDialog(JDialog parent, Categorie category, CategorieVector categories, Consumer<CategorieVector> updateCallback, boolean isCreation) {
        super(parent);
        this._category = category;
        this._categories = categories;
        this._isCreation = isCreation;
        this._updateCallback = updateCallback;
        this._initializeUI();
        if (this._isCreation) {
            this.setTitle(L10n.getString("category_editor.title1"));
        } else {
            this.setTitle(L10n.getString("category_editor.title2"));
        }
        this._longNameTextField.setText(this._category.getLongName());
        this._shortNameTextField.setText(this._category.getShortName());
        this._validationButton.setEnabled(false);
    }

    private void _initializeUI() {
        this.setModal(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this._createContentPanel(), "North");
        panel.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(panel);
        this.pack();
    }

    private JPanel _createContentPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(8, 8, 8, 8));
        JPanel panel1 = new JPanel(new GridBagLayout());
        Insets insets = new Insets(3, 3, 3, 3);
        GridBagConstraints constraints1 = new GridBagConstraints();
        constraints1.gridx = 0;
        constraints1.gridy = 0;
        constraints1.ipadx = 5;
        constraints1.insets = insets;
        panel1.add((Component)new JLabel(L10n.getString("settings.category.long_name")), constraints1);
        GridBagConstraints constraints2 = new GridBagConstraints();
        constraints2.gridx = 1;
        constraints2.gridy = 0;
        constraints2.fill = 2;
        constraints2.gridwidth = 0;
        constraints2.weightx = 1.0;
        constraints2.insets = insets;
        panel1.add((Component)this._createLongNameTextField(), constraints2);
        GridBagConstraints constraints3 = new GridBagConstraints();
        constraints3.gridx = 0;
        constraints3.gridy = 1;
        constraints3.ipadx = 5;
        constraints3.insets = insets;
        panel1.add((Component)new JLabel(L10n.getString("settings.category.short_name")), constraints3);
        GridBagConstraints constraints4 = new GridBagConstraints();
        constraints4.gridx = 1;
        constraints4.gridy = 1;
        constraints4.insets = insets;
        constraints4.weightx = 1.0;
        constraints4.fill = 2;
        constraints4.gridwidth = 0;
        panel1.add((Component)this._createShortNameTextField(), constraints4);
        panel.add(panel1);
        JPanel panel2 = new JPanel(new BorderLayout());
        this._errorLabel = new JLabel("");
        this._errorLabel.setForeground(Color.red);
        this._errorLabel.setPreferredSize(new Dimension(280, 20));
        panel2.add((Component)this._errorLabel, "Center");
        GridBagConstraints constraints5 = new GridBagConstraints();
        constraints5.gridx = 0;
        constraints5.gridy = 2;
        constraints5.weightx = 0.5;
        constraints5.fill = 2;
        constraints5.gridwidth = 0;
        panel.add((Component)panel2, constraints5);
        return panel;
    }

    private JTextField _createLongNameTextField() {
        this._longNameTextField = new JTextField();
        this._longNameTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                CategoryEditorDialog.this._enableValidateButtonIfSettingsCompleted();
            }
        });
        return this._longNameTextField;
    }

    private JTextField _createShortNameTextField() {
        this._shortNameTextField = new JTextField();
        this._shortNameTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                CategoryEditorDialog.this._enableValidateButtonIfSettingsCompleted();
            }
        });
        return this._shortNameTextField;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createValidationButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createValidationButton() {
        this._validationButton = new JButton(L10n.getString(this._isCreation ? "category_editor.create" : "category_editor.modify"));
        this._validationButton.addActionListener(event -> {
            String trimmedLongName = this._longNameTextField.getText().trim();
            String trimmedShortName = this._shortNameTextField.getText().trim();
            if (this._isCreation && this._categories.existsCategorie(trimmedLongName, trimmedShortName)) {
                this._errorLabel.setText(L10n.getString("category_editor.error1"));
            } else {
                this._category.setLongName(trimmedLongName);
                this._category.setShortName(trimmedShortName);
                if (this._isCreation) {
                    this._categories.addCategorie(this._category);
                }
                this._updateCallback.accept(this._categories);
                this.dispose();
            }
        });
        this.setDefaultButton(this._validationButton);
        return this._validationButton;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }

    private void _enableValidateButtonIfSettingsCompleted() {
        this._errorLabel.setText("");
        this._validationButton.setEnabled(!this._longNameTextField.getText().trim().isEmpty() && !this._shortNameTextField.getText().trim().isEmpty());
    }
}

