/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.file_menu.FileMenu;
import fr.geraidv3.desktop.help_menu.HelpMenu;
import fr.geraidv3.desktop.raid_menu.RaidMenu;
import fr.geraidv3.desktop.setting_menu.SettingMenu;
import fr.geraidv3.desktop.simulation.SimulatorMenu;
import fr.geraidv3.desktop.swing_ext.StatefulComponent;
import fr.geraidv3.desktop.tools_menu.ToolsMenu;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

@ExcludeFromJacocoGeneratedReport
final class DesktopMenuBar
extends JMenuBar
implements StatefulComponent {
    private final transient DesktopPresenter _presenter;
    private final transient DesktopView _desktopView;
    private SimulatorMenu _simulatorMenu;
    private RaidMenu _raidMenu;
    private JLabel _raidNameLabel;

    DesktopMenuBar(DesktopView desktopView, DesktopPresenter presenter) {
        this._presenter = presenter;
        this._desktopView = desktopView;
        this._createMenu();
    }

    @Override
    public void update(DesktopPresenter presenter) {
        this._raidMenu.update(presenter);
        this._simulatorMenu.update(presenter);
        String filename = presenter.getRaid().getCurrentFilename();
        filename = filename.isEmpty() ? "Sans nom" : new File(filename).getName();
        this._raidNameLabel.setText(filename);
    }

    private void _createMenu() {
        this.setMargin(new Insets(5, 5, 5, 10));
        this.setOpaque(true);
        this.add(new FileMenu(this._presenter));
        this._raidMenu = new RaidMenu(this._desktopView, this._presenter);
        this.add(this._raidMenu);
        this.add(new SettingMenu(this._presenter));
        this._simulatorMenu = new SimulatorMenu(this._desktopView, this._presenter);
        this.add(this._simulatorMenu);
        this.add(new ToolsMenu(this._presenter));
        this.add(new HelpMenu(this._desktopView));
        this.add(Box.createHorizontalStrut(8));
        this.add(this._createNewReleaseNotification());
        this.add(Box.createHorizontalGlue());
        this._raidNameLabel = new JLabel();
        this._raidNameLabel.setForeground(Color.WHITE);
        this.add(this._raidNameLabel);
    }

    private JMenu _createNewReleaseNotification() {
        JMenu releaseMenu = new JMenu();
        ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("fr/geraidv3/icon/notification-16.png")));
        releaseMenu.setIcon(icon);
        releaseMenu.setVisible(false);
        releaseMenu.setToolTipText(L10n.getString("new_version.tooltip"));
        this._presenter.setButtonEnabledIfNewReleaseAvailable(releaseMenu);
        return releaseMenu;
    }
}

