/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopMenuBar;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.equipe_panel.EquipePanelView;
import fr.geraidv3.desktop.file_panel.FilePanelView;
import fr.geraidv3.desktop.raid_panel.RaidView;
import fr.geraidv3.desktop.result_panel.ResultView;
import fr.geraidv3.desktop.sportident_panel.SportIdentPuceView;
import fr.geraidv3.desktop.sportident_panel.SportIdentStationState;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.desktop.swing_ext.MyComboBox;
import fr.geraidv3.desktop.swing_ext.StatefulComponent;
import fr.geraidv3.model.SortType;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

@ExcludeFromJacocoGeneratedReport
public final class DesktopView
extends JFrame {
    private final transient DesktopPresenter _presenter;
    private final JList<Epreuve> _epreuveList = new JList();
    private final JComboBox<Parcours> _parcoursComboBox = new JComboBox();
    private final MyComboBox<ParcoursVariante> _varianteComboBox = MyComboBox.build(L10n.getString("raid_panel.variante.unselectable_item"));
    private final JList<Equipe> _equipeList = new JList();
    private final JList<Balise> _baliseList = new JList();
    private final JComboBox<Etape> _etapeComboBox = new JComboBox();
    private final JComboBox<Categorie> _categorieComboBox = new JComboBox();
    private final List<StatefulComponent> _observers = new ArrayList<StatefulComponent>();
    private EquipePanelView _equipePanelView;
    private FilePanelView _filePanelView;
    private ResultView _resultView;
    private SportIdentPuceView _sportIdentView;
    private SortType _currentSelectedType = SortType.DOSSARD;

    public DesktopView() {
        this._presenter = new DesktopPresenter(this);
        this._initializeUI();
        this._parcoursComboBox.setModel(new DefaultComboBoxModel<Parcours>(this._presenter.getRaid().getParcoursVector().getParcoursVector()));
        this.pack();
    }

    public Parcours getSelectedParcours() {
        return (Parcours)this._parcoursComboBox.getSelectedItem();
    }

    public JComboBox<Parcours> getParcoursComboBox() {
        return this._parcoursComboBox;
    }

    public MyComboBox<ParcoursVariante> getVarianteComboBox() {
        return this._varianteComboBox;
    }

    public JList<Equipe> getEquipeList() {
        return this._equipeList;
    }

    public Etape getSelectedEtape() {
        return (Etape)this._etapeComboBox.getSelectedItem();
    }

    public String getSelectedPort() {
        return this._sportIdentView.getSelectedPort();
    }

    public void initialise(String[] args) {
        this._presenter.loadGlobalSettings();
        if (args != null && args.length > 0) {
            this._presenter.openRaidFile(args[0]);
        } else {
            this._presenter.displayRecentRaidFiles();
        }
        this._notifyObservers();
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void refreshResultTable() {
        this._sportIdentView.setTime(this._presenter.getRaid().getHourZero());
        this._resultView.refreshResultTable();
    }

    public void setButtonSportIdentReaderEnabled(boolean value) {
        this._sportIdentView.setSportIdentReaderButtonEnabled(value);
    }

    public void repaintEquipeList() {
        this._equipeList.repaint();
    }

    public boolean configureGlobalSettings() {
        return this._presenter.configureGlobalSettings();
    }

    public void initializeGlobalSettings() {
        this._presenter.initializeGlobalSettings();
    }

    public ParcoursVariante getSelectedVariante() {
        ParcoursVariante variante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
        if (variante == null && this.getSelectedParcours().getVarianteVector().getSize() == 1) {
            variante = this.getSelectedParcours().getVarianteVector().getVarianteParcoursVector().get(0);
        }
        return variante;
    }

    public JList<Balise> getBaliseList() {
        return this._baliseList;
    }

    public void update() {
        this._notifyObservers();
    }

    public EquipePanelView getEquipePanel() {
        return this._equipePanelView;
    }

    void fillCategoryComboBox() {
        this._resultView.fillCategoryComboBox();
    }

    void refreshParcoursSelection(int size) {
        if (size > 0) {
            this._parcoursComboBox.setSelectedIndex(0);
        } else {
            this._parcoursComboBox.setSelectedIndex(-1);
        }
    }

    void setEnabledPuceReaderButton(boolean value) {
        this._equipePanelView.setEnabledPuceReaderButton(value);
    }

    void setSavingStateToRunning() {
        this._filePanelView.setSavingOkState();
    }

    void setSavingStateToNormal() {
        this._filePanelView.setSavingNormalState();
    }

    void setBackupStateToRunning() {
        this._filePanelView.setBackupOkState();
    }

    void setBackupStateToNormal() {
        this._filePanelView.setBackupNormalState();
    }

    SortType getCurrentSelectedType() {
        return this._currentSelectedType;
    }

    public void setCurrentSelectedType(SortType value) {
        this._currentSelectedType = value;
    }

    void displayStationStatus(SportIdentStationState status) {
        if (this._sportIdentView.isSportIdentReaderEnabled()) {
            if (status == SportIdentStationState.READY) {
                this._sportIdentView.changeStateToStop();
            } else if (status == SportIdentStationState.FAILED) {
                ErrorPane.showMessageDialog(this, L10n.getString("sport_ident_connection_error"));
                SwingUtilities.invokeLater(() -> this._sportIdentView.activateSportIdentButton());
            }
        } else if (this._presenter.getSportIdentPuceReaderInUse()) {
            if (status == SportIdentStationState.READY) {
                this._equipePanelView.changePuceReaderIcon("stop-24.png");
            } else if (status == SportIdentStationState.FAILED) {
                ErrorPane.showMessageDialog(this, L10n.getString("sport_ident_connection_error"));
                SwingUtilities.invokeLater(() -> this._equipePanelView.readSportIdentPuce());
            }
        }
    }

    void updateEquipeList() {
        assert (this._parcoursComboBox.getSelectedItem() != null);
        if (this._varianteComboBox.getSelectedItemValue() == null) {
            this._equipeList.setListData(((Parcours)this._parcoursComboBox.getSelectedItem()).getEquipeVector().getEquipeVector());
        } else {
            this._equipeList.setListData(((ParcoursVariante)this._varianteComboBox.getSelectedItemValue()).getEquipeVector().getEquipeVector());
        }
        if (this._equipeList.getModel().getSize() > -1) {
            this._equipeList.setSelectedIndex(0);
        }
    }

    void cleanResultTable() {
        this._resultView.cleanTable();
    }

    int savingCurrentRaidConfirmationDialog() {
        if (this._presenter.isModified()) {
            return JOptionPane.showConfirmDialog(this.getRootPane(), L10n.getString("desktop_quit_confirmation_message"), L10n.getString("desktop_quit_confirmation_title"), 1, 3);
        }
        return 1;
    }

    void selectAndOpenRaidFile() {
        JFileChooser chooser = new JFileChooser(new File(this._presenter.getRaidFolderPath()));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("grd_file.description"), "grd");
        chooser.setFileFilter(filter);
        int choice = chooser.showOpenDialog(this);
        if (choice == 0) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            this._presenter.setLastOpenDirectory(chooser.getSelectedFile());
            this._presenter.openRaidFile(filename);
        }
    }

    void quit() {
        this.setDefaultCloseOperation(2);
        this.dispose();
    }

    void cancelQuit() {
        this.setDefaultCloseOperation(0);
    }

    void refreshRaidPanel() {
        this._parcoursComboBox.repaint();
        this._parcoursComboBox.setSelectedIndex(-1);
    }

    private void _notifyObservers() {
        for (StatefulComponent observer : this._observers) {
            observer.update(this._presenter);
        }
    }

    private void _addObserver(StatefulComponent item) {
        this._observers.add(item);
    }

    private void _initializeUI() {
        this.setSize(1069, 727);
        this.setMinimumSize(new Dimension(820, 400));
        this.setDefaultCloseOperation(0);
        DesktopMenuBar menuBar = new DesktopMenuBar(this, this._presenter);
        this.setJMenuBar(menuBar);
        this._addObserver(menuBar);
        this.setContentPane(this._getContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                DesktopView.this._presenter.quit();
            }
        });
        this.pack();
    }

    private JPanel _getContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this._getMainPane(), "Center");
        return panel;
    }

    private JSplitPane _getMainPane() {
        JSplitPane splitPane = new JSplitPane(0, this._createRaidTabbedPane(), this._createResultTabbedPane());
        splitPane.setOneTouchExpandable(true);
        splitPane.setContinuousLayout(true);
        splitPane.setOrientation(0);
        splitPane.setDividerSize(30);
        splitPane.setDividerLocation((int)((double)(this.getHeight() - splitPane.getDividerSize()) * 0.7));
        return splitPane;
    }

    private JComponent _createRaidTabbedPane() {
        JPanel raidPanel = new JPanel(new BorderLayout());
        this._filePanelView = new FilePanelView(this._presenter);
        this._addObserver(this._filePanelView);
        raidPanel.add((Component)this._filePanelView, "West");
        JPanel equipeFeatures = new JPanel();
        equipeFeatures.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this._sportIdentView = new SportIdentPuceView(this._presenter);
        this._addObserver(this._sportIdentView);
        this._equipePanelView = new EquipePanelView(this, this._presenter, this._equipeList);
        this._addObserver(this._equipePanelView);
        c.weightx = 1.0;
        c.gridy = 0;
        c.fill = 2;
        equipeFeatures.add((Component)this._sportIdentView, c);
        c.weighty = 1.0;
        c.gridy = 1;
        c.fill = 1;
        equipeFeatures.add((Component)this._equipePanelView, c);
        RaidView raidView = new RaidView(this._presenter, this._equipeList, this._parcoursComboBox, this._varianteComboBox, this._epreuveList, this._etapeComboBox, this._baliseList);
        JSplitPane pane = new JSplitPane(1, equipeFeatures, raidView);
        this._addObserver(raidView);
        pane.setOneTouchExpandable(true);
        pane.setContinuousLayout(true);
        pane.setDividerSize(30);
        raidPanel.add((Component)pane, "Center");
        return raidPanel;
    }

    private JPanel _createResultTabbedPane() {
        this._resultView = new ResultView(this, this._presenter, this._parcoursComboBox, this._epreuveList, this._etapeComboBox, this._categorieComboBox);
        this._addObserver(this._resultView);
        return this._resultView;
    }
}

