/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.utils.DateTimeUtils;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Date;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

@ExcludeFromJacocoGeneratedReport
public final class PartialEditorDialog
extends GDialog {
    private final transient Partiel _partiel;
    private final transient Consumer<Partiel> _updateCallback;
    private final boolean _creation;
    private JSpinner _hourSpinner;
    private JSpinner _minuteSpinner;
    private JSpinner _secondSpinner;
    private JSpinner _codeSpinner;

    public static PartialEditorDialog buildCreator(JDialog parent, Partiel partiel, Consumer<Partiel> updateCallback) {
        return new PartialEditorDialog(parent, partiel, updateCallback, true);
    }

    public static PartialEditorDialog buildEditor(JDialog parent, Partiel partiel, Consumer<Partiel> updateCallback) {
        return new PartialEditorDialog(parent, partiel, updateCallback, false);
    }

    private PartialEditorDialog(JDialog parent, Partiel partiel, Consumer<Partiel> updateCallback, boolean creation) {
        super(parent);
        this._partiel = partiel;
        this._updateCallback = updateCallback;
        this._creation = creation;
        this._initializeUI();
        if (this._creation) {
            this.setTitle(L10n.getString("partiel_editor_dialog_title1"));
        } else {
            this.setTitle(L10n.getString("partiel_editor_dialog_title2"));
        }
        this._codeSpinner.setValue(this._partiel.getCode());
        this._hourSpinner.setValue(DateTimeUtils.getHoursFromDate(this._partiel.getTimeAsDate()));
        this._minuteSpinner.setValue(DateTimeUtils.getMinutesFromDate(this._partiel.getTimeAsDate()));
        this._secondSpinner.setValue(DateTimeUtils.getSecondsFromDate(this._partiel.getTimeAsDate()));
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setResizable(false);
        this.setContentPane(this._createContentPane());
        this.pack();
    }

    private JPanel _createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)this._createMainPanel(), "Center");
        contentPane.add((Component)this._createButtonPanel(), "South");
        return contentPane;
    }

    private JPanel _createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._createCodePanel());
        panel.add(this._createStartTimePanel());
        return panel;
    }

    private JPanel _createCodePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel(L10n.getString("partiel_editor_dialog_code")));
        jPanel.add(this._createCodeSpinner());
        return jPanel;
    }

    private JPanel _createStartTimePanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("partiel_editor_dialog_time")));
        panel.add(this._createHourSpinner());
        panel.add(new JLabel(L10n.getString("hour_abbreviation")));
        panel.add(this._createMinuteSpinner());
        panel.add(new JLabel(L10n.getString("minute_abbreviation")));
        panel.add(this._createSecondSpinner());
        panel.add(new JLabel(L10n.getString("second_abbreviation")));
        return panel;
    }

    private JSpinner _createHourSpinner() {
        this._hourSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 47, 1));
        this._hourSpinner.setEditor(new JSpinner.NumberEditor(this._hourSpinner, "00"));
        return this._hourSpinner;
    }

    private JSpinner _createMinuteSpinner() {
        this._minuteSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this._minuteSpinner.setEditor(new JSpinner.NumberEditor(this._minuteSpinner, "00"));
        return this._minuteSpinner;
    }

    private JSpinner _createSecondSpinner() {
        this._secondSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this._secondSpinner.setEditor(new JSpinner.NumberEditor(this._secondSpinner, "00"));
        return this._secondSpinner;
    }

    private JSpinner _createCodeSpinner() {
        this._codeSpinner = new JSpinner(new SpinnerNumberModel(31, 31, 500, 1));
        this._codeSpinner.setEditor(new JSpinner.NumberEditor(this._codeSpinner, "000"));
        return this._codeSpinner;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createOkButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createOkButton() {
        JButton button = this._creation ? new JButton(L10n.getString("partiel_editor_dialog_button1")) : new JButton(L10n.getString("partiel_editor_dialog_button2"));
        this.setDefaultButton(button);
        button.addActionListener(event -> {
            this._partiel.setCode((Integer)this._codeSpinner.getValue());
            this._partiel.setTimeAsDate(new Date((long)((Integer)this._hourSpinner.getValue()).intValue() * 3600000L + (long)((Integer)this._minuteSpinner.getValue()).intValue() * 60000L + (long)((Integer)this._secondSpinner.getValue()).intValue() * 1000L));
            this._updateCallback.accept(this._partiel);
            this.dispose();
        });
        return button;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

