/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.PartialEditorDialog;
import fr.geraidv3.desktop.swing_ext.AbstractTextFieldListener;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.desktop.swing_ext.SwingUtils;
import fr.geraidv3.model.StartType;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.result.puce.Puce;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.utils.DateTimeUtils;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.NumberFormatter;

@ExcludeFromJacocoGeneratedReport
public final class PuceResultManagementDialog
extends GDialog {
    static final String CANCEL_ACTION = "cancel-search";
    static final String ENTER_ACTION = "validate-search";
    private final transient DesktopPresenter _presenter;
    private transient PuceResult _puceResult;
    private JComboBox<Parcours> _parcoursComboBox;
    private JComboBox<Etape> _etapeComboBox;
    private JComboBox<Equipe> _equipeComboBox;
    private JComboBox<String> _pucesComboBox;
    private JList<Partiel> _baliseList;
    private JPanel _panelCenter;
    private JSpinner _startHourSpinner;
    private JSpinner _startMinuteSpinner;
    private JSpinner _startSecondSpinner;
    private JSpinner _finishHourSpinner;
    private JSpinner _finishMinuteSpinner;
    private JSpinner _finishSecondSpinner;
    private JPanel _pucesSelectorPanel;
    private Date _startDate;

    public PuceResultManagementDialog(JFrame parent, DesktopPresenter presenter) {
        super(parent);
        this._presenter = presenter;
        this._initializeUI();
        this._panelCenter.setVisible(false);
        this._setButtonsState();
    }

    public PuceResultManagementDialog(JFrame parent, DesktopPresenter presenter, Parcours parcours, Etape etape, Equipe equipe) {
        super(parent);
        this._presenter = presenter;
        this._initializeUI();
        this._panelCenter.setVisible(false);
        this._setButtonsState();
        this._parcoursComboBox.setSelectedItem(parcours);
        this._etapeComboBox.setSelectedItem(etape);
        this._equipeComboBox.setSelectedItem(equipe);
        this.getRootPane().registerKeyboardAction(e -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    public PuceResultManagementDialog(JFrame parent, DesktopPresenter presenter, Parcours parcours, Etape etape, Equipe equipe, String puce) {
        this(parent, presenter, parcours, etape, equipe);
        this._pucesComboBox.setSelectedItem(puce);
    }

    private void _setButtonsState() {
        this._parcoursComboBox.setModel(new DefaultComboBoxModel<Parcours>(this._presenter.getRaid().getPuceResultVector().getAllParcours()));
        if (this._parcoursComboBox.getItemCount() > 0) {
            this._parcoursComboBox.setSelectedIndex(0);
            this._etapeComboBox.setVisible(true);
            this._equipeComboBox.setVisible(true);
            this._panelCenter.setVisible(true);
        } else {
            this._parcoursComboBox.setSelectedIndex(-1);
            this._etapeComboBox.setVisible(false);
            this._equipeComboBox.setVisible(false);
            this._panelCenter.setVisible(false);
        }
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setTitle(L10n.getString("puce_result_management_dialog.title"));
        this.setContentPane(this._getContentPane());
        this.pack();
    }

    private JPanel _getContentPane() {
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(new EmptyBorder(10, 10, 10, 10));
        pane.add((Component)this._getResultChoicePanel(), "North");
        pane.add((Component)this._getResultPanel(), "Center");
        pane.add((Component)this._getMessageInformation(), "South");
        return pane;
    }

    private JPanel _getResultChoicePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder(null, L10n.getString("puce_result_management_dialog.choice_panel.title"), 4, 2));
        panel.add(this._createParcoursSelectorPanel());
        panel.add(this._createEtapeSelectorPanel());
        panel.add(this._createEquipeSelectorPanel());
        panel.add(this._createPucesSelectorPanel());
        return panel;
    }

    private JPanel _createPucesSelectorPanel() {
        JLabel label = new JLabel(L10n.getString("puce_result_management_dialog.chips"));
        label.setPreferredSize(new Dimension(70, 16));
        this._pucesSelectorPanel = new JPanel(new BorderLayout(0, 5));
        this._pucesSelectorPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this._pucesSelectorPanel.add((Component)label, "West");
        this._pucesSelectorPanel.add(this._createPucesComboBox(), "Center");
        return this._pucesSelectorPanel;
    }

    private JComboBox<String> _createPucesComboBox() {
        this._pucesComboBox = new JComboBox();
        Dimension preferredSize = this._pucesComboBox.getPreferredSize();
        this._pucesComboBox.setPreferredSize(new Dimension(260, preferredSize.height));
        this._pucesComboBox.addActionListener(event -> {
            if (this._pucesComboBox.getSelectedIndex() != -1) {
                this._panelCenter.setVisible(true);
                this._puceResult = this._presenter.getRaid().getPuceResultVector().getPuceResult((Parcours)this._parcoursComboBox.getSelectedItem(), (Etape)this._etapeComboBox.getSelectedItem(), (String)this._pucesComboBox.getSelectedItem());
                assert (this._puceResult != null);
                this._startDate = this._calculateStartDate(this._puceResult);
                this._startHourSpinner.setValue(DateTimeUtils.getHoursFromDate(this._startDate));
                this._startMinuteSpinner.setValue(DateTimeUtils.getMinutesFromDate(this._startDate));
                this._startSecondSpinner.setValue(DateTimeUtils.getSecondsFromDate(this._startDate));
                this._finishHourSpinner.setValue(DateTimeUtils.getHoursFromDate(this._puceResult.getPuce().getFinishTime()));
                this._finishMinuteSpinner.setValue(DateTimeUtils.getMinutesFromDate(this._puceResult.getPuce().getFinishTime()));
                this._finishSecondSpinner.setValue(DateTimeUtils.getSecondsFromDate(this._puceResult.getPuce().getFinishTime()));
                this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
                this._baliseList.setSelectedIndex(0);
            } else {
                this._panelCenter.setVisible(false);
            }
        });
        return this._pucesComboBox;
    }

    private Date _calculateStartDate(PuceResult puceResult) {
        if (puceResult.getEtape().getStartType() == StartType.GROUPE) {
            return puceResult.getEtape().getStartHour();
        }
        return puceResult.getPuce().getStartTime();
    }

    private JPanel _createParcoursSelectorPanel() {
        JLabel label = new JLabel(L10n.getString("parcours"));
        label.setPreferredSize(new Dimension(70, 16));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        panel.add((Component)label, "West");
        panel.add(this._createParcoursComboBox(), "Center");
        return panel;
    }

    private JPanel _createEtapeSelectorPanel() {
        JLabel label = new JLabel(L10n.getString("etape"));
        label.setPreferredSize(new Dimension(70, 16));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        panel.add((Component)label, "West");
        panel.add(this._createEtapeComboBox(), "Center");
        return panel;
    }

    private JComboBox<Parcours> _createParcoursComboBox() {
        this._parcoursComboBox = new JComboBox();
        this._parcoursComboBox.addActionListener(event -> {
            if (this._parcoursComboBox.getSelectedIndex() != -1) {
                this._etapeComboBox.setModel(new DefaultComboBoxModel<Etape>(this._presenter.getRaid().getPuceResultVector().getEtapesForParcours((Parcours)this._parcoursComboBox.getSelectedItem())));
                if (this._etapeComboBox.getItemCount() > 0) {
                    this._etapeComboBox.setSelectedIndex(0);
                } else {
                    this._etapeComboBox.setSelectedIndex(-1);
                }
            }
        });
        return this._parcoursComboBox;
    }

    private JComboBox<Etape> _createEtapeComboBox() {
        this._etapeComboBox = new JComboBox();
        Dimension preferredSize = this._etapeComboBox.getPreferredSize();
        this._etapeComboBox.setPreferredSize(new Dimension(260, preferredSize.height));
        this._etapeComboBox.addActionListener(event -> {
            if (this._etapeComboBox.getSelectedIndex() != -1) {
                this._equipeComboBox.setModel(new DefaultComboBoxModel<Equipe>(this._presenter.getRaid().getPuceResultVector().getEquipesForEtape((Etape)this._etapeComboBox.getSelectedItem())));
                if (this._equipeComboBox.getItemCount() > 0) {
                    this._equipeComboBox.setSelectedIndex(0);
                } else {
                    this._equipeComboBox.setSelectedIndex(-1);
                }
            }
        });
        return this._etapeComboBox;
    }

    private JPanel _createEquipeSelectorPanel() {
        JLabel label = new JLabel(L10n.getString("equipe"));
        label.setPreferredSize(new Dimension(70, 16));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        panel.add((Component)label, "West");
        panel.add(this._createEquipeComboBox(), "Center");
        return panel;
    }

    private JComboBox<Equipe> _createEquipeComboBox() {
        this._equipeComboBox = new JComboBox();
        Dimension preferredSize = this._equipeComboBox.getPreferredSize();
        this._equipeComboBox.setPreferredSize(new Dimension(260, preferredSize.height));
        this._equipeComboBox.addActionListener(event -> {
            if (this._equipeComboBox.getSelectedIndex() != -1) {
                this._panelCenter.setVisible(true);
                Object selectedItem = this._equipeComboBox.getSelectedItem();
                assert (selectedItem != null);
                this._puceResult = this._presenter.getRaid().getPuceResultVector().getPuceResult((Parcours)this._parcoursComboBox.getSelectedItem(), (Etape)this._etapeComboBox.getSelectedItem(), ((Equipe)selectedItem).getPuceIds().toArray(new String[0]));
                assert (this._puceResult != null);
                this._startDate = this._calculateStartDate(this._puceResult);
                this._startHourSpinner.setValue(DateTimeUtils.getHoursFromDate(this._startDate));
                this._startMinuteSpinner.setValue(DateTimeUtils.getMinutesFromDate(this._startDate));
                this._startSecondSpinner.setValue(DateTimeUtils.getSecondsFromDate(this._startDate));
                this._finishHourSpinner.setValue(DateTimeUtils.getHoursFromDate(this._puceResult.getPuce().getFinishTime()));
                this._finishMinuteSpinner.setValue(DateTimeUtils.getMinutesFromDate(this._puceResult.getPuce().getFinishTime()));
                this._finishSecondSpinner.setValue(DateTimeUtils.getSecondsFromDate(this._puceResult.getPuce().getFinishTime()));
                this._initPucesComboBox();
                this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
                this._baliseList.setSelectedIndex(0);
            } else {
                this._panelCenter.setVisible(false);
            }
        });
        return this._equipeComboBox;
    }

    private void _initPucesComboBox() {
        if (this._equipeComboBox.getSelectedIndex() != -1) {
            assert (this._equipeComboBox.getSelectedItem() != null);
            Equipe selectedEquipe = (Equipe)this._equipeComboBox.getSelectedItem();
            this._pucesComboBox.setModel(new DefaultComboBoxModel());
            for (String puceId : selectedEquipe.getPuceIds()) {
                if (!this._presenter.getRaid().existsPuceResultForId(puceId)) continue;
                this._pucesComboBox.addItem(puceId);
            }
            this._pucesComboBox.setSelectedItem(this._puceResult.getPuce().getId());
            this._pucesSelectorPanel.setVisible(true);
        }
    }

    private JPanel _getResultPanel() {
        this._panelCenter = new JPanel(new BorderLayout());
        this._panelCenter.setBorder(new TitledBorder(null, L10n.getString("puce_result_management_dialog.result_panel.title"), 4, 2));
        this._panelCenter.add((Component)this._createBaliseResultPanel(), "North");
        this._panelCenter.add((Component)this._createBalisesPanel(), "Center");
        return this._panelCenter;
    }

    private JPanel _createBaliseResultPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this._createDeleteResultButton(), "Center");
        panel2.setBorder(new EmptyBorder(5, 5, 2, 5));
        panel.add(panel2);
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.setBorder(new EmptyBorder(3, 5, 5, 5));
        panel3.add((Component)this._createDisplayResultButton(), "Center");
        panel.add(panel3);
        panel.add(this._createStartPanel());
        panel.add(this._createFinishPanel());
        return panel;
    }

    private JButton _createDeleteResultButton() {
        JButton button = new JButton(L10n.getString("puce_result_management_dialog.result_panel.delete"), IconButton.getImageIcon("delete-24.png"));
        button.setAlignmentX(0.5f);
        button.setToolTipText(L10n.getString("puce_result_management_dialog.result_panel.delete.tooltip"));
        button.addActionListener(event -> {
            int reply = JOptionPane.showConfirmDialog(this.rootPane, L10n.getString("puce_result_management_dialog.result_panel.delete.confirmation_message"), L10n.getString("puce_result_management_dialog.result_panel.confirmation_title"), 0, 3);
            if (reply == 0) {
                this._presenter.getRaid().getPuceResultVector().removePuceResult(this._puceResult);
                this._presenter.setModified(true);
                this.dispose();
            }
        });
        return button;
    }

    private JButton _createDisplayResultButton() {
        JButton button = new JButton(L10n.getString("puce_result_management_dialog.result_panel.display"), IconButton.getImageIcon("visible-24.png"));
        button.setAlignmentX(0.5f);
        button.setMnemonic(0);
        button.addActionListener(event -> this._presenter.showSportIdentResulDialog(this._puceResult, true, true));
        return button;
    }

    private JPanel _createStartPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("puce_result_management_dialog.result_panel.start")));
        panel.add(this._createStartHourSpinner());
        panel.add(new JLabel(L10n.getString("hour_abbreviation")));
        panel.add(this._createStartMinuteSpinner());
        panel.add(new JLabel(L10n.getString("minute_abbreviation")));
        panel.add(this._createStartSecondSpinner());
        return panel;
    }

    private JPanel _createFinishPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("puce_result_management_dialog.result_panel.finish")));
        panel.add(this._createFinishHourSpinner());
        panel.add(new JLabel(L10n.getString("hour_abbreviation")));
        panel.add(this._createFinishMinuteSpinner());
        panel.add(new JLabel(L10n.getString("minute_abbreviation")));
        panel.add(this._createFinishSecondSpinner());
        return panel;
    }

    private JSpinner _createStartHourSpinner() {
        this._startHourSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 23, 1));
        this._startHourSpinner.setEditor(new JSpinner.NumberEditor(this._startHourSpinner, "00"));
        this._startHourSpinner.addChangeListener(event -> {
            Date startTime = DateTimeUtils.setHoursToDate(this._startDate, (Integer)this._startHourSpinner.getValue());
            this._puceResult.getPuce().setStartTime(startTime);
        });
        return this._startHourSpinner;
    }

    private JSpinner _createStartMinuteSpinner() {
        this._startMinuteSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this._startMinuteSpinner.setEditor(new JSpinner.NumberEditor(this._startMinuteSpinner, "00"));
        this._startMinuteSpinner.addChangeListener(event -> {
            Date startTime = DateTimeUtils.setMinutesToDate(this._startDate, (Integer)this._startMinuteSpinner.getValue());
            this._puceResult.getPuce().setStartTime(startTime);
        });
        return this._startMinuteSpinner;
    }

    private JSpinner _createStartSecondSpinner() {
        this._startSecondSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this._startSecondSpinner.setEditor(new JSpinner.NumberEditor(this._startSecondSpinner, "00"));
        this._startSecondSpinner.addChangeListener(event -> {
            Date startTime = DateTimeUtils.setSecondsToDate(this._startDate, (Integer)this._startSecondSpinner.getValue());
            this._puceResult.getPuce().setStartTime(startTime);
        });
        return this._startSecondSpinner;
    }

    private JSpinner _createFinishHourSpinner() {
        this._finishHourSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 47, 1));
        this._finishHourSpinner.setEditor(new JSpinner.NumberEditor(this._finishHourSpinner, "00"));
        this._finishHourSpinner.addChangeListener(event -> {
            Date finishTime = DateTimeUtils.setHoursToDate(this._puceResult.getPuce().getFinishTime(), (Integer)this._finishHourSpinner.getValue());
            this._puceResult.getPuce().setFinishTime(finishTime);
        });
        return this._finishHourSpinner;
    }

    private JSpinner _createFinishMinuteSpinner() {
        this._finishMinuteSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this._finishMinuteSpinner.setEditor(new JSpinner.NumberEditor(this._finishMinuteSpinner, "00"));
        this._finishMinuteSpinner.addChangeListener(event -> {
            Date finishTime = DateTimeUtils.setMinutesToDate(this._puceResult.getPuce().getFinishTime(), (Integer)this._finishMinuteSpinner.getValue());
            this._puceResult.getPuce().setFinishTime(finishTime);
        });
        return this._finishMinuteSpinner;
    }

    private JSpinner _createFinishSecondSpinner() {
        this._finishSecondSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this._finishSecondSpinner.setEditor(new JSpinner.NumberEditor(this._finishSecondSpinner, "00"));
        this._finishSecondSpinner.addChangeListener(event -> {
            Date finishTime = DateTimeUtils.setSecondsToDate(this._puceResult.getPuce().getFinishTime(), (Integer)this._finishSecondSpinner.getValue());
            this._puceResult.getPuce().setFinishTime(finishTime);
        });
        return this._finishSecondSpinner;
    }

    private JPanel _createBalisesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("puce_result_management_dialog.balise_panel.title"), 4, 2));
        panel.add((Component)this._createButtonsPanel(), "North");
        panel.add((Component)this._createJScrollPane(), "Center");
        panel.add((Component)this._createSortButtonsPanel(), "West");
        return panel;
    }

    private JPanel _createButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this._createAddBaliseButton());
        panel.add(this._createEditBaliseButton());
        panel.add(this._createDeleteBaliseButton());
        panel.add(this._createSearchBaliseButton());
        return panel;
    }

    private JButton _createAddBaliseButton() {
        IconButton button = new IconButton("add-24.png");
        button.setToolTipText(L10n.getString("puce_result_management_dialog.balise_panel.add.tooltip"));
        button.addActionListener(event -> {
            AtomicInteger index = new AtomicInteger(0);
            PartialEditorDialog dialog = PartialEditorDialog.buildCreator(this, new Partiel(), partiel -> {
                Puce puce = this._puceResult.getPuce();
                index.set(puce.addPartiel((Partiel)partiel));
                this._baliseList.setSelectedIndex(index.get());
                this._presenter.setModified(true);
            });
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
            this._baliseList.setSelectedIndex(index.get());
            this._baliseList.ensureIndexIsVisible(index.get());
        });
        return button;
    }

    private JButton _createEditBaliseButton() {
        IconButton button = new IconButton("edit-24.png");
        button.setToolTipText(L10n.getString("puce_result_management_dialog.balise_panel.edit.tooltip"));
        button.addActionListener(event -> {
            if (this._baliseList.getModel().getSize() > 0) {
                this._editBalise(this._baliseList.getSelectedValue());
            }
        });
        return button;
    }

    private void _editBalise(Partiel selectedPartiel) {
        AtomicInteger index = new AtomicInteger(0);
        PartialEditorDialog dialog = PartialEditorDialog.buildEditor(this, selectedPartiel, partiel -> {
            Puce puce = this._puceResult.getPuce();
            index.set(puce.movePartiel((Partiel)partiel));
            this._presenter.setModified(true);
        });
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
        this._baliseList.setSelectedIndex(index.get());
        this._baliseList.ensureIndexIsVisible(index.get());
    }

    private JButton _createDeleteBaliseButton() {
        IconButton button = new IconButton("delete-24.png");
        button.setToolTipText(L10n.getString("puce_result_management_dialog.balise_panel.delete.tooltip"));
        button.addActionListener(event -> this._deleteBalises());
        return button;
    }

    private JButton _createSearchBaliseButton() {
        IconButton button = new IconButton("search-24.png");
        button.setToolTipText(L10n.getString("puce_result_management_dialog.balise_panel.search.tooltip"));
        InputMap inputMap = button.getInputMap(2);
        ActionMap actionMap = button.getActionMap();
        KeyStroke ctrlQKey = KeyStroke.getKeyStroke(70, 128);
        inputMap.put(ctrlQKey, ctrlQKey.toString());
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PuceResultManagementDialog.this._searchBalises();
            }
        };
        actionMap.put(ctrlQKey.toString(), action);
        button.addActionListener(event -> this._searchBalises());
        return button;
    }

    private void _searchBalises() {
        String baliseCodeAsString = this._showBaliseCodeInputDialog();
        int baliseIndex = -1;
        try {
            int baliseCode = Integer.parseInt(baliseCodeAsString);
            ListModel<Partiel> partiels = this._baliseList.getModel();
            for (int i = 0; i < partiels.getSize(); ++i) {
                if (partiels.getElementAt(i).getCode() != baliseCode) continue;
                baliseIndex = i;
                break;
            }
            if (baliseIndex > -1) {
                this._baliseList.setSelectedIndex(baliseIndex);
                this._baliseList.ensureIndexIsVisible(baliseIndex);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private String _showBaliseCodeInputDialog() {
        final AtomicReference<String> baliseCode = new AtomicReference<String>("");
        final GDialog dialog = new GDialog(this);
        dialog.setTitle(L10n.getString("puce_result_management_dialog.balise_panel.search.code"));
        NumberFormatter integerFormatter = PuceResultManagementDialog.getNumberFormatter();
        final JFormattedTextField textField = new JFormattedTextField(integerFormatter);
        InputMap inputMap = textField.getInputMap(2);
        ActionMap actionMap = textField.getActionMap();
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        };
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), CANCEL_ACTION);
        actionMap.put(CANCEL_ACTION, cancelAction);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), ENTER_ACTION);
        actionMap.put(ENTER_ACTION, cancelAction);
        AbstractAction validateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                baliseCode.set(textField.getText());
                dialog.dispose();
            }
        };
        textField.addActionListener(validateAction);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(8, 8, 8, 8));
        dialog.getContentPane().add(panel);
        JPanel panel1 = new JPanel(new FlowLayout(0));
        panel1.add(new JLabel(L10n.getString("puce_result_management_dialog.balise_panel.search.label")));
        textField.setColumns(10);
        panel1.add(textField);
        panel.add(panel1);
        panel.add(Box.createVerticalStrut(20));
        final JButton selectButton = new JButton(L10n.getString("puce_result_management_dialog.balise_panel.search.button"));
        selectButton.addActionListener(event -> {
            baliseCode.set(textField.getText());
            dialog.dispose();
        });
        textField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                if (!textField.getText().isEmpty()) {
                    selectButton.setEnabled(true);
                }
            }
        });
        this.setDefaultButton(selectButton);
        selectButton.setEnabled(false);
        panel.add(selectButton);
        dialog.pack();
        textField.requestFocusInWindow();
        dialog.setResizable(false);
        dialog.setModal(true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        return baliseCode.get();
    }

    private static NumberFormatter getNumberFormatter() {
        NumberFormat integerFormat = NumberFormat.getIntegerInstance();
        integerFormat.setGroupingUsed(false);
        NumberFormatter integerFormatter = new NumberFormatter(integerFormat){

            @Override
            public Object stringToValue(String text) throws ParseException {
                if (text.isEmpty()) {
                    return null;
                }
                return super.stringToValue(text);
            }
        };
        integerFormatter.setValueClass(Integer.class);
        integerFormatter.setAllowsInvalid(false);
        return integerFormatter;
    }

    private void _deleteBalises() {
        if (this._baliseList.getModel().getSize() > 0) {
            String message = this._baliseList.getSelectedIndices().length == 1 ? L10n.getString("puce_result_management_dialog.delete.confirmation_message1") : L10n.getString("puce_result_management_dialog.delete.confirmation_message2");
            int reply = JOptionPane.showConfirmDialog(this.rootPane, message, L10n.getString("puce_result_management_dialog.result_panel.confirmation_title"), 0, 3);
            if (reply == 0) {
                for (Partiel partiel : this._baliseList.getSelectedValuesList()) {
                    this._puceResult.getPuce().removePartiel(partiel);
                    this._presenter.setModified(true);
                }
            }
            this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
            this._baliseList.setSelectedIndex(0);
        }
    }

    private JPanel _createSortButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._createMoveUpButton());
        panel.add(this._createMoveDownButton());
        return panel;
    }

    private JButton _createMoveUpButton() {
        IconButton button = new IconButton("up-24.png");
        button.setToolTipText(L10n.getString("puce_result_management_dialog.balise_panel.up.tooltip"));
        button.addActionListener(event -> {
            int selectedIndex = this._baliseList.getSelectedIndex();
            if (this._baliseList.getSelectedIndex() >= 0) {
                this._puceResult.getPuce().moveUpPartiel(selectedIndex);
                this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
                this._baliseList.setSelectedIndex(selectedIndex - 1);
                this._baliseList.ensureIndexIsVisible(selectedIndex - 1);
                this._presenter.setModified(true);
            }
        });
        return button;
    }

    private JButton _createMoveDownButton() {
        IconButton button = new IconButton("down-24.png");
        button.setMnemonic(0);
        button.setToolTipText(L10n.getString("puce_result_management_dialog.balise_panel.down.tooltip"));
        button.addActionListener(event -> {
            int selectedIndex = this._baliseList.getSelectedIndex();
            if (selectedIndex >= 0) {
                this._puceResult.getPuce().moveDownPartiel(selectedIndex);
                this._baliseList.setListData((Partiel[])this._puceResult.getPuce().getPartielsAsArray());
                this._baliseList.setSelectedIndex(selectedIndex + 1);
                this._baliseList.ensureIndexIsVisible(selectedIndex + 1);
                this._presenter.setModified(true);
            }
        });
        return button;
    }

    private JComponent _getMessageInformation() {
        JLabel label = new JLabel(L10n.getString("puce_result_management_dialog.warning_message"));
        label.setForeground(Color.red);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(label);
        return panel;
    }

    private JScrollPane _createJScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        this._baliseList = new JList();
        this._baliseList.setSelectionMode(2);
        this._baliseList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() > 1) {
                    int index = list.locationToIndex(evt.getPoint());
                    PuceResultManagementDialog.this._editBalise(PuceResultManagementDialog.this._baliseList.getModel().getElementAt(index));
                }
            }
        });
        SwingUtils.addDeleteShortcut(this._baliseList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PuceResultManagementDialog.this._deleteBalises();
            }
        });
        scrollPane.setViewportView(this._baliseList);
        return scrollPane;
    }
}

