/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import fr.geraidv3.utils.SoftwareUpdater;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

@ExcludeFromJacocoGeneratedReport
final class ReleaseDialog
extends GDialog {
    private static final String PUBLISHER_URL = "https://vikazim.fr/wp-content/geraid/";
    private final String _version;
    private final DesktopPresenter _desktopPresenter;

    ReleaseDialog(DesktopPresenter desktopPresenter, String version) {
        super(desktopPresenter.getFrame());
        this._version = version;
        this._desktopPresenter = desktopPresenter;
        this.setTitle(L10n.getString("new_version.title"));
        this._initializeUI();
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setResizable(false);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this._createMessagePanel(), "Center");
        contentPanel.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(contentPanel);
        this.pack();
    }

    private JPanel _createMessagePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel message = new JLabel(L10n.getString("new_version.message", this._version));
        panel.add(message);
        return panel;
    }

    @NotNull
    private JPanel _createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton updateButton = new JButton(L10n.getString("new_version.update.button"));
        updateButton.setToolTipText(L10n.getString("new_version.update.tooltip"));
        updateButton.addActionListener(event -> {
            this.dispose();
            int choice = this._desktopPresenter.saveCurrentRaidIfNeeded();
            if (choice == 2) {
                return;
            }
            Object[] options = new String[]{L10n.getString("new_version.restart.option"), L10n.getString("new_version.cancel.option")};
            int answer = JOptionPane.showOptionDialog(GeRaidV3.getRootFrame(), L10n.getString("new_version.restart.label"), L10n.getString("warning"), 0, 2, null, options, options[0]);
            if (answer == 0) {
                try {
                    SoftwareUpdater.update(this._version);
                }
                catch (IOException | URISyntaxException | NoSuchAlgorithmException e) {
                    ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("new_version.update.error", e.getMessage()));
                }
            }
        });
        buttonPanel.add(updateButton);
        this.setDefaultButton(updateButton);
        JButton downloadButton = new JButton(L10n.getString("new_version.download.button"));
        downloadButton.setToolTipText(L10n.getString("new_version.download.tooltip"));
        downloadButton.addActionListener(event -> {
            this.dispose();
            try {
                Desktop.getDesktop().browse(new URI(PUBLISHER_URL));
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        });
        buttonPanel.add(downloadButton);
        JButton cancelButton = new JButton(L10n.getString("new_version.cancel.button"));
        cancelButton.addActionListener(event -> this.dispose());
        buttonPanel.add(cancelButton);
        this.setCancelButton(cancelButton);
        return buttonPanel;
    }
}

