/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.equipe_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.equipe_panel.EquipierEditor;
import fr.geraidv3.desktop.equipe_panel.EquipierTableModel;
import fr.geraidv3.desktop.swing_ext.AbstractTextFieldListener;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.desktop.swing_ext.JCustomTextField;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.Equipier;
import fr.geraidv3.model.equipe.EquipierVector;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.VisibleForTesting;

@ExcludeFromJacocoGeneratedReport
final class EquipeEditor
extends GDialog {
    private final transient DesktopPresenter _presenter;
    private final transient Equipe _equipe;
    private final transient Consumer<Equipe> _updateCallback;
    private final boolean _isCreation;
    private JTable _equipierTable;
    private JTextField _nameTextField;
    private JTextField _bibTextField;
    private JTextField _puceTextField;
    private JTextField _phoneTextField;
    private JComboBox<Categorie> _categorieComboBox;
    private JLabel _errorLabel;
    private JButton _editButton;
    private JButton _removeButton;
    private JCheckBox _notClassifiedCheckBox;
    private JCheckBox _absentOrAbandonCheckbox;
    private JCheckBox _compatibilityCheckBox;
    private JButton _validateButton;

    public EquipeEditor(JFrame parent, DesktopPresenter presenter, Equipe equipe, Consumer<Equipe> updateCallback, boolean isCreation) {
        super(parent);
        this._presenter = presenter;
        this._equipe = equipe;
        this._isCreation = isCreation;
        this._updateCallback = updateCallback;
        this._initializeUI();
        if (this._isCreation) {
            this.setTitle(L10n.getString("equipe_editor.title1"));
        } else {
            this.setTitle(L10n.getString("equipe_editor.title2"));
        }
        this._nameTextField.setText(this._equipe.getName());
        this._bibTextField.setText(this._equipe.getBib());
        this._puceTextField.setText(this._equipe.getPuceIdsAsString());
        this._phoneTextField.setText(this._equipe.getPhone());
        this._notClassifiedCheckBox.setSelected(this._equipe.isNotClassified());
        this._absentOrAbandonCheckbox.setSelected(this._equipe.isAbsent());
        this._categorieComboBox.setModel(new DefaultComboBoxModel<Categorie>(this._presenter.getRaid().getCategorieVector().getCategorieVector()));
        if (this._equipe.getCategorie() != null) {
            this._categorieComboBox.setSelectedItem(this._equipe.getCategorie());
        } else if (this._categorieComboBox.getItemCount() > 0) {
            this._categorieComboBox.setSelectedIndex(0);
        }
        this._equipierTable.setModel(new EquipierTableModel(this._equipe.getEquipierVector()));
        this._validateButton.setEnabled(false);
    }

    @VisibleForTesting
    static boolean _isIntegerSeparatedByComa(String text) {
        if (text.isEmpty()) {
            return true;
        }
        String regex = "^(?:(?>\\d+)(?:,(?>\\d*))*)?$";
        return text.matches(regex);
    }

    private void _updateButtonState() {
        this._validateButton.setEnabled(!this._nameTextField.getText().isEmpty());
    }

    private EquipierVector getEquipiers() {
        return this._equipe.getEquipierVector();
    }

    private void setTableEquipierModel(EquipierTableModel equipierTableModel) {
        this._equipierTable.setModel(equipierTableModel);
    }

    private void _onSelectEquipierTable() {
        if (this._equipierTable.getSelectedRowCount() > 0) {
            this._editButton.setEnabled(true);
            this._removeButton.setEnabled(true);
        } else {
            this._editButton.setEnabled(false);
            this._removeButton.setEnabled(false);
        }
    }

    private void _initializeUI() {
        this.setModal(true);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this._createInformationPanel(), "North");
        pane.add((Component)this._createContentPanel(), "Center");
        pane.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(pane);
        this.pack();
    }

    private JPanel _createInformationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this._createIdentificationPanel());
        panel.add(this._createEquipeStatePanel());
        panel.add(this._createVariantePanel());
        panel.add(this._createCategoriePanel());
        panel.add(this._createPhonePanel());
        return panel;
    }

    private JPanel _createPhonePanel() {
        JPanel categoriePanel = new JPanel(new FlowLayout(0));
        categoriePanel.add(new JLabel(L10n.getString("equipe_editor.phone")));
        categoriePanel.add(this._createPhoneTextField());
        return categoriePanel;
    }

    private JTextField _createPhoneTextField() {
        this._phoneTextField = new JTextField(8);
        this._phoneTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                EquipeEditor.this._updateButtonState();
            }
        });
        return this._phoneTextField;
    }

    private JPanel _createCategoriePanel() {
        JPanel categoriePanel = new JPanel(new FlowLayout(0));
        categoriePanel.add(new JLabel(L10n.getString("equipe_editor.category")));
        categoriePanel.add(this._createCategorieComboBox());
        return categoriePanel;
    }

    private JPanel _createVariantePanel() {
        JPanel variantePanel = new JPanel(new FlowLayout(0));
        variantePanel.add(new JLabel(L10n.getString("equipe_editor.variante")));
        ParcoursVariante variante = this._presenter.getVariante(this._equipe);
        variantePanel.add(new JLabel(variante.getName()));
        return variantePanel;
    }

    private JTextField _createNameTextField() {
        this._nameTextField = new JTextField();
        this._nameTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                EquipeEditor.this._updateButtonState();
            }
        });
        return this._nameTextField;
    }

    private JTextField _createBibTextField() {
        this._bibTextField = new JTextField();
        this._bibTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                EquipeEditor.this._updateButtonState();
            }
        });
        return this._bibTextField;
    }

    private JTextField _createPuceTextField() {
        this._puceTextField = new JCustomTextField(EquipeEditor::_isIntegerSeparatedByComa);
        this._puceTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                EquipeEditor.this._updateButtonState();
            }
        });
        this._puceTextField.setToolTipText(L10n.getString("equipe_editor.multipleChip_text"));
        return this._puceTextField;
    }

    private JComboBox<Categorie> _createCategorieComboBox() {
        this._categorieComboBox = new JComboBox();
        this._categorieComboBox.addActionListener(event -> this._updateButtonState());
        return this._categorieComboBox;
    }

    private JPanel _createIdentificationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 22;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 8);
        panel.add((Component)new JLabel(L10n.getString("equipe_editor.name")), c);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridy = 0;
        c1.gridx = 1;
        c1.anchor = 21;
        c1.weightx = 1.0;
        c1.gridwidth = 3;
        c1.fill = 2;
        panel.add((Component)this._createNameTextField(), c1);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridy = 1;
        c2.gridx = 0;
        c2.anchor = 22;
        c2.weightx = 0.0;
        c2.insets = new Insets(0, 0, 0, 8);
        panel.add((Component)new JLabel(L10n.getString("equipe_editor.bib_number")), c2);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridy = 1;
        c3.gridx = 1;
        c3.anchor = 21;
        c3.weightx = 1.0;
        c3.gridwidth = 3;
        c3.fill = 2;
        panel.add((Component)this._createBibTextField(), c3);
        GridBagConstraints c4 = new GridBagConstraints();
        c4.gridy = 2;
        c4.gridx = 0;
        c4.anchor = 22;
        c4.weightx = 0.0;
        c4.insets = new Insets(0, 0, 0, 8);
        panel.add((Component)new JLabel(L10n.getString("equipe_editor.chip_number")), c4);
        GridBagConstraints c5 = new GridBagConstraints();
        c5.gridy = 2;
        c5.gridx = 1;
        c5.anchor = 21;
        c5.weightx = 1.0;
        c5.gridwidth = 3;
        c5.fill = 2;
        panel.add((Component)this._createPuceTextField(), c5);
        return panel;
    }

    private JPanel _createEquipeStatePanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this._createNotClassifiedCheckBox());
        panel.add(this._createAbsentOrAbandonCheckbox());
        return panel;
    }

    private JCheckBox _createNotClassifiedCheckBox() {
        this._notClassifiedCheckBox = new JCheckBox(L10n.getString("equipe_editor.not_ranked.checkbox"));
        this._notClassifiedCheckBox.addActionListener(event -> this._updateButtonState());
        return this._notClassifiedCheckBox;
    }

    private JPanel _createContentPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("equipe_editor.equipier.title"), 4, 2));
        panel.add((Component)this._createEquipierButtonPanel(), "North");
        panel.add((Component)this._createEquipierPanel(), "Center");
        panel.add((Component)this._createMessagePanel(), "South");
        return panel;
    }

    private JPanel _createMessagePanel() {
        JPanel panelMessage = new JPanel();
        this._errorLabel = new JLabel("");
        this._errorLabel.setForeground(Color.red);
        this._errorLabel.setPreferredSize(new Dimension(340, 55));
        panelMessage.add(this._errorLabel);
        return panelMessage;
    }

    private JPanel _createEquipierPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, L10n.getString("equipe_editor.equipier.title"), 4, 2));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._createEquipierScrollPane());
        return panel;
    }

    private JPanel _createEquipierButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this._createAddButton());
        panel.add(this._createEditButton());
        panel.add(this._createRemoveButton());
        return panel;
    }

    private JButton _createAddButton() {
        IconButton button = new IconButton("add-24.png");
        button.setToolTipText(L10n.getString("equipe_editor.add.button"));
        button.addActionListener(event -> {
            EquipierEditor editor = new EquipierEditor(this, new Equipier(), r -> {
                EquipierVector equipiers = this.getEquipiers();
                equipiers.addEquipier((Equipier)r);
                this.setTableEquipierModel(new EquipierTableModel(equipiers));
                this._updateButtonState();
            }, true);
            editor.setLocationRelativeTo(this);
            editor.setVisible(true);
        });
        return button;
    }

    private JButton _createEditButton() {
        this._editButton = new IconButton("edit-24.png");
        this._editButton.setToolTipText(L10n.getString("equipe_editor.edit.button"));
        this._editButton.setEnabled(false);
        this._editButton.addActionListener(event -> this._editEquipe());
        return this._editButton;
    }

    private void _editEquipe() {
        int row = this._equipierTable.getSelectedRow();
        Equipier selectedEquipier = this._equipe.getEquipierVector().getEquipier((String)this._equipierTable.getValueAt(row, 0), (String)this._equipierTable.getValueAt(row, 1));
        EquipierEditor editor = new EquipierEditor(this, selectedEquipier, r -> {
            EquipierVector equipiers = this.getEquipiers();
            this.setTableEquipierModel(new EquipierTableModel(equipiers));
            this._updateButtonState();
        }, false);
        editor.setLocationRelativeTo(this);
        editor.setVisible(true);
    }

    private JButton _createRemoveButton() {
        this._removeButton = new IconButton("delete-24.png");
        this._removeButton.setToolTipText(L10n.getString("equipe_editor.remove.button"));
        this._removeButton.setEnabled(false);
        this._removeButton.addActionListener(event -> {
            this._equipe.getEquipierVector().removeEquipier((String)this._equipierTable.getValueAt(this._equipierTable.getSelectedRow(), 0), (String)this._equipierTable.getValueAt(this._equipierTable.getSelectedRow(), 1));
            this._equipierTable.setModel(new EquipierTableModel(this._equipe.getEquipierVector()));
            this._onSelectEquipierTable();
        });
        return this._removeButton;
    }

    private JScrollPane _createEquipierScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(200, 80));
        scrollPane.setViewportView(this._createEquipierTable());
        return scrollPane;
    }

    private JTable _createEquipierTable() {
        this._equipierTable = new JTable();
        this._equipierTable.setSelectionMode(0);
        this._equipierTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() > 1) {
                    EquipeEditor.this._editEquipe();
                } else {
                    EquipeEditor.this._onSelectEquipierTable();
                }
            }
        });
        this._equipierTable.getTableHeader().setReorderingAllowed(false);
        return this._equipierTable;
    }

    private JCheckBox _createAbsentOrAbandonCheckbox() {
        this._absentOrAbandonCheckbox = new JCheckBox(L10n.getString("equipe_editor.absent.checkbox"));
        this._absentOrAbandonCheckbox.addActionListener(event -> this._updateButtonState());
        return this._absentOrAbandonCheckbox;
    }

    private JPanel _createButtonPanel() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        JPanel panel = new JPanel(new FlowLayout(0));
        this._compatibilityCheckBox = new JCheckBox(L10n.getString("equipe_editor.compatibility.checkbox"));
        this._compatibilityCheckBox.setSelected(true);
        this._compatibilityCheckBox.addActionListener(event -> this._updateButtonState());
        panel.add(this._compatibilityCheckBox);
        pane.add(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 10, 5));
        if (this._isCreation) {
            buttonPanel.add(this._createValidateCreationButton());
        } else {
            buttonPanel.add(this._createValidateEditionButton());
        }
        buttonPanel.add(this._createCancelButton());
        pane.add(buttonPanel);
        return pane;
    }

    private boolean _isInputsInvalid() {
        if (this._nameTextField.getText().trim().isEmpty()) {
            DesktopView.beep();
            this._errorLabel.setText(L10n.getString("equipe_editor.error1"));
            return true;
        }
        return false;
    }

    private JButton _createValidateCreationButton() {
        this._validateButton = new JButton(L10n.getString("equipe_editor.validate.button1"));
        this.setDefaultButton(this._validateButton);
        this._validateButton.addActionListener(event -> {
            if (this._isInputsInvalid()) {
                return;
            }
            try {
                this._presenter.createEquipe(this._equipe, this._nameTextField.getText(), this._bibTextField.getText(), this._puceTextField.getText(), this._notClassifiedCheckBox.isSelected(), this._absentOrAbandonCheckbox.isSelected(), (Categorie)this._categorieComboBox.getSelectedItem(), this._compatibilityCheckBox.isSelected(), this._phoneTextField.getText());
                this._updateCallback.accept(this._equipe);
                this.dispose();
            }
            catch (Exception exception) {
                DesktopView.beep();
                this._errorLabel.setText(exception.getMessage());
            }
        });
        return this._validateButton;
    }

    private JButton _createValidateEditionButton() {
        this._validateButton = new JButton(L10n.getString("equipe_editor.validate.button2"));
        this.setDefaultButton(this._validateButton);
        this._validateButton.addActionListener(event -> {
            if (this._isInputsInvalid()) {
                return;
            }
            try {
                this._presenter.modifyEquipe(this._equipe, this._nameTextField.getText(), this._bibTextField.getText(), this._puceTextField.getText(), this._notClassifiedCheckBox.isSelected(), this._absentOrAbandonCheckbox.isSelected(), (Categorie)this._categorieComboBox.getSelectedItem(), this._compatibilityCheckBox.isSelected(), this._phoneTextField.getText());
                this.dispose();
            }
            catch (Exception exception) {
                DesktopView.beep();
                this._errorLabel.setText(exception.getMessage());
            }
        });
        return this._validateButton;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        this.setCancelButton(button);
        button.addActionListener(event -> this.dispose());
        return button;
    }
}

