/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.equipe_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.PuceResultManagementDialog;
import fr.geraidv3.desktop.equipe_panel.BibNumberingDialog;
import fr.geraidv3.desktop.equipe_panel.EquipeDisplacementDialog;
import fr.geraidv3.desktop.equipe_panel.EquipeEditor;
import fr.geraidv3.desktop.equipe_panel.EquipeImportDialog;
import fr.geraidv3.desktop.equipe_panel.EquipePanelView;
import fr.geraidv3.desktop.equipe_panel.EquipeSearchDialogFromEquipeName;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.desktop.swing_ext.MyComboBox;
import fr.geraidv3.model.SortType;
import fr.geraidv3.model.equipe.CsvEquipeHelper;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;

final class EquipePanelPresenter {
    private final DesktopPresenter _desktopPresenter;
    private final DesktopView _desktopView;
    private final EquipePanelView _equipePanelView;
    private final JList<Equipe> _equipeList;

    EquipePanelPresenter(EquipePanelView equipePanelView, DesktopPresenter desktopPresenter, DesktopView desktopView, JList<Equipe> equipeList) {
        this._equipePanelView = equipePanelView;
        this._desktopPresenter = desktopPresenter;
        this._desktopView = desktopView;
        this._equipeList = equipeList;
    }

    public void resetParcoursVarianteComboBox() {
        this._desktopPresenter.getParcoursComboBox().setSelectedIndex(0);
    }

    public boolean hasResult(Equipe equipe) {
        Vector<Equipe> equipesForEtape = this._desktopPresenter.getRaid().getPuceResultVector().getEquipesForEtape(this._desktopView.getSelectedEtape());
        return equipesForEtape.contains(equipe);
    }

    public void numberAllBibs() {
        EquipeVector equipes = this._getSelectedParcours().getEquipeVector();
        BibNumberingDialog dialog = new BibNumberingDialog(this._desktopView, values -> {
            equipes.renumberEquipeBibs((String)values[0], (Integer)values[1], (String)values[2]);
            this._equipeList.repaint();
            this._desktopPresenter.setModified(true);
        });
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public void exportEquipes(String fileName) {
        try {
            CsvEquipeHelper._exportEquipes(this._desktopPresenter.getRaid(), fileName);
        }
        catch (Exception exception) {
            ErrorPane.showMessageDialog(this._desktopView, exception.getMessage());
        }
    }

    public void searchEquipe() {
        EquipeSearchDialogFromEquipeName dialog = new EquipeSearchDialogFromEquipeName(this._desktopView, this._desktopPresenter, e -> {
            Parcours parcours = this._desktopPresenter.getRaid().getParcoursVector().getParcoursOfEquipe((Equipe)e);
            if (parcours != null) {
                JComboBox<Parcours> comboParcours = this._desktopPresenter.getParcoursComboBox();
                comboParcours.setSelectedItem(parcours);
                ParcoursVariante variante = parcours.getVarianteFromEquipe((Equipe)e);
                MyComboBox<ParcoursVariante> varianteCombBox = this._desktopPresenter.getVarianteComboBox();
                varianteCombBox.setSelectedValue(variante);
                this._desktopPresenter.getEquipeList().setSelectedValue(e, true);
            }
        });
        dialog.setLocationRelativeTo(this._desktopView);
        dialog.setVisible(true);
    }

    boolean hasEquipes() {
        return this._equipeList.getModel().getSize() > 0;
    }

    String getRaidFolderPath() {
        return this._desktopPresenter.getRaidFolderPath();
    }

    void setLastOpenDirectory(File path) {
        this._desktopPresenter.setLastOpenDirectory(path);
    }

    void addEquipe() {
        EquipeEditor editor = new EquipeEditor(this._desktopView, this._desktopPresenter, new Equipe(this._desktopPresenter.getRaid().getPuceResultVector()), e -> {
            this._equipePanelView.update(this._desktopPresenter);
            this._desktopPresenter.setModified(true);
        }, true);
        editor.setLocationRelativeTo(null);
        editor.setVisible(true);
        this._equipePanelView.updateEquipeTotal(this._getSelectedVariante().getNumberOfEquipes());
    }

    void editCurrentSelectedEquipe(Equipe equipe) {
        EquipeEditor editor = new EquipeEditor(this._desktopView, this._desktopPresenter, equipe, e -> this._desktopPresenter.setModified(true), false);
        editor.setLocationRelativeTo(null);
        editor.setVisible(true);
    }

    void deleteCurrentSelectedEquipes(List<Equipe> equipes) {
        if (this._getSelectedParcours() != null) {
            int reply = JOptionPane.showConfirmDialog(this._desktopView.getRootPane(), equipes.size() == 1 ? L10n.getString("equipe_panel.delete.message1", equipes.get(0)) : L10n.getString("equipe_panel.delete.message2", equipes.size()), L10n.getString("equipe_panel.delete.acknowledgment"), 0, 3);
            if (reply == 0) {
                this._deleteEquipesAndRepaint(equipes);
                this._desktopPresenter.setModified(true);
            }
            if (this._getSelectedVariante() != null) {
                this._equipePanelView.updateEquipeTotal(this._getSelectedVariante().getNumberOfEquipes());
            } else {
                this._equipePanelView.updateEquipeTotal(this._getSelectedParcours().getTotalNumberOfEquipes());
            }
        }
    }

    void readSportIdentPuce() {
        if (!this._desktopPresenter.getSportIdentPuceReaderInUse()) {
            String port = this._desktopView.getSelectedPort();
            if (port != null) {
                this._desktopPresenter.setSportIdentPucePortName(port);
                if (this._desktopPresenter.startSportIdentPuce()) {
                    this._equipePanelView.changePuceReaderIcon("wait-24.png");
                    this._desktopPresenter.setSportIdentPuceReaderInUse(true);
                    this._desktopView.setButtonSportIdentReaderEnabled(false);
                } else {
                    ErrorPane.showMessageDialog(this._desktopView, L10n.getString("equipe_panel.chip.error1"));
                }
            } else {
                ErrorPane.showMessageDialog(this._desktopView, L10n.getString("equipe_panel.chip.error2"));
            }
        } else {
            this._desktopPresenter.stopSportIdentPuce();
            this._equipePanelView.changePuceReaderIcon("play-24.png");
            this._desktopPresenter.setSportIdentPuceReaderInUse(false);
            this._desktopView.setButtonSportIdentReaderEnabled(true);
        }
    }

    void sortEquipes() {
        SortType sortType = (SortType)((Object)JOptionPane.showInputDialog(this._desktopView.getRootPane(), L10n.getString("equipe_panel.sort.title"), L10n.getString("equipe_panel.sort.message"), -1, null, (Object[])SortType.values(), (Object)SortType.values()[0]));
        if (sortType != null) {
            this._desktopView.setCurrentSelectedType(sortType);
            this._getSelectedParcours().sortEquipes(sortType);
            this._desktopPresenter.updateEquipes();
        }
    }

    void moveEquipesToAnotherParcours(List<Equipe> equipes) {
        if (this._equipeList.getSelectedIndex() > -1) {
            EquipeDisplacementDialog view = new EquipeDisplacementDialog(this._desktopView, this._desktopPresenter, equipes, targetVariante -> {
                this._moveEquipesToVariante(equipes, (ParcoursVariante)targetVariante);
                this._desktopPresenter.setModified(true);
            });
            view.setLocationRelativeTo(null);
            view.setVisible(true);
        }
    }

    void displaySportIdentPuceResults(Equipe equipe) {
        PuceResultManagementDialog dialog = new PuceResultManagementDialog(this._desktopView, this._desktopPresenter, this._getSelectedParcours(), this._desktopView.getSelectedEtape(), equipe);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    void exportEquipeCsvTemplate(String fileName) {
        CsvEquipeHelper.exportEquipesTemplate(fileName);
    }

    void exportPuceCsvTemplate(String fileName) {
        CsvEquipeHelper.exportPucesTemplate(fileName);
    }

    void createEquipeImportDialog() {
        EquipeImportDialog equipeImportDialog = new EquipeImportDialog(this._desktopView, this, this._desktopPresenter.getRaid().getParcoursVector());
        equipeImportDialog.setLocationRelativeTo(this._desktopView);
        equipeImportDialog.setVisible(true);
    }

    void importEquipeWithTwoFiles(String equipeFile, String puceFile, Map<String, Integer> vacantEquipeParcours, int numberOfPucesPerEquipe) throws IOException {
        CsvEquipeHelper.importEquipesAndPuces(this._desktopPresenter.getRaid(), equipeFile, puceFile, vacantEquipeParcours, numberOfPucesPerEquipe);
        Parcours parcours = this._getSelectedParcours();
        assert (parcours != null);
        this._equipeList.setListData(parcours.getEquipeVector().getEquipeVector());
        this._equipeList.repaint();
        if (this._equipeList.getModel().getSize() > 0) {
            this._equipeList.setSelectedIndex(0);
        }
        this._desktopPresenter.setModified(true);
    }

    void importEquipeWithOneFile(String fileName) throws IOException {
        CsvEquipeHelper.importEquipesUniqueFile(this._desktopPresenter.getRaid(), fileName);
        Parcours parcours = this._getSelectedParcours();
        assert (parcours != null);
        this._equipeList.setListData(parcours.getEquipeVector().getEquipeVector());
        this._equipeList.repaint();
        if (this._equipeList.getModel().getSize() > 0) {
            this._equipeList.setSelectedIndex(0);
        }
        this._desktopPresenter.setModified(true);
    }

    private void _deleteEquipesAndRepaint(List<Equipe> equipes) {
        Parcours parcours = this._getSelectedParcours();
        for (Equipe equipe : equipes) {
            parcours.removeEquipe(equipe);
        }
        this._equipeList.setListData(parcours.getEquipeVector().getEquipeVector());
        this._equipeList.repaint();
        if (this._equipeList.getModel().getSize() == 0) {
            this._equipeList.setSelectedIndex(-1);
        } else {
            this._equipeList.setSelectedIndex(0);
        }
    }

    private void _moveEquipesToVariante(List<Equipe> equipes, ParcoursVariante targetVariante) {
        Parcours sourceParcours = this._getSelectedParcours();
        for (Equipe equipe : equipes) {
            ParcoursVariante sourceVariante = sourceParcours.getVarianteFromEquipe(equipe);
            if (targetVariante.equals(sourceVariante)) continue;
            targetVariante.transferEquipe(equipe);
            this._desktopPresenter.getRaid().removePuceResultForEquipe(equipe);
            sourceVariante.getEquipeVector().removeEquipe(equipe);
        }
        if (this._getSelectedVariante() == null) {
            this._equipeList.setListData(this._getSelectedParcours().getEquipeVector().getEquipeVector());
            this._equipePanelView.updateEquipeTotal(this._getSelectedParcours().getTotalNumberOfEquipes());
        } else {
            this._equipeList.setListData(this._getSelectedVariante().getEquipeVector().getEquipeVector());
            this._equipePanelView.updateEquipeTotal(this._getSelectedVariante().getNumberOfEquipes());
        }
        this._equipeList.setSelectedIndex(this._equipeList.getModel().getSize() > 0 ? 0 : -1);
    }

    private ParcoursVariante _getSelectedVariante() {
        return this._desktopView.getSelectedVariante();
    }

    private Parcours _getSelectedParcours() {
        return this._desktopView.getSelectedParcours();
    }
}

