/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.equipe_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.equipe_panel.SearchStrategy;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

@ExcludeFromJacocoGeneratedReport
public class EquipeSearchDialogFromEquipeName
extends GDialog {
    private final transient DesktopPresenter _presenter;
    private final transient Consumer<Equipe> _updateCallback;
    private JTabbedPane _tabbedPane;

    public EquipeSearchDialogFromEquipeName(JFrame parent, DesktopPresenter presenter, Consumer<Equipe> updateCallback) {
        super(parent);
        this._presenter = presenter;
        this._updateCallback = updateCallback;
        this._initializeUI();
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setTitle(L10n.getString("equipe_search_dialog.title"));
        this.setContentPane(this._createJContentPane());
        this.pack();
        ((EquipeSearchPanel)this._tabbedPane.getComponent((int)0))._queryField.requestFocusInWindow();
    }

    private JPanel _createJContentPane() {
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.add(L10n.getString("equipe_search_dialog.name"), new EquipeSearchPanel(L10n.getString("equipe_search_dialog.equipe.label"), this._presenter.getRaid().getEquipeVector().getEquipeVector(), query -> this._presenter.getRaid().getAllEquipesThatNameContains(query)));
        this._tabbedPane.add(L10n.getString("equipe_search_dialog.puce"), new EquipeSearchPanel(L10n.getString("equipe_search_dialog.puce.label"), this._presenter.getRaid().getEquipeVector().getEquipeVector(), query -> this._presenter.getRaid().getAllEquipesThatPuceIdContains(query)));
        this._tabbedPane.add(L10n.getString("equipe_search_dialog.equipier"), new EquipeSearchPanel(L10n.getString("equipe_search_dialog.equipier.label"), this._presenter.getRaid().getEquipeVector().getEquipeVector(), query -> this._presenter.getRaid().getAllEquipesThatEquipierNameContains(query)));
        this._tabbedPane.getModel().addChangeListener(e -> {
            EquipeSearchPanel tab = (EquipeSearchPanel)this._tabbedPane.getSelectedComponent();
            tab._queryField.requestFocusInWindow();
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this._tabbedPane, "Center");
        panel.add((Component)this._createButtonPanel(), "South");
        return panel;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createValidateButton() {
        JButton button = new JButton(L10n.getString("equipe_search_dialog.button"));
        button.addActionListener(event -> this._validateSelection());
        this.setDefaultButton(button);
        return button;
    }

    private void _validateSelection() {
        EquipeSearchPanel selectedComponent = (EquipeSearchPanel)this._tabbedPane.getSelectedComponent();
        Equipe equipe = selectedComponent._selectTeam();
        if (equipe != null) {
            this._updateCallback.accept(equipe);
            this.dispose();
        }
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.setHorizontalTextPosition(0);
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }

    class EquipeSearchPanel
    extends JPanel {
        private final SearchStrategy _searchMethod;
        private final JList<Equipe> _equipeList;
        private final JTextField _queryField;
        private final String _label;

        EquipeSearchPanel(String label, Vector<Equipe> equipeList, SearchStrategy searchMethod) {
            this._label = label;
            this._searchMethod = searchMethod;
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this._queryField = new JTextField();
            this._equipeList = new JList<Equipe>(equipeList);
            this.add((Component)this._createSearchTextField(), "North");
            this.add((Component)this._getScrollPane(), "Center");
        }

        private JTextField _createNameTextField() {
            this._queryField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent event) {
                    EquipeVector allEquipesWhoseNameContains = EquipeSearchPanel.this._searchMethod.getEquipes(EquipeSearchPanel.this._queryField.getText());
                    EquipeSearchPanel.this._equipeList.setListData(allEquipesWhoseNameContains.getEquipeVector());
                    if (allEquipesWhoseNameContains.getSize() > 0) {
                        EquipeSearchPanel.this._equipeList.setSelectedIndex(0);
                    }
                    EquipeSearchPanel.this._equipeList.repaint();
                }
            });
            return this._queryField;
        }

        private JPanel _createSearchTextField() {
            JPanel panel = new JPanel(new BorderLayout(5, 0));
            panel.add((Component)new JLabel(this._label), "West");
            panel.add((Component)this._createNameTextField(), "Center");
            return panel;
        }

        private JComponent _getScrollPane() {
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setPreferredSize(new Dimension(340, 250));
            scrollPane.setViewportView(this._getTeamList());
            return scrollPane;
        }

        private JList<Equipe> _getTeamList() {
            this._equipeList.setSelectionMode(0);
            this._equipeList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() > 1) {
                        EquipeSearchDialogFromEquipeName.this._validateSelection();
                    }
                }
            });
            return this._equipeList;
        }

        private Equipe _selectTeam() {
            if (this._equipeList.getSelectedIndex() > -1) {
                return this._equipeList.getSelectedValue();
            }
            return null;
        }
    }
}

