/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.equipe_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.AbstractTextFieldListener;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.equipe.Equipier;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

@ExcludeFromJacocoGeneratedReport
final class EquipierEditor
extends GDialog {
    private final transient Consumer<Equipier> _updateCallback;
    private final transient Equipier _equipier;
    private final boolean _creationFlag;
    private JTextField _lastnameTextField;
    private JTextField _firstnameTextField;
    private JButton _validationButton;

    public EquipierEditor(JDialog parent, Equipier equipier, Consumer<Equipier> updateCallback, boolean creationFlag) {
        super(parent);
        this._equipier = equipier;
        this._updateCallback = updateCallback;
        this._creationFlag = creationFlag;
        this._initializeUI();
        if (this._creationFlag) {
            this.setTitle(L10n.getString("raid_dialog.title1"));
        } else {
            this.setTitle(L10n.getString("raid_dialog.title2"));
        }
        this._lastnameTextField.setText(this._equipier.getLastname());
        this._firstnameTextField.setText(this._equipier.getFirstname());
        this._validationButton.setEnabled(false);
    }

    private void _initializeUI() {
        this.setModal(true);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this._createContentPanel(), "Center");
        contentPane.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(contentPane);
        this.pack();
    }

    private JPanel _createContentPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this._createIdentificationPanel());
        return panel;
    }

    private JPanel _createIdentificationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c11 = new GridBagConstraints();
        c11.gridy = 0;
        c11.gridx = 0;
        c11.anchor = 22;
        c11.weightx = 0.0;
        c11.ipadx = 5;
        panel.add((Component)new JLabel(L10n.getString("lastname")), c11);
        GridBagConstraints c12 = new GridBagConstraints();
        c12.gridy = 0;
        c12.gridx = 1;
        c12.anchor = 21;
        c12.weightx = 1.0;
        c12.gridwidth = 3;
        c12.fill = 2;
        panel.add((Component)this._createLastnameTextField(), c12);
        GridBagConstraints c21 = new GridBagConstraints();
        c21.gridy = 1;
        c21.gridx = 0;
        c21.anchor = 22;
        c21.weightx = 0.0;
        c21.ipadx = 5;
        panel.add((Component)new JLabel(L10n.getString("firstname")), c21);
        GridBagConstraints c22 = new GridBagConstraints();
        c22.gridy = 1;
        c22.gridx = 1;
        c22.anchor = 21;
        c22.weightx = 1.0;
        c22.gridwidth = 3;
        c22.fill = 2;
        panel.add((Component)this._createFirstnameTextField(), c22);
        return panel;
    }

    private JTextField _createLastnameTextField() {
        this._lastnameTextField = new JTextField();
        this._lastnameTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                EquipierEditor.this._enableValidateButtonIfSettingsCompleted();
            }
        });
        return this._lastnameTextField;
    }

    private JTextField _createFirstnameTextField() {
        this._firstnameTextField = new JTextField();
        this._firstnameTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                EquipierEditor.this._enableValidateButtonIfSettingsCompleted();
            }
        });
        return this._firstnameTextField;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createValidateButton() {
        this._validationButton = this._creationFlag ? new JButton(L10n.getString("raid_dialog.button.label1")) : new JButton(L10n.getString("raid_dialog.button.label2"));
        this._validationButton.addActionListener(event -> {
            this._equipier.setLastname(this._lastnameTextField.getText().trim());
            this._equipier.setFirstname(this._firstnameTextField.getText().trim());
            this._updateCallback.accept(this._equipier);
            this.dispose();
        });
        this.setDefaultButton(this._validationButton);
        return this._validationButton;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }

    private void _enableValidateButtonIfSettingsCompleted() {
        this._validationButton.setEnabled(!this._firstnameTextField.getText().trim().isEmpty() || !this._lastnameTextField.getText().trim().isEmpty());
    }
}

