/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.equipe_panel;

import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.sportident_panel.SportIdentStationState;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.parcours.Parcours;
import java.io.IOException;
import net.gecosi.CommStatus;
import net.gecosi.SportIdentHandler;
import net.gecosi.SportIdentListener;
import net.gecosi.dataframe.SportIdentDataFrame;

public final class SportIdentPuceReaderInEquipePanel
implements SportIdentListener {
    private final DesktopPresenter _presenter;
    private final Raid _raid;
    private String _portName = "";
    private SportIdentHandler _portHandler;

    public SportIdentPuceReaderInEquipePanel(Raid raid, DesktopPresenter presenter) {
        this._raid = raid;
        this._presenter = presenter;
    }

    public boolean start() {
        if (this._portHandler == null) {
            this._portHandler = new SportIdentHandler(this);
        }
        this._portHandler.setZeroHourInMilliseconds(0L);
        try {
            this._portHandler.connect(this._portName);
            return true;
        }
        catch (SerialPortInvalidPortException | IOException ignored) {
            return false;
        }
    }

    public void stop() {
        if (this._portHandler != null) {
            this._portHandler.stop();
        }
    }

    @Override
    public void handleEcard(SportIdentDataFrame puce) {
        if (this._raid.existsPuce(puce.getSiNumber())) {
            ErrorPane.showMessageDialog(this._presenter.getFrame(), L10n.getString("sport_ident_puce_reader_handler.error1"));
        } else {
            Parcours parcours = (Parcours)this._presenter.getParcoursComboBox().getSelectedItem();
            if (parcours == null) {
                ErrorPane.showMessageDialog(this._presenter.getFrame(), L10n.getString("sport_ident_puce_reader_handler.error3"));
                return;
            }
            Equipe equipe = this._raid.getEquipeWithoutPuceFromIndex(parcours, this._presenter.getEquipeList().getSelectedIndex());
            if (equipe != null) {
                equipe.addPuceId(puce.getSiNumber());
                this._presenter.getEquipeList().repaint();
            } else {
                ErrorPane.showMessageDialog(this._presenter.getFrame(), L10n.getString("sport_ident_puce_reader_handler.error2"));
            }
        }
    }

    public void setPortName(String portName) {
        this._portName = portName;
    }

    @Override
    public void notify(CommStatus status) {
        if (status == CommStatus.ON) {
            this._presenter.displayStationStatus(SportIdentStationState.READY);
        }
    }

    @Override
    public void notify(CommStatus errorStatus, String errorMessage) {
        this._presenter.displayStationStatus(SportIdentStationState.FAILED);
    }
}

