/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.file_panel;

import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.file_panel.AutomaticSavingThread;
import fr.geraidv3.desktop.file_panel.FilePanelView;
import fr.geraidv3.model.equipe.CsvEquipeHelper;
import fr.geraidv3.utils.FileUtils;

final class FilePanelPresenter {
    private final FilePanelView _filePanelView;
    private final DesktopPresenter _desktopPresenter;
    private AutomaticSavingThread _backupTask;

    FilePanelPresenter(FilePanelView filePanelView, DesktopPresenter desktopPresenter) {
        this._filePanelView = filePanelView;
        this._desktopPresenter = desktopPresenter;
    }

    public void backupCurrentRaid() {
        this._desktopPresenter.backupCurrentRaid();
    }

    boolean backupFolderExists() {
        return this._desktopPresenter.backupFolderExists();
    }

    long getBackupFrequency() {
        return this._filePanelView.getBackupFrequencyInMn();
    }

    void setBackUpStateOk() {
        this._filePanelView.setBackupOkState();
    }

    void setBackupStateNotOk() {
        this._filePanelView.setBackupNotOkState();
    }

    void setBackupStateNormal() {
        this._filePanelView.setBackupNormalState();
    }

    void backup() {
        this._desktopPresenter.backup();
    }

    void createNewRaidFile() {
        this._desktopPresenter.createNewRaidWithSavingConfirmation();
    }

    void openRaidFile() {
        this._desktopPresenter.openRaidFile();
    }

    void saveCurrentRaid() {
        this._desktopPresenter.saveCurrentRaid();
    }

    String getRaidFolderPath() {
        return this._desktopPresenter.getRaidFolderPath();
    }

    void exportToCsv(String absolutePath) {
        String fileName = FileUtils.checkExtension(absolutePath, ".csv");
        CsvEquipeHelper._exportEquipes(this._desktopPresenter.getRaid(), fileName);
    }

    void startOrStopBackup() {
        if (this._backupTask != null) {
            this._backupTask.stop();
            this._backupTask = null;
            this._filePanelView.stopBackupButton();
        } else {
            boolean start = this._filePanelView.chooseFrequencyDialog();
            if (start) {
                this._backupTask = new AutomaticSavingThread(this);
                this._backupTask.execute();
                this._filePanelView.startBackupButton();
            }
        }
    }
}

