/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.help_menu;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.LookAndFeelTheme;
import fr.geraidv3.desktop.help_menu.DisabledItemSelectionModel;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

@ExcludeFromJacocoGeneratedReport
final class AboutView
extends GDialog {
    private static final String[] CREATOR_NAMES = new String[]{"Thierry PORRET (logiciel GeRaid)", "Simon DENIER (biblioth\u00e8que SPORTIdent)"};
    private static final String[] DEVELOPER_NAMES = new String[]{"R\u00e9gis CLOUARD", "Eric PIGEON", "Martin FEAUX DE LA CROIX", "Lucas DEMAIMAY"};
    private static final String URL = "https://gitlab.com/clouardregis/geraidv3";
    private JLabel _titleLabel1;
    private JLabel _titleLabel2;
    private JList<String> _creatorsList;
    private JList<String> _developersList;
    private JLabel _licenseLabel;
    private JLabel _versionLabel;
    private JLabel _projectUrlLabel;

    public AboutView() {
        this._initializeUI();
        this._titleLabel1.setText(L10n.getString("about_view.title1"));
        this._titleLabel2.setText(L10n.getString("about_view.title2"));
        this._creatorsList.setListData((String[])CREATOR_NAMES);
        this._developersList.setListData((String[])DEVELOPER_NAMES);
        String version = L10n.getString("about_view.text1", GeRaidV3.SessionLauncher.getVersion());
        this._versionLabel.setText(version);
        this._licenseLabel.setText(L10n.getString("about_view.license"));
        this._projectUrlLabel.setText(L10n.getString("about_view.notice"));
        AboutView.addDismissibleBehaviour(this);
        this.pack();
    }

    private static void addDismissibleBehaviour(final AboutView aboutView) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addVetoableChangeListener("focusedWindow", new VetoableChangeListener(){
            private boolean gained = false;

            @Override
            public void vetoableChange(PropertyChangeEvent event) {
                if (event.getNewValue() == aboutView) {
                    this.gained = true;
                }
                if (this.gained && event.getNewValue() != aboutView) {
                    aboutView.dispose();
                }
            }
        });
    }

    private void _initializeUI() {
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setTitle(L10n.getString("help_menu.about.item"));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setContentPane(this._createBackgroundPanel());
    }

    private JPanel _createBackgroundPanel() {
        JPanel panel = new JPanel(new BorderLayout(3, 0));
        Border blackLine = BorderFactory.createLineBorder(Color.black);
        Border emptyBorder = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(blackLine, emptyBorder);
        panel.setBorder(compoundBorder);
        panel.setLocation(new Point(0, 16));
        panel.add((Component)this._createLogoPanel(), "West");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this._createTitlePanel(), "North");
        panel2.add((Component)this._createAuthorsPanel(), "Center");
        panel2.add((Component)this._createLicensePanel(), "South");
        panel.add((Component)panel2, "Center");
        return panel;
    }

    private JPanel _createLogoPanel() {
        JLabel label = new JLabel();
        label.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("fr/geraidv3/icon/logo64.png")));
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setOpaque(true);
        panel.setBackground(LookAndFeelTheme.ACCENT_COLOR);
        panel.add(label);
        return panel;
    }

    private JPanel _createAuthorsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(true);
        panel.setBorder(BorderFactory.createEtchedBorder(0));
        this._creatorsList = new JList();
        this._creatorsList.setSelectionModel(new DisabledItemSelectionModel());
        JPanel panel1 = new JPanel(new FlowLayout(0));
        panel1.setBorder(new LineBorder(Color.GRAY));
        panel1.setBackground(Color.WHITE);
        panel1.add(this._creatorsList);
        JLabel label1 = new JLabel(L10n.getString("about_view.text2"));
        label1.setAlignmentX(1.0f);
        panel.add(label1);
        panel.add(panel1);
        this._developersList = new JList();
        this._developersList.setSelectionModel(new DisabledItemSelectionModel());
        this._developersList.setVisibleRowCount(5);
        JScrollPane panel2 = new JScrollPane(this._developersList);
        JLabel label2 = new JLabel(L10n.getString("about_view.text3"));
        label2.setAlignmentX(1.0f);
        panel.add(label2);
        panel.add(panel2);
        return panel;
    }

    private JPanel _createLicensePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(10, 0, 10, 0));
        panel.setOpaque(false);
        this._licenseLabel = new JLabel();
        this._licenseLabel.setHorizontalAlignment(0);
        panel.add(this._licenseLabel);
        this._projectUrlLabel = new JLabel();
        this._projectUrlLabel.setHorizontalAlignment(0);
        this._projectUrlLabel.setCursor(new Cursor(12));
        this._projectUrlLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    Desktop.getDesktop().browse(new URI(AboutView.URL));
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        });
        panel.add(this._projectUrlLabel);
        return panel;
    }

    private JPanel _createTitlePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this._titleLabel1 = new JLabel();
        panel.add(this._titleLabel1);
        this._titleLabel2 = new JLabel();
        panel.add(this._titleLabel2);
        this._versionLabel = new JLabel();
        this._versionLabel.setForeground(LookAndFeelTheme.WARNING_COLOR);
        this._versionLabel.setHorizontalAlignment(0);
        panel.add(this._versionLabel);
        return panel;
    }
}

