/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.help_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.help_menu.HelpPresenter;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

@ExcludeFromJacocoGeneratedReport
public final class HelpMenu
extends JMenu {
    private final transient HelpPresenter _presenter = new HelpPresenter();
    private final DesktopView _desktopView;

    public HelpMenu(DesktopView desktopView) {
        super(L10n.getString("help_menu.help.title"));
        this._desktopView = desktopView;
        this.add(this._createMenuItemTroubleshootingHelp());
        this.add(this._createMenuItemHelp());
        this.add(new JSeparator());
        this.add(this._createMenuItemAbout());
    }

    private JMenuItem _createMenuItemTroubleshootingHelp() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("help_menu.troubleshooting.item"));
        menuItem.addActionListener(event -> this._presenter.displayTroubleshootingHelp(this._desktopView));
        return menuItem;
    }

    private JMenuItem _createMenuItemHelp() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("help_menu.help.item"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        menuItem.addActionListener(event -> this._presenter.displayHelp(this._desktopView));
        return menuItem;
    }

    private JMenuItem _createMenuItemAbout() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("help_menu.about.item"));
        menuItem.addActionListener(event -> this._presenter.displayAbout());
        return menuItem;
    }
}

