/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_file;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.raid_file.UnassignedPuceException;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.GlobalSettings;
import fr.geraidv3.model.LimitType;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.StartType;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.balise.BaliseVector;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveFactory;
import fr.geraidv3.model.epreuve.EpreuveType;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.epreuve.GelEpreuveFactory;
import fr.geraidv3.model.epreuve.StandardEpreuveFactory;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.equipe.Equipier;
import fr.geraidv3.model.equipe.EquipierVector;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.etape.EtapeEpreuveMap;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.result.penalite.Penalite;
import fr.geraidv3.result.penalite.PenaliteIndividuelle;
import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.result.puce.Puce;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.utils.DateTimeUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RaidFileXmlReader {
    public static void readRaidFile(Raid raid, String raidFile, GlobalSettings globalSettings) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream input = new FileInputStream(raidFile);
            InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);
            Document document = builder.parse(new InputSource(reader));
            document.getDocumentElement().normalize();
            RaidFileXmlReader._readSettings(raid, document);
            RaidFileXmlReader._readCategories(raid, document);
            RaidFileXmlReader._readParcours(raid, document, globalSettings);
            RaidFileXmlReader._readResults(raid, document);
            RaidFileXmlReader._readPenalties(raid, document);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("xml_raid.read.error1", e.getClass().getName(), e.getMessage()));
        }
        catch (UnassignedPuceException e) {
            ErrorPane.showLargeMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("xml_raid.read.error2", e.getMessage()));
        }
    }

    private static void _readSettings(Raid geRaid, Document document) {
        geRaid.setRaidName(RaidFileXmlReader._getChildText(document, "nom"));
        geRaid.setPrintHeader(RaidFileXmlReader._getChildText(document, "entete"));
        geRaid.setPrintFooter(RaidFileXmlReader._getChildText(document, "piedPage"));
        if (document.getElementsByTagName("hzh") != null) {
            geRaid.getHourZero().setHours(Integer.parseInt(RaidFileXmlReader._getChildText(document, "hzh")));
            geRaid.getHourZero().setMinutes(Integer.parseInt(RaidFileXmlReader._getChildText(document, "hzm")));
        }
    }

    private static void _readCategories(Raid geRaid, Document document) {
        Element root = (Element)document.getElementsByTagName("categories").item(0);
        NodeList categoryElements = root.getElementsByTagName("categorie");
        for (int i = 0; i < categoryElements.getLength(); ++i) {
            Element element = (Element)categoryElements.item(i);
            Categorie category = new Categorie(RaidFileXmlReader._getChildText(element, "nomLong"), RaidFileXmlReader._getChildText(element, "nomCourt"));
            geRaid.addCategorie(category);
        }
    }

    private static void _readParcours(Raid geRaid, Document racine, GlobalSettings globalSettings) {
        Element root = (Element)racine.getElementsByTagName("parcourss").item(0);
        NodeList parcoursElements = root.getElementsByTagName("parcours");
        for (int i = 0; i < parcoursElements.getLength(); ++i) {
            Element parcoursElement = (Element)parcoursElements.item(i);
            Parcours parcours = new Parcours(RaidFileXmlReader._getChildText(parcoursElement, "nom").trim());
            if (parcoursElement.getElementsByTagName("variantes").item(0) != null) {
                parcours.setEtapeEpreuveMap(RaidFileXmlReader._readEtapes(parcoursElement, "etapeModel", globalSettings));
                Element rootOfParcours = (Element)parcoursElement.getElementsByTagName("variantes").item(0);
                NodeList varianteElements = rootOfParcours.getElementsByTagName("variante");
                for (int j = 0; j < varianteElements.getLength(); ++j) {
                    Element varianteElement = (Element)varianteElements.item(j);
                    ParcoursVariante variante = new ParcoursVariante(RaidFileXmlReader._getChildText(varianteElement, "nom").trim());
                    variante.setEquipeVector(RaidFileXmlReader._readEquipes(geRaid, varianteElement));
                    variante.setEtapeEpreuveMap(RaidFileXmlReader._readEtapes(varianteElement, "etape", globalSettings));
                    parcours.addVariante(variante);
                }
            } else {
                parcours.setEtapeEpreuveMap(RaidFileXmlReader._readEtapes(parcoursElement, "etape", globalSettings));
                ParcoursVariante variante = new ParcoursVariante(parcours.getName() + "-0");
                variante.setEquipeVector(RaidFileXmlReader._readEquipes(geRaid, parcoursElement));
                variante.setEtapeEpreuveMap(RaidFileXmlReader._readEtapes(parcoursElement, "etape", globalSettings));
                parcours.addVariante(variante);
            }
            parcours.cloneEpreuves();
            geRaid.addParcours(parcours);
        }
    }

    private static void _readResults(Raid geRaid, Document document) throws UnassignedPuceException {
        Element root = (Element)document.getElementsByTagName("resultats").item(0);
        NodeList resultElements = root.getElementsByTagName("resultat");
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < resultElements.getLength(); ++i) {
            Element resultElement = (Element)resultElements.item(i);
            PuceResult puceResult = new PuceResult();
            puceResult.setParcours(geRaid.getParcoursVector().getParcoursFromName(RaidFileXmlReader._getChildText(resultElement, "parcours")));
            assert (puceResult.getParcours() != null);
            puceResult.setEtape(puceResult.getParcours().getEtape(RaidFileXmlReader._getChildText(resultElement, "etape")));
            puceResult.setEquipe(puceResult.getParcours().getEquipeFromPuceId(RaidFileXmlReader._getChildText(resultElement, "equipe")));
            Element puceElement = (Element)resultElement.getElementsByTagName("puce").item(0);
            Puce puce = puceResult.getPuce();
            puce.setId(RaidFileXmlReader._getChildText(resultElement, "equipe"));
            puce.setClearTime(DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(puceElement, "erase")));
            puce.setCheckTime(DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(puceElement, "control")));
            puce.setStartTime(DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(puceElement, "start")));
            puce.setFinishTime(DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(puceElement, "finish")));
            puce.setReadTime(DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(puceElement, "read")));
            Element partielRoot = (Element)puceElement.getElementsByTagName("partiels").item(0);
            NodeList partielElements = partielRoot.getElementsByTagName("partiel");
            ArrayList<Partiel> partiels = new ArrayList<Partiel>();
            for (int j = 0; j < partielElements.getLength(); ++j) {
                Element partielElement = (Element)partielElements.item(j);
                Partiel partiel = new Partiel(Integer.parseInt(RaidFileXmlReader._getChildText(partielElement, "code")), DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(partielElement, "time")));
                partiels.add(partiel);
            }
            puce.setPartiels(partiels);
            if (puceResult.getEquipe() != null) {
                geRaid.addPuceResult(puceResult);
                continue;
            }
            if (errors.length() > 0) {
                errors.append(", ");
            }
            errors.append(RaidFileXmlReader._getChildText(resultElement, "equipe"));
        }
        if (errors.length() > 0) {
            throw new UnassignedPuceException(errors.toString());
        }
    }

    private static void _readPenalties(Raid geRaid, Document document) {
        Element root = (Element)document.getElementsByTagName("penalites").item(0);
        NodeList penaliteElements = root.getElementsByTagName("penalite");
        if (penaliteElements.getLength() == 0) {
            return;
        }
        for (int i = 0; i < penaliteElements.getLength(); ++i) {
            Element penaliteElement = (Element)penaliteElements.item(i);
            Penalite penalite = new Penalite();
            penalite.setParcours(geRaid.getParcoursVector().getParcoursFromName(RaidFileXmlReader._getChildText(penaliteElement, "parcours")));
            assert (penalite.getParcours() != null);
            penalite.setEtape(penalite.getParcours().getEtape(RaidFileXmlReader._getChildText(penaliteElement, "etape")));
            penalite.setName(RaidFileXmlReader._getChildText(penaliteElement, "nom"));
            Element individualPenaltyRoot = (Element)penaliteElement.getElementsByTagName("penIndvs").item(0);
            NodeList individualPenaltyElements = individualPenaltyRoot.getElementsByTagName("penIndv");
            for (int j = 0; j < individualPenaltyElements.getLength(); ++j) {
                Element penaliteIndividuelleElement = (Element)penaliteElements.item(j);
                PenaliteIndividuelle penaliteIndividuelle = new PenaliteIndividuelle();
                penaliteIndividuelle.setPuceIds(RaidFileXmlReader._getChildText(penaliteIndividuelleElement, "puce"));
                penaliteIndividuelle.setPoints(Integer.parseInt(RaidFileXmlReader._getChildText(penaliteIndividuelleElement, "points")));
                penaliteIndividuelle.setTimeIns(Integer.parseInt(RaidFileXmlReader._getChildText(penaliteIndividuelleElement, "temps")));
                penalite.getPenaliteIndividuelleVector().add(penaliteIndividuelle);
            }
            geRaid.getPenaliteVector().add(penalite);
        }
    }

    private static EquipeVector _readEquipes(Raid geRaid, Element parcours) {
        Element root = (Element)parcours.getElementsByTagName("equipes").item(0);
        NodeList equipeElements = root.getElementsByTagName("equipe");
        EquipeVector equipes = new EquipeVector();
        for (int i = 0; i < equipeElements.getLength(); ++i) {
            Element equipeElement = (Element)equipeElements.item(i);
            Equipe equipe = new Equipe(geRaid.getPuceResultVector());
            equipe.setName(RaidFileXmlReader._getChildText(equipeElement, "nom"));
            equipe.setBib(RaidFileXmlReader._getChildText(equipeElement, "dossard"));
            equipe.setPhone(RaidFileXmlReader._getChildText(equipeElement, "telephone"));
            equipe.setPuceIds(RaidFileXmlReader._getChildText(equipeElement, "idPuce"));
            int isNotClassified = Integer.parseInt(RaidFileXmlReader._getChildText(equipeElement, "nc"));
            equipe.setNotClassified(isNotClassified == 1);
            if (equipeElement.getElementsByTagName("abs").getLength() > 0) {
                int absent = Integer.parseInt(RaidFileXmlReader._getChildText(equipeElement, "abs"));
                equipe.setAbsent(absent == 1);
            }
            equipe.setCategorie(geRaid.getCategorieVector().getCategorieFromShortName(RaidFileXmlReader._getChildText(equipeElement, "categorie")));
            equipe.setEquipierVector(RaidFileXmlReader._readEquipiers(equipeElement));
            equipes.addEquipeIfNotExistWithSamePuceAndBib(equipe);
        }
        return equipes;
    }

    private static EquipierVector _readEquipiers(Element equipe) {
        Element equipierRoot = (Element)equipe.getElementsByTagName("raiders").item(0);
        NodeList equipierElements = equipierRoot.getElementsByTagName("raider");
        EquipierVector equipiers = new EquipierVector();
        for (int i = 0; i < equipierElements.getLength(); ++i) {
            Element equipierElement = (Element)equipierElements.item(i);
            Equipier equipier = new Equipier();
            equipier.setLastname(RaidFileXmlReader._getChildText(equipierElement, "nom"));
            equipier.setFirstname(RaidFileXmlReader._getChildText(equipierElement, "prenom"));
            equipiers.addEquipier(equipier);
        }
        return equipiers;
    }

    private static EpreuveVector _readEpreuves(GlobalSettings globalSettings, Element etapeElement) {
        NodeList epreuveElements = etapeElement.getElementsByTagName("epreuve");
        EpreuveVector epreuves = new EpreuveVector();
        for (int i = 0; i < epreuveElements.getLength(); ++i) {
            int as;
            Element epreuveElement = (Element)epreuveElements.item(i);
            EpreuveFactory factory = epreuveElement.getElementsByTagName("typeEpreuve").getLength() > 0 ? EpreuveFactory.getFactoryFromType(EpreuveType.valueOf(RaidFileXmlReader._getChildText(epreuveElement, "typeEpreuve"))) : new StandardEpreuveFactory();
            Epreuve epreuve = ((EpreuveFactory)factory).createEpreuve(globalSettings.getBaliseModel());
            epreuve.setName(RaidFileXmlReader._getChildText(epreuveElement, "nom"));
            epreuve.setLimitType(LimitType.valueOf(RaidFileXmlReader._getChildText(epreuveElement, "typeL")));
            if (epreuve.getLimitType() == LimitType.AVECLIMITEHORAIRE) {
                epreuve.setTimeLimit(DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(epreuveElement, "limite")));
            }
            if (epreuve.getLimitType() == LimitType.AVECLIMITETEMPS) {
                epreuve.setDurationLimit(DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(epreuveElement, "limite")));
            }
            if (epreuve.getLimitType() != LimitType.SANSLIMITE) {
                epreuve.setPenaltyPoints(Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "points")));
                epreuve.setPenaltyTimeInMn(Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "mn")));
                epreuve.setPenaltyIntervalInMn(Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "temps")));
            }
            if (epreuveElement.getElementsByTagName("multi").getLength() > 0) {
                epreuve.setTimeMultiplier(Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "multi")));
            }
            if (epreuveElement.getElementsByTagName("ligne").getLength() > 0) {
                RaidFileXmlReader._readEpreuveEnLigne(epreuveElement, epreuve);
            } else {
                RaidFileXmlReader._readEpreuveOrdreLibre(epreuve);
            }
            if (epreuveElement.getElementsByTagName("ascenseur").getLength() > 0) {
                as = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "ascenseur"));
                epreuve.setAscenseur(as == 1);
            }
            if (epreuveElement.getElementsByTagName("aes").getLength() > 0) {
                as = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "aes"));
                epreuve.setToBeDoneBeforeNextEpreuve(as == 1);
            }
            if (epreuveElement.getElementsByTagName("aep").getLength() > 0) {
                as = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "aep"));
                epreuve.setToBeDoneAfterPreviousEpreuve(as == 1);
            }
            if (epreuveElement.getElementsByTagName("exclusive").getLength() > 0) {
                int exclusive = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "exclusive"));
                epreuve.setExclusiveWithNextEpreuve(exclusive == 1);
            }
            if (epreuveElement.getElementsByTagName("backAndForth").getLength() > 0) {
                int backAndForth = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "backAndForth"));
                epreuve.setBackAndForth(backAndForth == 1);
            }
            if (epreuveElement.getElementsByTagName("variant").getLength() > 0) {
                int variant = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "variant"));
                epreuve.setVariante(variant == 1);
            }
            if (epreuveElement.getElementsByTagName("baliseModel").getLength() > 0) {
                Element baliseModelElement = (Element)epreuveElement.getElementsByTagName("baliseModel").item(0);
                Balise baliseModel = new Balise();
                baliseModel.setPunchPointsBonus(Integer.parseInt(RaidFileXmlReader._getChildText(baliseModelElement, "points")));
                baliseModel.setPunchTimeBonusInS(Integer.parseInt(RaidFileXmlReader._getChildText(baliseModelElement, "temps")));
                baliseModel.setMispunchPointsPenalty(Integer.parseInt(RaidFileXmlReader._getChildText(baliseModelElement, "pointsPm")));
                baliseModel.setMispunchTimePenaltyInS(Integer.parseInt(RaidFileXmlReader._getChildText(baliseModelElement, "tempsPm")));
                epreuve.setLocalBaliseModel(baliseModel);
            }
            epreuve.setBaliseVector(RaidFileXmlReader._readBalises(epreuveElement));
            if (epreuve.getBaliseVector().getSize() >= 2 && epreuveElement.getElementsByTagName("typeEpreuve").getLength() == 0 && ((Balise)epreuve.getBaliseVector().getBaliseVector().getFirst()).isPartOfGelEpreuve() && ((Balise)epreuve.getBaliseVector().getBaliseVector().getLast()).isPartOfGelEpreuve()) {
                epreuve = new GelEpreuveFactory().createEpreuve(epreuve);
            }
            epreuves.getEpreuveVector().add(epreuve);
        }
        return epreuves;
    }

    private static void _readEpreuveOrdreLibre(Epreuve epreuve) {
        epreuve.setEnLigne(false);
        epreuve.setStartTheLastBaliseOfPreviousEpreuve(false);
        epreuve.setFinishTheFirstBaliseOfNextEpreuve(false);
        epreuve.setTimed(false);
    }

    private static void _readEpreuveEnLigne(Element epreuveElement, Epreuve epreuve) {
        int c;
        int line = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "ligne"));
        epreuve.setEnLigne(line == 1);
        int db1 = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "debutB1"));
        epreuve.setStartTheLastBaliseOfPreviousEpreuve(db1 == 1);
        int fdb = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "finB"));
        epreuve.setFinishTheFirstBaliseOfNextEpreuve(fdb == 1);
        if (epreuveElement.getElementsByTagName("ligne").getLength() > 0) {
            if (epreuveElement.getElementsByTagName("chrono").getLength() > 0) {
                c = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "chrono"));
                epreuve.setTimed(c == 1);
            } else {
                epreuve.setTimed(false);
            }
        }
        if (epreuveElement.getElementsByTagName("hc").getLength() > 0) {
            c = Integer.parseInt(RaidFileXmlReader._getChildText(epreuveElement, "hc"));
            epreuve.setToBeDoneAfterFinish(c == 1);
        } else {
            epreuve.setToBeDoneAfterFinish(false);
        }
    }

    private static EtapeEpreuveMap _readEtapes(Element parcours, String tag, GlobalSettings globalSettings) {
        NodeList etapeElements = parcours.getElementsByTagName(tag);
        EtapeEpreuveMap etapes = new EtapeEpreuveMap();
        for (int i = 0; i < etapeElements.getLength(); ++i) {
            Element etapeElement = (Element)etapeElements.item(i);
            Etape etape = new Etape();
            etape.setName(RaidFileXmlReader._getChildText(etapeElement, "nom"));
            int complete = Integer.parseInt(RaidFileXmlReader._getChildText(etapeElement, "fin"));
            etape.setFinished(complete == 1);
            if (etapeElement.getElementsByTagName("gel").getLength() > 0) {
                int gel = Integer.parseInt(RaidFileXmlReader._getChildText(etapeElement, "gel"));
                etape.setGelUsedInTimeLimit(gel == 1);
            }
            etape.setStartType(StartType.valueOf(RaidFileXmlReader._getChildText(etapeElement, "type")));
            if (etape.getStartType() == StartType.GROUPE) {
                etape.setStartHour(DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(etapeElement, "heure")));
            }
            etape.setLimitType(LimitType.valueOf(RaidFileXmlReader._getChildText(etapeElement, "typeL")));
            if (etape.getLimitType() == LimitType.AVECLIMITEHORAIRE) {
                etape.setLimitHour(DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(etapeElement, "limite")));
            }
            if (etape.getLimitType() == LimitType.AVECLIMITETEMPS) {
                etape.setDurationLimit(DateTimeUtils.dateFromMilliseconds(RaidFileXmlReader._getChildText(etapeElement, "limite")));
            }
            if (etape.getLimitType() != LimitType.SANSLIMITE) {
                etape.setPenaltyPoints(Integer.parseInt(RaidFileXmlReader._getChildText(etapeElement, "points")));
                etape.setPenaltyTimeInMm(Integer.parseInt(RaidFileXmlReader._getChildText(etapeElement, "mn")));
                etape.setPenaltyInterval(Integer.parseInt(RaidFileXmlReader._getChildText(etapeElement, "temps")));
            }
            etapes.addEtape(etape);
            etapes.setEpreuvesOfEtape(etape, RaidFileXmlReader._readEpreuves(globalSettings, etapeElement));
        }
        return etapes;
    }

    private static BaliseVector _readBalises(Element p) {
        NodeList baliseElements = p.getElementsByTagName("balise");
        BaliseVector balises = new BaliseVector();
        for (int i = 0; i < baliseElements.getLength(); ++i) {
            Element b = (Element)baliseElements.item(i);
            Balise balise = new Balise();
            balise.setNumber(Integer.parseInt(RaidFileXmlReader._getChildText(b, "numero")));
            balise.setPunchPointsBonus(Integer.parseInt(RaidFileXmlReader._getChildText(b, "points")));
            balise.setPunchTimeBonusInS(Integer.parseInt(RaidFileXmlReader._getChildText(b, "temps")));
            balise.setMispunchPointsPenalty(Integer.parseInt(RaidFileXmlReader._getChildText(b, "pointsPm")));
            balise.setMispunchTimePenaltyInS(Integer.parseInt(RaidFileXmlReader._getChildText(b, "tempsPm")));
            int chronometer = Integer.parseInt(RaidFileXmlReader._getChildText(b, "chrono"));
            balise.setFreezeTime(chronometer > 0);
            balises.getBaliseVector().add(balise);
        }
        return balises;
    }

    private static String _getChildText(Document root, String tag) {
        Node node = root.getElementsByTagName(tag).item(0);
        Node firstChild = node.getFirstChild();
        if (firstChild == null) {
            return "";
        }
        return firstChild.getTextContent();
    }

    private static String _getChildText(Element element, String tag) {
        NodeList elementsByTagName = element.getElementsByTagName(tag);
        if (elementsByTagName.getLength() == 0) {
            return "";
        }
        Node node = elementsByTagName.item(0);
        Node firstChild = node.getFirstChild();
        if (firstChild == null) {
            return "";
        }
        return firstChild.getTextContent();
    }
}

