/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_file;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.LimitType;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.StartType;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.balise.BaliseVector;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.equipe.Equipier;
import fr.geraidv3.model.equipe.EquipierVector;
import fr.geraidv3.model.etape.EtapeEpreuveMap;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.model.parcours.ParcoursVarianteVector;
import fr.geraidv3.result.penalite.Penalite;
import fr.geraidv3.result.penalite.PenaliteIndividuelle;
import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.result.puce.PuceResult;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.VisibleForTesting;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class RaidXmlFileWriter {
    public static void writeIntoRaidFile(Raid raid, String raidFile) {
        try {
            Document document = RaidXmlFileWriter._buildDocumentFromRaid(raid);
            RaidXmlFileWriter._saveInFile(raidFile, document);
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("xml_raid.write.error1", e.getClass().getName(), e.getMessage()));
        }
    }

    @VisibleForTesting
    static Document _buildDocumentFromRaid(Raid raid) throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.newDocument();
        Element racine = document.createElement("geraid");
        document.appendChild(racine);
        RaidXmlFileWriter._writeSettings(raid, document, racine);
        RaidXmlFileWriter._writeCategories(raid, document, racine);
        RaidXmlFileWriter._writeParcours(raid, document, racine);
        RaidXmlFileWriter._writeResults(raid, document, racine);
        RaidXmlFileWriter._writePenalitesIndividuelles(raid, document, racine);
        return document;
    }

    private static void _writeSettings(Raid raid, Document document, Element racine) {
        Element version = document.createElement("version");
        version.appendChild(document.createTextNode(GeRaidV3.SessionLauncher.getVersion()));
        racine.appendChild(version);
        Element nomRaid = document.createElement("nom");
        nomRaid.appendChild(document.createTextNode(raid.getRaidName()));
        racine.appendChild(nomRaid);
        Element raidHeader = document.createElement("entete");
        raidHeader.appendChild(document.createTextNode(raid.getPrintHeader()));
        racine.appendChild(raidHeader);
        Element raidFooter = document.createElement("piedPage");
        raidFooter.appendChild(document.createTextNode(raid.getPrintFooter()));
        racine.appendChild(raidFooter);
        Element zeroHourH = document.createElement("hzh");
        zeroHourH.appendChild(document.createTextNode("" + raid.getHourZero().getHours()));
        racine.appendChild(zeroHourH);
        Element zeroHourM = document.createElement("hzm");
        zeroHourM.appendChild(document.createTextNode("" + raid.getHourZero().getMinutes()));
        racine.appendChild(zeroHourM);
    }

    private static void _writeCategories(Raid raid, Document document, Element racine) {
        Element categoryElements = document.createElement("categories");
        Vector<Categorie> categorieVector = raid.getCategorieVector().getCategorieVector();
        for (Categorie categorie : categorieVector) {
            Element categoryElement = document.createElement("categorie");
            Element longName = document.createElement("nomLong");
            longName.appendChild(document.createTextNode(categorie.getLongName()));
            categoryElement.appendChild(longName);
            Element shortName = document.createElement("nomCourt");
            shortName.appendChild(document.createTextNode(categorie.getShortName()));
            categoryElement.appendChild(shortName);
            categoryElements.appendChild(categoryElement);
        }
        racine.appendChild(categoryElements);
    }

    private static void _writeParcours(Raid raid, Document document, Element racine) {
        Element pars = document.createElement("parcourss");
        for (int i = 0; i < raid.getParcoursVector().getSize(); ++i) {
            Element p = document.createElement("parcours");
            Element nom = document.createElement("nom");
            nom.appendChild(document.createTextNode(raid.getParcoursVector().getNameAtIndex(i)));
            p.appendChild(nom);
            RaidXmlFileWriter._writeEtapesModel(raid, document, p, i);
            Element vars = document.createElement("variantes");
            ParcoursVarianteVector variantes = raid.getParcoursVector().getParcoursVector().get(i).getVarianteVector();
            for (int v = 0; v < variantes.getSize(); ++v) {
                Element varianteElement = document.createElement("variante");
                ParcoursVariante variante = variantes.getVarianteParcoursVector().get(v);
                Element variantName = document.createElement("nom");
                variantName.appendChild(document.createTextNode(variante.getName()));
                varianteElement.appendChild(variantName);
                Element eqs = document.createElement("equipes");
                EquipeVector equipes = variante.getEquipeVector();
                for (int j = 0; j < equipes.getSize(); ++j) {
                    Element equipeElement = document.createElement("equipe");
                    Equipe equipe = equipes.getEquipeVector().get(j);
                    Element name = document.createElement("nom");
                    name.appendChild(document.createTextNode(equipe.getName()));
                    equipeElement.appendChild(name);
                    Element eBib = document.createElement("dossard");
                    eBib.appendChild(document.createTextNode(equipe.getBib()));
                    equipeElement.appendChild(eBib);
                    Element eIdPuce = document.createElement("idPuce");
                    eIdPuce.appendChild(document.createTextNode(equipe.getPuceIdsAsString()));
                    equipeElement.appendChild(eIdPuce);
                    Element ePhone = document.createElement("telephone");
                    ePhone.appendChild(document.createTextNode(equipe.getPhone()));
                    equipeElement.appendChild(ePhone);
                    Element nc = document.createElement("nc");
                    nc.appendChild(document.createTextNode(RaidXmlFileWriter._encodeBoolean(equipe.isNotClassified())));
                    equipeElement.appendChild(nc);
                    Element abs = document.createElement("abs");
                    abs.appendChild(document.createTextNode(RaidXmlFileWriter._encodeBoolean(equipe.isAbsent())));
                    equipeElement.appendChild(abs);
                    Element eCat = document.createElement("categorie");
                    eCat.appendChild(document.createTextNode(equipe.getCategorie().getShortName()));
                    equipeElement.appendChild(eCat);
                    EquipierVector rds = equipe.getEquipierVector();
                    Element rs = document.createElement("raiders");
                    List<Equipier> equipierVector = rds.getEquipierVector();
                    for (Equipier rd : equipierVector) {
                        Element r = document.createElement("raider");
                        Element equipierLastname = document.createElement("nom");
                        equipierLastname.appendChild(document.createTextNode(rd.getLastname()));
                        r.appendChild(equipierLastname);
                        Element equipierFirstname = document.createElement("prenom");
                        equipierFirstname.appendChild(document.createTextNode(rd.getFirstname()));
                        r.appendChild(equipierFirstname);
                        rs.appendChild(r);
                    }
                    equipeElement.appendChild(rs);
                    eqs.appendChild(equipeElement);
                }
                varianteElement.appendChild(eqs);
                Element ets = document.createElement("etapes");
                EtapeEpreuveMap etapes = variante.getEtapeEpreuveMap();
                for (int l = 0; l < etapes.getSize(); ++l) {
                    Element e = document.createElement("etape");
                    Element etapeName = document.createElement("nom");
                    etapeName.appendChild(document.createTextNode(etapes.getEtapeVector().get(l).getName()));
                    e.appendChild(etapeName);
                    Element etapeCompleted = document.createElement("fin");
                    etapeCompleted.appendChild(document.createTextNode(etapes.getEtapeVector().get(l).getFinishedAsString()));
                    e.appendChild(etapeCompleted);
                    Element eGel = document.createElement("gel");
                    eGel.appendChild(document.createTextNode(etapes.getEtapeVector().get(l).getGelUsedInTimeLimit()));
                    e.appendChild(eGel);
                    Element etapeType = document.createElement("type");
                    etapeType.appendChild(document.createTextNode(etapes.getEtapeVector().get(l).getStartType().name()));
                    e.appendChild(etapeType);
                    Element etapeHour = document.createElement("heure");
                    if (etapes.getEtapeVector().get(l).getStartType() == StartType.GROUPE) {
                        etapeHour.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getStartHour().getTime()));
                    }
                    e.appendChild(etapeHour);
                    Element etapeTypeL = document.createElement("typeL");
                    etapeTypeL.appendChild(document.createTextNode(etapes.getEtapeVector().get(l).getLimitType().name()));
                    e.appendChild(etapeTypeL);
                    Element etapeLimit = document.createElement("limite");
                    if (etapes.getEtapeVector().get(l).getLimitType() == LimitType.AVECLIMITEHORAIRE) {
                        etapeLimit.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getLimitHour().getTime()));
                    } else if (etapes.getEtapeVector().get(l).getLimitType() == LimitType.AVECLIMITETEMPS) {
                        etapeLimit.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getDurationLimit().getTime()));
                    } else if (etapes.getEtapeVector().get(l).getLimitType() == LimitType.SANSLIMITE) {
                        etapeLimit.appendChild(document.createTextNode("0"));
                    }
                    e.appendChild(etapeLimit);
                    Element ePoints = document.createElement("points");
                    ePoints.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getPenaltyPoints()));
                    e.appendChild(ePoints);
                    Element eMn = document.createElement("mn");
                    eMn.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getPenaltyTimeInMm()));
                    e.appendChild(eMn);
                    Element eTemps = document.createElement("temps");
                    eTemps.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getPenaltyInterval()));
                    e.appendChild(eTemps);
                    Element eps = document.createElement("epreuves");
                    EpreuveVector epreuves = variante.getEpreuvesOfEtape(etapes.getEtapeVector().get(l));
                    for (int z = 0; z < epreuves.getSize(); ++z) {
                        Element ep = document.createElement("epreuve");
                        Element epreuveType = document.createElement("typeEpreuve");
                        epreuveType.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getType().name()));
                        ep.appendChild(epreuveType);
                        Element epreuveName = document.createElement("nom");
                        epreuveName.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getName()));
                        ep.appendChild(epreuveName);
                        Element multi = document.createElement("multi");
                        multi.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getTimeMultiplier()));
                        ep.appendChild(multi);
                        Element epreuveTypeL = document.createElement("typeL");
                        epreuveTypeL.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getLimitType().name()));
                        ep.appendChild(epreuveTypeL);
                        Element epreuveLimit = document.createElement("limite");
                        if (epreuves.getEpreuveVector().get(z).getLimitType() == LimitType.AVECLIMITEHORAIRE) {
                            epreuveLimit.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getTimeLimit().getTime()));
                        } else if (epreuves.getEpreuveVector().get(z).getLimitType() == LimitType.AVECLIMITETEMPS) {
                            epreuveLimit.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getDurationLimit().getTime()));
                        } else if (epreuves.getEpreuveVector().get(z).getLimitType() == LimitType.SANSLIMITE) {
                            epreuveLimit.appendChild(document.createTextNode("0"));
                        }
                        ep.appendChild(epreuveLimit);
                        Element li = document.createElement("ligne");
                        li.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsCourseInRowAsString()));
                        ep.appendChild(li);
                        Element as = document.createElement("ascenseur");
                        as.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsAscenseurAsString()));
                        ep.appendChild(as);
                        Element db1 = document.createElement("debutB1");
                        db1.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getDebutEpreuve()));
                        ep.appendChild(db1);
                        Element fdb = document.createElement("finB");
                        fdb.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getFinEpreuve()));
                        ep.appendChild(fdb);
                        Element ch = document.createElement("chrono");
                        ch.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsTimeAsString()));
                        ep.appendChild(ch);
                        Element hc = document.createElement("hc");
                        hc.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getDoneAfterFinishAsString()));
                        ep.appendChild(hc);
                        Element epPoints = document.createElement("points");
                        epPoints.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getPenaltyPoints()));
                        ep.appendChild(epPoints);
                        Element epMn = document.createElement("mn");
                        epMn.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getPenaltyTimeInMn()));
                        ep.appendChild(epMn);
                        Element epTemps = document.createElement("temps");
                        epTemps.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getPenaltyIntervalInMn()));
                        ep.appendChild(epTemps);
                        Element aep = document.createElement("aep");
                        aep.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsAfterPreviousEpreuveAsString()));
                        ep.appendChild(aep);
                        Element aes = document.createElement("aes");
                        aes.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsBeforeNextEpreuveAsString()));
                        ep.appendChild(aes);
                        Element exclusive = document.createElement("exclusive");
                        exclusive.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getExclusiveWithNextEpreuveAsString()));
                        ep.appendChild(exclusive);
                        Element variant = document.createElement("variant");
                        variant.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getVariantAsString()));
                        ep.appendChild(variant);
                        Element bs = document.createElement("balises");
                        BaliseVector balises = epreuves.getEpreuveVector().get(z).getBaliseVector();
                        for (int m = 0; m < balises.getSize(); ++m) {
                            Element balise = document.createElement("balise");
                            Element baliseNumber = document.createElement("numero");
                            baliseNumber.appendChild(document.createTextNode("" + balises.getBaliseVector().get(m).getNumber()));
                            balise.appendChild(baliseNumber);
                            Element balisePoints = document.createElement("points");
                            balisePoints.appendChild(document.createTextNode("" + balises.getBaliseVector().get(m).getPunchPointsBonus()));
                            balise.appendChild(balisePoints);
                            Element bTemps = document.createElement("temps");
                            bTemps.appendChild(document.createTextNode("" + balises.getBaliseVector().get(m).getPunchTimeBonusInS()));
                            balise.appendChild(bTemps);
                            Element baliseMpPoints = document.createElement("pointsPm");
                            baliseMpPoints.appendChild(document.createTextNode("" + balises.getBaliseVector().get(m).getMispunchPointsPenalty()));
                            balise.appendChild(baliseMpPoints);
                            Element bTempsPm = document.createElement("tempsPm");
                            bTempsPm.appendChild(document.createTextNode("" + balises.getBaliseVector().get(m).getMispunchTimePenaltyInS()));
                            balise.appendChild(bTempsPm);
                            Element baliseChronometer = document.createElement("chrono");
                            baliseChronometer.appendChild(document.createTextNode(balises.getBaliseVector().get(m).getIsFreezeTimeAsString()));
                            balise.appendChild(baliseChronometer);
                            bs.appendChild(balise);
                        }
                        ep.appendChild(bs);
                        eps.appendChild(ep);
                    }
                    e.appendChild(eps);
                    ets.appendChild(e);
                }
                varianteElement.appendChild(ets);
                vars.appendChild(varianteElement);
            }
            p.appendChild(vars);
            pars.appendChild(p);
        }
        racine.appendChild(pars);
    }

    private static void _writeEtapesModel(Raid raid, Document document, Element racine, int index) {
        Element ets = document.createElement("etapes");
        Parcours parcours = raid.getParcoursVector().getParcoursVector().get(index);
        EtapeEpreuveMap etapes = parcours.getEtapeEpreuveMap();
        for (int l = 0; l < etapes.getSize(); ++l) {
            Element e = document.createElement("etapeModel");
            Element etapeName = document.createElement("nom");
            etapeName.appendChild(document.createTextNode(etapes.getEtapeVector().get(l).getName()));
            e.appendChild(etapeName);
            Element etapeCompleted = document.createElement("fin");
            etapeCompleted.appendChild(document.createTextNode(etapes.getEtapeVector().get(l).getFinishedAsString()));
            e.appendChild(etapeCompleted);
            Element eGel = document.createElement("gel");
            eGel.appendChild(document.createTextNode(etapes.getEtapeVector().get(l).getGelUsedInTimeLimit()));
            e.appendChild(eGel);
            Element etapeType = document.createElement("type");
            etapeType.appendChild(document.createTextNode(etapes.getEtapeVector().get(l).getStartType().name()));
            e.appendChild(etapeType);
            Element etapeHour = document.createElement("heure");
            if (etapes.getEtapeVector().get(l).getStartType() == StartType.GROUPE) {
                etapeHour.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getStartHour().getTime()));
            }
            e.appendChild(etapeHour);
            Element etapeTypeL = document.createElement("typeL");
            etapeTypeL.appendChild(document.createTextNode(etapes.getEtapeVector().get(l).getLimitType().name()));
            e.appendChild(etapeTypeL);
            Element etapeLimit = document.createElement("limite");
            if (etapes.getEtapeVector().get(l).getLimitType() == LimitType.AVECLIMITEHORAIRE) {
                etapeLimit.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getLimitHour().getTime()));
            } else if (etapes.getEtapeVector().get(l).getLimitType() == LimitType.AVECLIMITETEMPS) {
                etapeLimit.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getDurationLimit().getTime()));
            } else if (etapes.getEtapeVector().get(l).getLimitType() == LimitType.SANSLIMITE) {
                etapeLimit.appendChild(document.createTextNode("0"));
            }
            e.appendChild(etapeLimit);
            Element ePoints = document.createElement("points");
            ePoints.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getPenaltyPoints()));
            e.appendChild(ePoints);
            Element eMn = document.createElement("mn");
            eMn.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getPenaltyTimeInMm()));
            e.appendChild(eMn);
            Element eTemps = document.createElement("temps");
            eTemps.appendChild(document.createTextNode("" + etapes.getEtapeVector().get(l).getPenaltyInterval()));
            e.appendChild(eTemps);
            Element eps = document.createElement("epreuves");
            EpreuveVector epreuves = parcours.getEpreuvesOfEtape(etapes.getEtapeVector().get(l));
            for (int z = 0; z < epreuves.getSize(); ++z) {
                Element ep = document.createElement("epreuve");
                Element epreuveType = document.createElement("typeEpreuve");
                epreuveType.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getType().name()));
                ep.appendChild(epreuveType);
                Element epreuveName = document.createElement("nom");
                epreuveName.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getName()));
                ep.appendChild(epreuveName);
                Element multi = document.createElement("multi");
                multi.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getTimeMultiplier()));
                ep.appendChild(multi);
                Element epreuveTypeL = document.createElement("typeL");
                epreuveTypeL.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getLimitType().name()));
                ep.appendChild(epreuveTypeL);
                Element epreuveLimit = document.createElement("limite");
                if (epreuves.getEpreuveVector().get(z).getLimitType() == LimitType.AVECLIMITEHORAIRE) {
                    epreuveLimit.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getTimeLimit().getTime()));
                } else if (epreuves.getEpreuveVector().get(z).getLimitType() == LimitType.AVECLIMITETEMPS) {
                    epreuveLimit.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getDurationLimit().getTime()));
                } else if (epreuves.getEpreuveVector().get(z).getLimitType() == LimitType.SANSLIMITE) {
                    epreuveLimit.appendChild(document.createTextNode("0"));
                }
                ep.appendChild(epreuveLimit);
                Element li = document.createElement("ligne");
                li.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsCourseInRowAsString()));
                ep.appendChild(li);
                Element as = document.createElement("ascenseur");
                as.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsAscenseurAsString()));
                ep.appendChild(as);
                Element db1 = document.createElement("debutB1");
                db1.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getDebutEpreuve()));
                ep.appendChild(db1);
                Element fdb = document.createElement("finB");
                fdb.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getFinEpreuve()));
                ep.appendChild(fdb);
                Element ch = document.createElement("chrono");
                ch.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsTimeAsString()));
                ep.appendChild(ch);
                Element hc = document.createElement("hc");
                hc.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getDoneAfterFinishAsString()));
                ep.appendChild(hc);
                Element epPoints = document.createElement("points");
                epPoints.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getPenaltyPoints()));
                ep.appendChild(epPoints);
                Element epMn = document.createElement("mn");
                epMn.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getPenaltyTimeInMn()));
                ep.appendChild(epMn);
                Element epTemps = document.createElement("temps");
                epTemps.appendChild(document.createTextNode("" + epreuves.getEpreuveVector().get(z).getPenaltyIntervalInMn()));
                ep.appendChild(epTemps);
                Element aep = document.createElement("aep");
                aep.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsAfterPreviousEpreuveAsString()));
                ep.appendChild(aep);
                Element aes = document.createElement("aes");
                aes.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsBeforeNextEpreuveAsString()));
                ep.appendChild(aes);
                Element exclusive = document.createElement("exclusive");
                exclusive.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getExclusiveWithNextEpreuveAsString()));
                ep.appendChild(exclusive);
                Element backAndForth = document.createElement("backAndForth");
                backAndForth.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getIsBackAndForthAsString()));
                ep.appendChild(backAndForth);
                Element variant = document.createElement("variant");
                variant.appendChild(document.createTextNode(epreuves.getEpreuveVector().get(z).getVariantAsString()));
                ep.appendChild(variant);
                Balise baliseModel = epreuves.getEpreuveVector().get(z).getLocalBaliseModel();
                if (baliseModel != null) {
                    Element baliseModelElement = document.createElement("baliseModel");
                    Element balisePunchPointsBonus = document.createElement("points");
                    balisePunchPointsBonus.appendChild(document.createTextNode("" + baliseModel.getPunchPointsBonus()));
                    baliseModelElement.appendChild(balisePunchPointsBonus);
                    Element punchTimeBonus = document.createElement("temps");
                    punchTimeBonus.appendChild(document.createTextNode("" + baliseModel.getPunchTimeBonusInS()));
                    baliseModelElement.appendChild(punchTimeBonus);
                    Element baliseMispunchPenaltyPoints = document.createElement("pointsPm");
                    baliseMispunchPenaltyPoints.appendChild(document.createTextNode("" + baliseModel.getMispunchPointsPenalty()));
                    baliseModelElement.appendChild(baliseMispunchPenaltyPoints);
                    Element baliseMispunchTimePenalty = document.createElement("tempsPm");
                    baliseMispunchTimePenalty.appendChild(document.createTextNode("" + baliseModel.getMispunchTimePenaltyInS()));
                    baliseModelElement.appendChild(baliseMispunchTimePenalty);
                    ep.appendChild(baliseModelElement);
                }
                Element bs = document.createElement("balises");
                BaliseVector balises = epreuves.getEpreuveVector().get(z).getBaliseVector();
                for (int m = 0; m < balises.getSize(); ++m) {
                    Element balise = document.createElement("balise");
                    Element baliseNumber = document.createElement("numero");
                    baliseNumber.appendChild(document.createTextNode("" + balises.getBaliseVector().get(m).getNumber()));
                    balise.appendChild(baliseNumber);
                    Element balisePoints = document.createElement("points");
                    balisePoints.appendChild(document.createTextNode("" + balises.getBaliseVector().get(m).getPunchPointsBonus()));
                    balise.appendChild(balisePoints);
                    Element bTemps = document.createElement("temps");
                    bTemps.appendChild(document.createTextNode("" + balises.getBaliseVector().get(m).getPunchTimeBonusInS()));
                    balise.appendChild(bTemps);
                    Element baliseMpPoints = document.createElement("pointsPm");
                    baliseMpPoints.appendChild(document.createTextNode("" + balises.getBaliseVector().get(m).getMispunchPointsPenalty()));
                    balise.appendChild(baliseMpPoints);
                    Element bTempsPm = document.createElement("tempsPm");
                    bTempsPm.appendChild(document.createTextNode("" + balises.getBaliseVector().get(m).getMispunchTimePenaltyInS()));
                    balise.appendChild(bTempsPm);
                    Element baliseChronometer = document.createElement("chrono");
                    baliseChronometer.appendChild(document.createTextNode(balises.getBaliseVector().get(m).getIsFreezeTimeAsString()));
                    balise.appendChild(baliseChronometer);
                    bs.appendChild(balise);
                }
                ep.appendChild(bs);
                eps.appendChild(ep);
            }
            e.appendChild(eps);
            ets.appendChild(e);
        }
        racine.appendChild(ets);
    }

    private static void _writeResults(Raid raid, Document document, Element racine) {
        Element rs = document.createElement("resultats");
        List<PuceResult> puceResultVector = raid.getPuceResultVector().getPuceResultVector();
        for (PuceResult puceResult : puceResultVector) {
            Element r = document.createElement("resultat");
            Element pc = document.createElement("parcours");
            pc.appendChild(document.createTextNode(puceResult.getParcours().getName()));
            r.appendChild(pc);
            Element et = document.createElement("etape");
            et.appendChild(document.createTextNode(puceResult.getEtape().getName()));
            r.appendChild(et);
            Element eq = document.createElement("equipe");
            eq.appendChild(document.createTextNode(puceResult.getPuce().getId()));
            r.appendChild(eq);
            Element pu = document.createElement("puce");
            Element era = document.createElement("erase");
            era.appendChild(document.createTextNode("" + puceResult.getPuce().getClearTime().getTime()));
            pu.appendChild(era);
            Element cnt = document.createElement("control");
            cnt.appendChild(document.createTextNode("" + puceResult.getPuce().getCheckTime().getTime()));
            pu.appendChild(cnt);
            Element str = document.createElement("start");
            str.appendChild(document.createTextNode("" + puceResult.getPuce().getStartTime().getTime()));
            pu.appendChild(str);
            Element fns = document.createElement("finish");
            fns.appendChild(document.createTextNode("" + puceResult.getPuce().getFinishTime().getTime()));
            pu.appendChild(fns);
            Element red = document.createElement("read");
            red.appendChild(document.createTextNode("" + puceResult.getPuce().getReadTime().getTime()));
            pu.appendChild(red);
            Element parts = document.createElement("partiels");
            List<Partiel> punches = puceResult.getPuce().getPartiels();
            for (Partiel punch : punches) {
                Element part = document.createElement("partiel");
                Element cd = document.createElement("code");
                cd.appendChild(document.createTextNode("" + punch.getCode()));
                part.appendChild(cd);
                Element tm = document.createElement("time");
                tm.appendChild(document.createTextNode("" + punch.getTimeAsDate().getTime()));
                part.appendChild(tm);
                parts.appendChild(part);
            }
            pu.appendChild(parts);
            r.appendChild(pu);
            rs.appendChild(r);
        }
        racine.appendChild(rs);
    }

    private static void _writePenalitesIndividuelles(Raid raid, Document document, Element racine) {
        Element pns = document.createElement("penalites");
        List<Penalite> penaliteVector = raid.getPenaliteVector().getPenaliteVector();
        for (Penalite penalite : penaliteVector) {
            Element pn = document.createElement("penalite");
            Element nm = document.createElement("nom");
            nm.appendChild(document.createTextNode(penalite.getName()));
            pn.appendChild(nm);
            Element pc = document.createElement("parcours");
            pc.appendChild(document.createTextNode(penalite.getParcours().getName()));
            pn.appendChild(pc);
            Element et = document.createElement("etape");
            et.appendChild(document.createTextNode(penalite.getEtape().getName()));
            pn.appendChild(et);
            Element pis = document.createElement("penIndvs");
            List<PenaliteIndividuelle> penaliteIndividuelleVector = penalite.getPenaliteIndividuelleVector();
            for (PenaliteIndividuelle penaliteIndividuelle : penaliteIndividuelleVector) {
                Element pi = document.createElement("penIndv");
                Element pu = document.createElement("puce");
                pu.appendChild(document.createTextNode(penaliteIndividuelle.getPuceIds()));
                pi.appendChild(pu);
                Element pt = document.createElement("points");
                pt.appendChild(document.createTextNode("" + penaliteIndividuelle.getPoints()));
                pi.appendChild(pt);
                Element tp = document.createElement("temps");
                tp.appendChild(document.createTextNode("" + penaliteIndividuelle.getTimeInS()));
                pi.appendChild(tp);
                pis.appendChild(pi);
            }
            pn.appendChild(pis);
            pns.appendChild(pn);
        }
        racine.appendChild(pns);
    }

    private static void _saveInFile(String raidFile, Document document) throws IOException, TransformerException {
        DOMSource source = new DOMSource(document);
        FileWriter writer = new FileWriter(raidFile);
        StreamResult result = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(source, result);
    }

    private static String _encodeBoolean(boolean value) {
        return value ? "1" : "0";
    }
}

