/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.raid_menu.PenaliteTableModel;
import fr.geraidv3.desktop.raid_menu.RaidMenuPresenter;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.penalite.Penalite;
import fr.geraidv3.result.penalite.PenaliteIndividuelle;
import fr.geraidv3.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

final class CsvPenaltyHelper {
    CsvPenaltyHelper() {
    }

    static void exportPenalties(PenaliteTableModel model, String filename) {
        File file = new File(filename);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String[] lines;
            String contents = model.getHeaderAsCsv();
            ((Writer)writer).write(contents, 0, contents.length());
            writer.write(System.lineSeparator());
            for (String line : lines = model.getDataCSV()) {
                ((Writer)writer).write(line, 0, line.length());
                writer.write(System.lineSeparator());
            }
        }
        catch (IOException e) {
            DesktopView.beep();
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("csv_penalty_helper.error1", e.getClass().getName(), e.getMessage()));
        }
    }

    static void importAsCsv(RaidMenuPresenter presenter, Parcours parcours, Etape etape, String filename) {
        try {
            File file = new File(filename);
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("Cannot create file");
            }
            try (BufferedReader fileReader = new BufferedReader(new FileReader(file));){
                Penalite penalty = new Penalite();
                penalty.setName(FileUtils.getFileBasename(filename));
                penalty.setParcours(parcours);
                penalty.setEtape(etape);
                String line = fileReader.readLine();
                String delimiter = FileUtils.extractDelimiterFromCsvHeader(line);
                while ((line = fileReader.readLine()) != null) {
                    String[] text = line.trim().split(delimiter);
                    if (text.length <= 3) continue;
                    PenaliteIndividuelle individualPenalty = new PenaliteIndividuelle();
                    individualPenalty.setPuceIds(text[2]);
                    individualPenalty.setPoints(CsvPenaltyHelper._parseInt(text));
                    if (text.length > 4) {
                        individualPenalty.setTimeIns(CsvPenaltyHelper._parseInteger(text[4]));
                    }
                    penalty.getPenaliteIndividuelleVector().add(individualPenalty);
                }
                presenter.addPenalty(penalty);
            }
        }
        catch (IOException e) {
            DesktopView.beep();
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("csv_penalty_helper.error2", e.getClass().getName(), e.getMessage()));
        }
    }

    private static int _parseInt(String[] text) {
        try {
            return Integer.parseInt(text[3]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static int _parseInteger(String temps) {
        if (temps.charAt(0) == '-') {
            temps = temps.substring(1);
            return (CsvPenaltyHelper._parseHours(temps) * 3600 + CsvPenaltyHelper._parseMinutes(temps) * 60 + CsvPenaltyHelper._parseSeconds(temps)) * -1;
        }
        return CsvPenaltyHelper._parseHours(temps) * 3600 + CsvPenaltyHelper._parseMinutes(temps) * 60 + CsvPenaltyHelper._parseSeconds(temps);
    }

    private static int _parseSeconds(String temps) {
        return Integer.parseInt(temps.substring(temps.lastIndexOf(":") + 1));
    }

    private static int _parseMinutes(String temps) {
        return Integer.parseInt(temps.substring(temps.indexOf(":") + 1, temps.lastIndexOf(":")));
    }

    private static int _parseHours(String temps) {
        return Integer.parseInt(temps.substring(0, temps.indexOf(":")));
    }
}

