/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.raid_menu.RaidHtmlWriter;
import fr.geraidv3.desktop.sportident_panel.DocumentRenderer;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class HtmlViewer
extends JFrame {
    private JEditorPane _editorPane;

    public HtmlViewer(DesktopPresenter desktopPresenter, String htmlText) {
        this.setTitle(L10n.getString("desktop.menu.raid.summary.menuitem"));
        this._initializeUI(desktopPresenter);
        this._editorPane.setContentType("text/html");
        this._editorPane.setText(htmlText);
        this.pack();
    }

    private void _initializeUI(DesktopPresenter desktopPresenter) {
        this.setLayout(new BorderLayout());
        this._editorPane = new JEditorPane();
        this._editorPane.setEditable(false);
        this._editorPane.setOpaque(false);
        JPanel buttonContainer = new JPanel(new FlowLayout(1));
        JButton printButton = new JButton(L10n.getString("print"));
        buttonContainer.add(printButton);
        printButton.addActionListener(event -> {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            DocumentRenderer documentRenderer = new DocumentRenderer(this._editorPane);
            documentRenderer.setScale(0.66);
            printerJob.setPrintable(documentRenderer, pageFormat);
            try {
                if (printerJob.printDialog()) {
                    printerJob.print();
                }
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        });
        JButton saveButton = new JButton(L10n.getString("filechooser.saveButtonText"));
        buttonContainer.add(saveButton);
        saveButton.addActionListener(event -> this._save(desktopPresenter));
        JButton closeButton = new JButton(L10n.getString("close"));
        closeButton.addActionListener(event -> this.dispose());
        buttonContainer.add(closeButton);
        this.add((Component)new JScrollPane(this._editorPane), "Center");
        this.add((Component)buttonContainer, "South");
        this._addShortCutToCloseWindow();
    }

    private void _addShortCutToCloseWindow() {
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        KeyStroke ctrlQKey = KeyStroke.getKeyStroke(81, 128);
        inputMap.put(ctrlQKey, ctrlQKey.toString());
        actionMap.put(ctrlQKey.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlViewer.this.dispose();
            }
        });
    }

    private void _save(DesktopPresenter desktopPresenter) {
        String outputDirectory = desktopPresenter.getGlobalSettings().getBackupDirectoryPath();
        String absoluteFilename = outputDirectory + File.separator + "raid-resume.html";
        if (RaidHtmlWriter.generate(desktopPresenter.getRaid().exportAllParcoursAsHTML(), absoluteFilename)) {
            JOptionPane.showMessageDialog(this.getParent(), L10n.getString("html_viewer.save.message", absoluteFilename), L10n.getString("information"), 1);
        } else {
            ErrorPane.showMessageDialog(this.getParent(), L10n.getString("html_viewer.save.error", absoluteFilename));
        }
    }
}

