/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.result.penalite.PenaliteIndividuelle;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

@ExcludeFromJacocoGeneratedReport
final class IndividualPenaltyEditor
extends GDialog {
    private final transient PenaliteIndividuelle[] _penalties;
    private final transient Consumer<List<PenaliteIndividuelle>> _updateCallback;
    private final boolean _creation;
    private JRadioButton _bonusRadioButton;
    private JRadioButton _malusRadioButton;
    private JSpinner _spinnerPoints;
    private JSpinner _hourSpinner;
    private JSpinner _minuteSpinner;
    private JSpinner _secondSpinner;

    IndividualPenaltyEditor(JDialog parent, PenaliteIndividuelle[] penalties, Consumer<List<PenaliteIndividuelle>> updateCallback, boolean creation) {
        super(parent);
        this._penalties = penalties;
        this._updateCallback = updateCallback;
        this._creation = creation;
        this._initializeUI();
        this._initPoints();
        this._initTemps();
    }

    private void _initializeUI() {
        this.setTitle(L10n.getString("individual_penalty_editor.title"));
        this.setModal(true);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)this._createContentPanel(), "Center");
        contentPane.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(contentPane);
        this.pack();
    }

    private JPanel _createContentPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._createTypePanel());
        panel.add(this._createPointPanel());
        panel.add(this._createTimePanel());
        return panel;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private void _initPoints() {
        if (this._penalties[0].getPoints() == 0 && this._penalties[0].getTimeInS() < 0) {
            this._bonusRadioButton.setSelected(true);
        }
        if (this._penalties[0].getPoints() > 0 && this._penalties[0].getTimeInS() <= 0) {
            this._bonusRadioButton.setSelected(true);
        }
        this._spinnerPoints.setValue(Math.abs(this._penalties[0].getPoints()));
    }

    private void _initTemps() {
        int hours = (int)Math.floor((double)Math.abs(this._penalties[0].getTimeInS()) / 3600.0);
        int minutes = (int)Math.floor(((double)Math.abs(this._penalties[0].getTimeInS()) - (double)hours * 3600.0) / 60.0);
        int seconds = Math.abs(this._penalties[0].getTimeInS()) - hours * 3600 - minutes * 60;
        this._hourSpinner.setValue(hours);
        this._minuteSpinner.setValue(minutes);
        this._secondSpinner.setValue(seconds);
    }

    private JButton _createValidateButton() {
        JButton button = this._creation ? new JButton(L10n.getString("individual_penalty_editor.button1")) : new JButton(L10n.getString("individual_penalty_editor.button2"));
        this.setDefaultButton(button);
        button.addActionListener(event -> {
            ArrayList<PenaliteIndividuelle> penalties = new ArrayList<PenaliteIndividuelle>();
            for (PenaliteIndividuelle penalty : this._penalties) {
                if (this._bonusRadioButton.isSelected()) {
                    this._setBonusToPenalty(penalty);
                } else {
                    this._setMalusToPenalty(penalty);
                }
                penalties.add(penalty);
            }
            this._updateCallback.accept(penalties);
            this.dispose();
        });
        return button;
    }

    private void _setMalusToPenalty(PenaliteIndividuelle penalty) {
        if ((Integer)this._spinnerPoints.getValue() != 0) {
            penalty.setPoints((Integer)this._spinnerPoints.getValue() * -1);
        } else {
            penalty.setPoints(0);
        }
        penalty.setTimeIns(this._timeToSeconds());
    }

    private void _setBonusToPenalty(PenaliteIndividuelle penalty) {
        penalty.setPoints((Integer)this._spinnerPoints.getValue());
        if ((Integer)this._hourSpinner.getValue() + (Integer)this._minuteSpinner.getValue() + (Integer)this._secondSpinner.getValue() != 0) {
            penalty.setTimeIns(this._timeToSeconds() * -1);
        } else {
            penalty.setTimeIns(0);
        }
    }

    private int _timeToSeconds() {
        return (Integer)this._hourSpinner.getValue() * 3600 + (Integer)this._minuteSpinner.getValue() * 60 + (Integer)this._secondSpinner.getValue();
    }

    private JPanel _createTypePanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(new TitledBorder(null, L10n.getString("individual_penalty_editor.form.title1"), 4, 2));
        panel.add(this._createBonusRadioButton());
        panel.add(this._createMalusRadioButton());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._bonusRadioButton);
        bg.add(this._malusRadioButton);
        return panel;
    }

    private JRadioButton _createBonusRadioButton() {
        this._bonusRadioButton = new JRadioButton(L10n.getString("individual_penalty_editor.form.bonus"));
        return this._bonusRadioButton;
    }

    private JRadioButton _createMalusRadioButton() {
        this._malusRadioButton = new JRadioButton(L10n.getString("individual_penalty_editor.form.penalty"));
        this._malusRadioButton.setSelected(true);
        return this._malusRadioButton;
    }

    private JPanel _createPointPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(new TitledBorder(null, L10n.getString("individual_penalty_editor.form.title2"), 4, 2));
        panel.add(this._createPointSpinner());
        panel.add(new JLabel(L10n.getString("individual_penalty_editor.form.points")));
        return panel;
    }

    private JSpinner _createPointSpinner() {
        this._spinnerPoints = new JSpinner();
        this._spinnerPoints.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        return this._spinnerPoints;
    }

    private JPanel _createTimePanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(new TitledBorder(null, L10n.getString("individual_penalty_editor.form.title3"), 4, 2));
        panel.add(this._createHourSpinner());
        panel.add(new JLabel(L10n.getString("hour_abbreviation")));
        panel.add(this._createMinuteSpinner());
        panel.add(new JLabel(L10n.getString("minute_abbreviation")));
        panel.add(this._createSecondSpinner());
        panel.add(new JLabel(L10n.getString("second_abbreviation")));
        return panel;
    }

    private JSpinner _createHourSpinner() {
        this._hourSpinner = new JSpinner();
        this._hourSpinner.setModel(new SpinnerNumberModel(0, 0, 23, 1));
        return this._hourSpinner;
    }

    private JSpinner _createMinuteSpinner() {
        this._minuteSpinner = new JSpinner();
        this._minuteSpinner.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        return this._minuteSpinner;
    }

    private JSpinner _createSecondSpinner() {
        this._secondSpinner = new JSpinner();
        this._secondSpinner.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        return this._secondSpinner;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.setHorizontalTextPosition(0);
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

