/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.raid_menu.RaidMenuPresenter;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.result.penalite.Penalite;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

@ExcludeFromJacocoGeneratedReport
final class PenaltyEditor
extends GDialog {
    private final transient RaidMenuPresenter _presenter;
    private final transient Penalite _penalite;
    private final transient Runnable _updateCallback;
    private final boolean _creation;
    private JTextField _textFieldNom;
    private JLabel _labelMessage;

    PenaltyEditor(JDialog parent, RaidMenuPresenter presenter, Penalite penalty, Runnable updateCallback, boolean creation) {
        super(parent);
        this._presenter = presenter;
        this._penalite = penalty;
        this._updateCallback = updateCallback;
        this._creation = creation;
        this._initializeUI();
        if (this._creation) {
            this.setTitle(L10n.getString("penalty_editor.title1"));
        } else {
            this.setTitle(L10n.getString("penalty_editor.title2"));
        }
        this._textFieldNom.setText(this._penalite.getName());
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setResizable(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this._createJContentPane(), "North");
        panel.add((Component)this._getLabelMessage(), "Center");
        panel.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(panel);
        this.pack();
    }

    private JPanel _createJContentPane() {
        JPanel panel = new JPanel();
        JLabel label = new JLabel();
        label.setText(L10n.getString("penalty_editor.label"));
        panel.add(label);
        panel.add(this._createJTextFieldNom());
        return panel;
    }

    private JComponent _getLabelMessage() {
        this._labelMessage = new JLabel();
        this._labelMessage.setText("");
        this._labelMessage.setForeground(Color.red);
        this._labelMessage.setPreferredSize(new Dimension(215, 55));
        return this._labelMessage;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 5));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JTextField _createJTextFieldNom() {
        this._textFieldNom = new JTextField(20);
        return this._textFieldNom;
    }

    private JButton _createValidateButton() {
        JButton buttonOk = this._creation ? new JButton(L10n.getString("penalty_editor.button1")) : new JButton(L10n.getString("penalty_editor.button2"));
        this.setDefaultButton(buttonOk);
        buttonOk.addActionListener(event -> {
            if (this._textFieldNom.getText().trim().isEmpty()) {
                DesktopView.beep();
                this._labelMessage.setText(L10n.getString("penalty_editor.error"));
            } else {
                this._penalite.setName(this._textFieldNom.getText());
                if (this._creation) {
                    this._presenter.addPenalty(this._penalite);
                }
                this._updateCallback.run();
                this.dispose();
            }
        });
        return buttonOk;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.setHorizontalTextPosition(0);
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

