/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.raid_menu.RaidMenuPresenter;
import fr.geraidv3.desktop.swing_ext.StatefulComponent;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

@ExcludeFromJacocoGeneratedReport
public final class RaidMenu
extends JMenu
implements StatefulComponent {
    private final transient RaidMenuPresenter _presenter;
    private JMenuItem _menuItem;

    public RaidMenu(DesktopView desktopView, DesktopPresenter presenter) {
        super(L10n.getString("desktop.menu.raid.title"));
        this._presenter = new RaidMenuPresenter(presenter, desktopView);
        this._initializeUI();
    }

    @Override
    public void update(DesktopPresenter presenter) {
        this._menuItem.setEnabled(presenter.getRaid().getParcoursVector().getSize() > 0);
    }

    private void _initializeUI() {
        this.add(this._createMenuItemDisplayParcoursInBrowser());
        this.add(this._createMenuEquipeSearch());
        this.add(this._createMenuItemPenalty());
        this.add(this._createMenuSportIdentResults());
        this.add(new JSeparator());
        this.add(this._createMenuReplaceBalise());
        this.add(this._createMenuSwapTwoBalises());
        this.add(new JSeparator());
        this.add(this._createMenuItemRaidConfiguration());
    }

    private JMenuItem _createMenuItemDisplayParcoursInBrowser() {
        this._menuItem = new JMenuItem(L10n.getString("desktop.menu.raid.summary.menuitem"));
        this._menuItem.addActionListener(action -> this._presenter.displayRaidSummary());
        return this._menuItem;
    }

    private JMenuItem _createMenuEquipeSearch() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.raid.search.equipe"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        menuItem.addActionListener(event -> this._presenter.searchEquipe());
        return menuItem;
    }

    private JMenuItem _createMenuItemPenalty() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.raid.penalty"));
        menuItem.addActionListener(event -> this._presenter.managePenalties());
        return menuItem;
    }

    private JMenu _createMenuSportIdentResults() {
        JMenu menu = new JMenu(L10n.getString("desktop.menu.raid.sportident"));
        menu.add(this._createMenuItemManageResults());
        menu.add(this._createMenuItemExportResultToCsvFile());
        menu.add(this._createMenuImportResultFromCsvFile());
        return menu;
    }

    private JMenuItem _createMenuItemManageResults() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.sportident.manage"));
        menuItem.addActionListener(event -> this._presenter.managePuceResults());
        return menuItem;
    }

    private JMenuItem _createMenuItemExportResultToCsvFile() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.sportident.export"));
        menuItem.addActionListener(event -> this._presenter.exportResultToCsvFile());
        return menuItem;
    }

    private JMenuItem _createMenuImportResultFromCsvFile() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.sportident.import"));
        menuItem.addActionListener(action -> this._presenter.importResultFromCsvFile());
        return menuItem;
    }

    private JMenuItem _createMenuItemRaidConfiguration() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.raid.settings"));
        menuItem.addActionListener(event -> this._presenter.configureRaid());
        return menuItem;
    }

    private JMenuItem _createMenuReplaceBalise() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.raid.replace_balise"));
        menuItem.addActionListener(event -> this._presenter.replaceBalises());
        return menuItem;
    }

    private JMenuItem _createMenuSwapTwoBalises() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("desktop.menu.raid.swap_two_balises"));
        menuItem.addActionListener(event -> this._presenter.swapTwoBalises());
        return menuItem;
    }
}

