/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.CategoryEditorDialog;
import fr.geraidv3.desktop.CategoryTableModel;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.raid_menu.RaidMenuPresenter;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.categorie.CategorieVector;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@ExcludeFromJacocoGeneratedReport
final class RaidSettingsDialog
extends GDialog {
    private final transient RaidMenuPresenter _presenter;
    private final transient CategorieVector _categories = new CategorieVector();
    private final transient Runnable _updateCallback;
    private JTextField _headerTextField;
    private JTextField _footerTextField;
    private JTable _categoryTable;
    private JTextField _raidNameTextField;
    private JButton _editButton;
    private JButton _deleteButton;
    private JButton _validateButton;

    RaidSettingsDialog(DesktopView parent, RaidMenuPresenter presenter, Runnable updateCallback) {
        super(parent);
        this._presenter = presenter;
        this._updateCallback = updateCallback;
        this._initializeUI();
        this._initializeData();
    }

    private void _initializeData() {
        this._raidNameTextField.setText(this._presenter.getRaidName());
        this._raidNameTextField.setCaretPosition(0);
        CategorieVector categories = this._presenter.getCategories();
        Vector<Categorie> categorieVector = categories.getCategorieVector();
        for (Categorie categorie : categorieVector) {
            this._categories.addCategorie(categorie);
        }
        this._categoryTable.setModel(new CategoryTableModel(this._categories));
        this._headerTextField.setText(this._presenter.getPageHeader());
        this._headerTextField.setCaretPosition(0);
        this._footerTextField.setText(this._presenter.getPageFooter());
        this._footerTextField.setCaretPosition(0);
        this._validateButton.setEnabled(false);
    }

    private void _updateCategoriesTable() {
        if (this._categoryTable.getSelectedRowCount() > 0) {
            this._editButton.setEnabled(true);
            this._deleteButton.setEnabled(true);
        } else {
            this._editButton.setEnabled(false);
            this._deleteButton.setEnabled(false);
        }
    }

    private void _initializeUI() {
        this.setSize(400, 500);
        this.setModal(true);
        this.setTitle(L10n.getString("raid_settings.title"));
        this.setLayout(new BorderLayout());
        this.add((Component)this._createRaidNamePanel(), "North");
        this.add((Component)this._createCategoriesPanel(), "Center");
        this.add((Component)this._createButtonPanel(), "South");
        this.pack();
    }

    private JPanel _createCategoriesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add((Component)this._createRaidCategoriesPanel(), "Center");
        panel.add((Component)this._createPrintPanel(), "South");
        return panel;
    }

    private JPanel _createRaidNamePanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add((Component)new JLabel(L10n.getString("raid_settings.name")), "West");
        this._raidNameTextField = new JTextField();
        this._raidNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                RaidSettingsDialog.this._setModified();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                RaidSettingsDialog.this._setModified();
            }
        });
        panel.add((Component)this._raidNameTextField, "Center");
        return panel;
    }

    private JPanel _createRaidCategoriesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("raid_settings.category.title"), 4, 2));
        panel.add((Component)this._createCategoryButtonPanel(), "North");
        panel.add((Component)this._createCategoryList(), "Center");
        return panel;
    }

    private JPanel _createCategoryButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this._createAddButton());
        panel.add(this._createEditButton());
        panel.add(this._createDeleteButton());
        return panel;
    }

    private JScrollPane _createCategoryList() {
        this._categoryTable = new JTable();
        this._categoryTable.setSelectionMode(0);
        this._categoryTable.setSize(new Dimension(292, 120));
        this._categoryTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() > 1) {
                    RaidSettingsDialog.this._editSelectedCategory();
                }
                RaidSettingsDialog.this._updateCategoriesTable();
            }
        });
        this._categoryTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(295, 125));
        scrollPane.setViewportView(this._categoryTable);
        return scrollPane;
    }

    private JButton _createAddButton() {
        IconButton button = new IconButton("add-24.png");
        button.setToolTipText(L10n.getString("raid_settings.category.add"));
        button.addActionListener(event -> {
            CategoryEditorDialog editor = new CategoryEditorDialog(this, new Categorie(), this._categories, c -> {
                this._categoryTable.setModel(new CategoryTableModel((CategorieVector)c));
                int lastRow = this._categoryTable.getRowCount() - 1;
                this._categoryTable.setRowSelectionInterval(lastRow, lastRow);
                this._updateCategoriesTable();
                this._setModified();
            }, true);
            editor.setLocationRelativeTo(this);
            editor.setVisible(true);
        });
        return button;
    }

    private JButton _createEditButton() {
        this._editButton = new IconButton("edit-24.png");
        this._editButton.setEnabled(false);
        this._editButton.setToolTipText(L10n.getString("raid_settings.category.modify"));
        this._editButton.addActionListener(event -> this._editSelectedCategory());
        return this._editButton;
    }

    private void _editSelectedCategory() {
        String selectedLongName = this._categoryTable.getModel().getValueAt(this._categoryTable.getSelectedRow(), 1).toString();
        Categorie category = this._categories.getCategorieFromShortName(selectedLongName);
        CategoryEditorDialog view = new CategoryEditorDialog(this, category, this._categories, c -> {
            this._categoryTable.setModel(new CategoryTableModel((CategorieVector)c));
            this._setModified();
        }, false);
        view.setLocationRelativeTo(this);
        view.setVisible(true);
    }

    private JButton _createDeleteButton() {
        this._deleteButton = new IconButton("delete-24.png");
        this._deleteButton.setEnabled(false);
        this._deleteButton.setToolTipText(L10n.getString("raid_settings.category.delete"));
        this._deleteButton.addActionListener(event -> {
            if (this._categoryTable.getSelectedRow() >= 0) {
                String shortName = this._categoryTable.getModel().getValueAt(this._categoryTable.getSelectedRow(), 1).toString();
                this._categories.removeCategorieWithShortName(shortName);
                this._categoryTable.setModel(new CategoryTableModel(this._categories));
                this._setModified();
                this._updateCategoriesTable();
            }
        });
        return this._deleteButton;
    }

    private JPanel _createPrintPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("raid_settings.print.title"), 4, 2));
        GridBagConstraints c11 = new GridBagConstraints();
        c11.gridy = 0;
        c11.gridx = 0;
        c11.anchor = 22;
        c11.weightx = 0.0;
        c11.ipadx = 10;
        panel.add((Component)new JLabel(L10n.getString("raid_settings.print.header")), c11);
        GridBagConstraints c12 = new GridBagConstraints();
        c12.gridy = 0;
        c12.gridx = 1;
        c12.anchor = 21;
        c12.weightx = 1.0;
        c12.gridwidth = 3;
        c12.fill = 2;
        panel.add((Component)this._createHeaderTexField(), c12);
        GridBagConstraints c21 = new GridBagConstraints();
        c21.gridy = 1;
        c21.gridx = 0;
        c21.anchor = 22;
        c21.weightx = 0.0;
        c21.ipadx = 10;
        panel.add((Component)new JLabel(L10n.getString("raid_settings.print.footer")), c21);
        GridBagConstraints c22 = new GridBagConstraints();
        c22.gridy = 1;
        c22.gridx = 1;
        c22.anchor = 21;
        c22.weightx = 1.0;
        c22.gridwidth = 3;
        c22.fill = 2;
        panel.add((Component)this._createFooterTextField(), c22);
        return panel;
    }

    private JTextField _createHeaderTexField() {
        this._headerTextField = new JTextField();
        this._headerTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                RaidSettingsDialog.this._setModified();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                RaidSettingsDialog.this._setModified();
            }
        });
        return this._headerTextField;
    }

    private JTextField _createFooterTextField() {
        this._footerTextField = new JTextField();
        this._footerTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                RaidSettingsDialog.this._setModified();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                RaidSettingsDialog.this._setModified();
            }
        });
        return this._footerTextField;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 50, 5));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createValidateButton() {
        this._validateButton = new JButton(L10n.getString("validate"));
        this._validateButton.addActionListener(event -> {
            this._presenter.setRaidName(this._raidNameTextField.getText().trim());
            this._presenter.setPageHeader(this._headerTextField.getText().trim());
            this._presenter.setPageFooter(this._footerTextField.getText().trim());
            this._presenter.setCategories(this._categories);
            this._updateCallback.run();
            this.dispose();
        });
        this.setDefaultButton(this._validateButton);
        return this._validateButton;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }

    private void _setModified() {
        this._validateButton.setEnabled(true);
    }
}

