/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_panel;

import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

@ExcludeFromJacocoGeneratedReport
final class EpreuveListCellRenderer
extends JLabel
implements ListCellRenderer<Epreuve> {
    public EpreuveListCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Epreuve> list, Epreuve epreuve, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setForeground(this._copyColor(list.getSelectionForeground()));
            this.setBackground(this._copyColor(list.getSelectionBackground()));
        } else {
            this.setBackground(this._copyColor(list.getBackground()));
            this.setForeground(this._copyColor(list.getForeground()));
        }
        StringBuilder epreuveBuilder = new StringBuilder("<html><meta charset='UTF-8'>" + epreuve.getSymbol(isSelected && cellHasFocus));
        epreuveBuilder.append(epreuve);
        if (epreuve.isVariante()) {
            epreuveBuilder.append(" \u2605");
        }
        epreuveBuilder.append("</html>");
        this.setText(epreuveBuilder.toString());
        this.setEnabled(list.isEnabled());
        return this;
    }

    private Color _copyColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }
}

