/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.parcours.ParcoursVariante;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public final class MultipleVarianteEditor
extends GDialog {
    private final transient Consumer<List<ParcoursVariante>> _updateCallback;
    private final transient DesktopPresenter _presenter;
    private final String _baseName;
    private final List<ParcoursVariante> _listVariante = new ArrayList<ParcoursVariante>();
    private JSpinner _startSpinner;
    private JSpinner _endSpinner;
    private JLabel _errorLabel;

    public MultipleVarianteEditor(JFrame parent, DesktopPresenter presenter, String baseName, Consumer<List<ParcoursVariante>> updateCallback) {
        super(parent);
        this.setModal(true);
        this.setTitle(L10n.getString("multiple_variante_editor.title"));
        this._updateCallback = updateCallback;
        this._presenter = presenter;
        this._baseName = baseName;
        this._initializeUI();
    }

    private void _initializeUI() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)this._createTitleLabel(), "North");
        contentPanel.add((Component)this._createStartAndEndPanel(), "Center");
        contentPanel.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(contentPanel);
        this.pack();
    }

    private JPanel _createErrorPanel() {
        JPanel panelError = new JPanel(new FlowLayout(0));
        this._errorLabel = new JLabel(" ");
        this._errorLabel.setForeground(Color.red);
        Dimension preferredSize = this._errorLabel.getPreferredSize();
        preferredSize.width = 300;
        this._errorLabel.setPreferredSize(preferredSize);
        panelError.add(this._errorLabel);
        return panelError;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }

    private JButton _createValidateButton() {
        JButton button = new JButton(L10n.getString("multiple_variante_editor.validate"));
        button.addActionListener(event -> {
            this._listVariante.clear();
            int start = (Integer)this._startSpinner.getValue();
            int end = (Integer)this._endSpinner.getValue();
            for (int i = start; i <= end; ++i) {
                String varianteName = this._baseName + "-" + i;
                ParcoursVariante variante = new ParcoursVariante(varianteName);
                if (this._presenter.getRaid().existsAnotherVarianteWithSameName(varianteName, variante)) {
                    DesktopView.beep();
                    this._errorLabel.setText(L10n.getString("multiple_variante_editor.error", varianteName));
                    return;
                }
                this._listVariante.add(variante);
            }
            this._updateCallback.accept(this._listVariante);
            this.dispose();
        });
        this.setDefaultButton(button);
        return button;
    }

    private JPanel _createStartAndEndPanel() {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(this._createStartPanel());
        centerPanel.add(this._createEndPanel());
        centerPanel.add(this._createErrorPanel());
        return centerPanel;
    }

    private JPanel _createStartPanel() {
        JPanel startPanel = new JPanel(new FlowLayout(0));
        JLabel startLabel = new JLabel(L10n.getString("multiple_variante_editor.start_label"));
        startPanel.add(startLabel);
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 99, 1);
        this._startSpinner = new JSpinner(model);
        this._startSpinner.addChangeListener(event -> {
            if ((Integer)this._startSpinner.getValue() >= (Integer)this._endSpinner.getValue()) {
                this._endSpinner.setValue((Integer)this._startSpinner.getValue() + 1);
            }
        });
        startPanel.add(this._startSpinner);
        return startPanel;
    }

    private JPanel _createEndPanel() {
        JPanel endPanel = new JPanel(new FlowLayout(0));
        JLabel endLabel = new JLabel(L10n.getString("multiple_variante_editor.end_label"));
        endPanel.add(endLabel);
        SpinnerNumberModel model = new SpinnerNumberModel(2, 1, 99, 1);
        this._endSpinner = new JSpinner(model);
        this._endSpinner.addChangeListener(event -> {
            if ((Integer)this._startSpinner.getValue() >= (Integer)this._endSpinner.getValue()) {
                this._endSpinner.setValue((Integer)this._startSpinner.getValue() + 1);
            }
        });
        endPanel.add(this._endSpinner);
        return endPanel;
    }

    private JPanel _createTitleLabel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("multiple_variante_editor.label")));
        return panel;
    }
}

