/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.raid_panel.BaliseEditor;
import fr.geraidv3.desktop.raid_panel.EpreuveEditor;
import fr.geraidv3.desktop.raid_panel.EtapeEditor;
import fr.geraidv3.desktop.raid_panel.MultipleBaliseEditor;
import fr.geraidv3.desktop.raid_panel.MultipleVarianteEditor;
import fr.geraidv3.desktop.raid_panel.ParcoursEditor;
import fr.geraidv3.desktop.raid_panel.RaidView;
import fr.geraidv3.desktop.raid_panel.VarianteEditor;
import fr.geraidv3.desktop.raid_panel.XmlParcoursReader;
import fr.geraidv3.desktop.swing_ext.MyComboBox;
import fr.geraidv3.model.SortType;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.epreuve.CsvEpreuveHelper;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.epreuve.StandardEpreuveFactory;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.etape.EtapeEpreuveMap;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.utils.FileUtils;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

final class RaidPresenter {
    private final DesktopPresenter _desktopPresenter;
    private final RaidView _raidView;
    private final JList<Equipe> _equipeList;
    private final JList<Epreuve> _epreuveList;
    private final JList<Balise> _baliseList;
    private final JComboBox<Parcours> _parcoursComboBox;
    private final MyComboBox<ParcoursVariante> _varianteComboBox;
    private final JComboBox<Etape> _etapeComboBox;

    RaidPresenter(RaidView raidView, DesktopPresenter desktopPresenter, JList<Equipe> equipeList, JComboBox<Parcours> parcoursComboBox, MyComboBox<ParcoursVariante> varianteComboBox, JList<Epreuve> epreuveList, JComboBox<Etape> etapeComboBox, JList<Balise> baliseList) {
        this._raidView = raidView;
        this._desktopPresenter = desktopPresenter;
        this._equipeList = equipeList;
        this._parcoursComboBox = parcoursComboBox;
        this._varianteComboBox = varianteComboBox;
        this._epreuveList = epreuveList;
        this._etapeComboBox = etapeComboBox;
        this._baliseList = baliseList;
    }

    public MyComboBox<ParcoursVariante> getVarianteComboBox() {
        return this._varianteComboBox;
    }

    public void selectVariante() {
        if (this._parcoursComboBox.getSelectedIndex() > -1) {
            if (this._varianteComboBox.getSelectedItemIndex() > -1) {
                assert (this._varianteComboBox.getSelectedItemValue() != null);
                ParcoursVariante selectedVariante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
                this._equipeList.setListData(selectedVariante.getEquipeVector().getEquipeVector());
                this._desktopPresenter.updateTeamTotal(selectedVariante.getNumberOfEquipes());
            } else {
                assert (this._parcoursComboBox.getSelectedItem() != null);
                Parcours selectedParcours = (Parcours)this._parcoursComboBox.getSelectedItem();
                EquipeVector equipeVector = selectedParcours.getEquipeVector();
                equipeVector.sortEquipes(SortType.DOSSARD);
                this._equipeList.setListData(equipeVector.getEquipeVector());
                this._desktopPresenter.updateTeamTotal(selectedParcours.getTotalNumberOfEquipes());
            }
            this._equipeList.repaint();
            this._equipeList.setSelectedIndex(this._equipeList.getModel().getSize() > 0 ? 0 : -1);
            this._desktopPresenter.update();
        }
        assert (this._parcoursComboBox.getSelectedItem() != null);
        this._etapeComboBox.setModel(new DefaultComboBoxModel<Etape>(((Parcours)this._parcoursComboBox.getSelectedItem()).getEtapeVector()));
        this._etapeComboBox.repaint();
        this._etapeComboBox.setSelectedIndex(this._etapeComboBox.getItemCount() > 0 ? 0 : -1);
    }

    public void addVariante() {
        VarianteEditor varianteEditor = new VarianteEditor(this._desktopPresenter.getFrame(), this._desktopPresenter, new ParcoursVariante(""), v -> {
            assert (this._parcoursComboBox.getSelectedItem() != null);
            ((Parcours)this._parcoursComboBox.getSelectedItem()).addVariante((ParcoursVariante)v);
            this._varianteComboBox.setModel(new DefaultComboBoxModel<ParcoursVariante>(((Parcours)this._parcoursComboBox.getSelectedItem()).getVarianteVector().getVarianteParcoursVector()));
            this._varianteComboBox.setSelectedValue((ParcoursVariante)v);
            this._desktopPresenter.setModified(true);
        }, true);
        varianteEditor.setLocationRelativeTo(null);
        varianteEditor.setVisible(true);
    }

    public void addMultipleVariantes() {
        assert (this._parcoursComboBox.getSelectedItem() != null);
        MultipleVarianteEditor editor = new MultipleVarianteEditor(this._desktopPresenter.getFrame(), this._desktopPresenter, ((Parcours)this._parcoursComboBox.getSelectedItem()).getName(), listVariante -> {
            assert (this._parcoursComboBox.getSelectedItem() != null);
            Parcours selectedParcours = (Parcours)this._parcoursComboBox.getSelectedItem();
            for (ParcoursVariante variante : listVariante) {
                selectedParcours.addVariante(variante);
            }
            this._varianteComboBox.setModel(new DefaultComboBoxModel<ParcoursVariante>(selectedParcours.getVarianteVector().getVarianteParcoursVector()));
            this._varianteComboBox.setSelectedItemIndex(selectedParcours.getVarianteVector().getSize() - 1);
            this._desktopPresenter.setModified(true);
        });
        editor.setLocationRelativeTo(null);
        editor.setVisible(true);
    }

    public void editVariante() {
        VarianteEditor editor = new VarianteEditor(this._desktopPresenter.getFrame(), this._desktopPresenter, (ParcoursVariante)this._varianteComboBox.getSelectedItemValue(), v -> {
            this._varianteComboBox.repaint();
            this._desktopPresenter.setModified(true);
        }, false);
        editor.setLocationRelativeTo(null);
        editor.setVisible(true);
    }

    public void removeVariante() {
        assert (this._varianteComboBox.getSelectedItemValue() != null);
        String message = String.format(L10n.getString("raid_panel.variante.delete.confirmation", this._varianteComboBox.getSelectedItemValue().toString()), new Object[0]);
        int choice = JOptionPane.showConfirmDialog(this._raidView.getRootPane(), message, L10n.getString("confirmation_title"), 0, 3);
        if (choice == 0) {
            assert (this._parcoursComboBox.getSelectedItem() != null);
            Parcours selectedParcours = (Parcours)this._parcoursComboBox.getSelectedItem();
            selectedParcours.removeVariante((ParcoursVariante)this._varianteComboBox.getSelectedItemValue());
            this._varianteComboBox.setModel(new DefaultComboBoxModel<ParcoursVariante>(selectedParcours.getVarianteVector().getVarianteParcoursVector()));
            this._varianteComboBox.setSelectedItemIndex(0);
            this._varianteComboBox.repaint();
            this._desktopPresenter.setModified(true);
        }
    }

    void duplicateVariante() {
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        assert (parcours != null);
        assert (this._varianteComboBox.getSelectedItem() != null);
        ParcoursVariante varianteToDuplicate = new ParcoursVariante((ParcoursVariante)this._varianteComboBox.getSelectedItem());
        parcours.addVariante(varianteToDuplicate);
        this._varianteComboBox.setModel(new DefaultComboBoxModel<ParcoursVariante>(parcours.getVarianteVector().getVarianteParcoursVector()));
        this._varianteComboBox.setSelectedValue(varianteToDuplicate);
        this._desktopPresenter.setModified(true);
    }

    JComboBox<Parcours> getParcoursComboBox() {
        return this._parcoursComboBox;
    }

    JList<Epreuve> getEpreuveList() {
        return this._epreuveList;
    }

    JComboBox<Etape> getEtapeComboBox() {
        return this._etapeComboBox;
    }

    JList<Balise> getBaliseList() {
        return this._baliseList;
    }

    void selectParcours() {
        if (this._parcoursComboBox.getSelectedIndex() != -1) {
            assert (this._parcoursComboBox.getSelectedItem() != null);
            Parcours selectedParcours = (Parcours)this._parcoursComboBox.getSelectedItem();
            this._varianteComboBox.setModel(new DefaultComboBoxModel<ParcoursVariante>(selectedParcours.getVarianteVector().getVarianteParcoursVector()));
            this._varianteComboBox.setSelectedItemIndex(0);
            this._varianteComboBox.repaint();
            if (this._varianteComboBox.getModel().getSize() == 0) {
                this._etapeComboBox.setModel(new DefaultComboBoxModel<Etape>(selectedParcours.getEtapeVector()));
                this._etapeComboBox.repaint();
                this._etapeComboBox.setSelectedIndex(-1);
                this._equipeList.setListData(selectedParcours.getEquipeVector().getEquipeVector());
                this._equipeList.repaint();
                this._equipeList.setSelectedIndex(this._equipeList.getModel().getSize() > 0 ? 0 : -1);
                this._desktopPresenter.updateTeamTotal(selectedParcours.getTotalNumberOfEquipes());
            }
            this._desktopPresenter.updateTeamTotal(selectedParcours.getTotalNumberOfEquipes());
        } else {
            this._varianteComboBox.setModel(new DefaultComboBoxModel(new Vector()));
            this._varianteComboBox.repaint();
            this._varianteComboBox.setSelectedItemIndex(0);
            this._equipeList.setListData(new Vector());
            this._equipeList.repaint();
            this._desktopPresenter.updateTeamTotal(0);
            this._equipeList.setSelectedIndex(-1);
            this._etapeComboBox.removeAllItems();
            this._etapeComboBox.repaint();
            this._etapeComboBox.setSelectedIndex(-1);
            this._raidView.setBaliseAndPointTotal(0, 0);
        }
        this._desktopPresenter.refreshResultTable();
    }

    void addParcours() {
        ParcoursEditor parcoursEditor = new ParcoursEditor(this._desktopPresenter.getFrame(), this._desktopPresenter, new Parcours(""), p -> {
            this._desktopPresenter.getRaid().addParcours((Parcours)p);
            p.addVariante(new ParcoursVariante(p.getName() + "-0"));
            JComboBox<Parcours> comboBox = this._desktopPresenter.getParcoursComboBox();
            comboBox.repaint();
            this._desktopPresenter.updateRaidPanel();
            this._desktopPresenter.update();
            comboBox.setSelectedIndex(comboBox.getItemCount() - 1);
            this._desktopPresenter.setModified(true);
        }, true);
        parcoursEditor.setLocationRelativeTo(null);
        parcoursEditor.setVisible(true);
    }

    void duplicateParcours() {
        assert (this._parcoursComboBox.getSelectedItem() != null);
        Parcours parcours = new Parcours((Parcours)this._parcoursComboBox.getSelectedItem());
        this._desktopPresenter.addNewParcours(parcours);
        this._parcoursComboBox.setModel(new DefaultComboBoxModel<Parcours>(this._desktopPresenter.getParcoursList()));
        this._parcoursComboBox.setSelectedIndex(this._parcoursComboBox.getItemCount() - 1);
        this._desktopPresenter.setModified(true);
    }

    void toggleVarianteInParcours() {
        assert (this._parcoursComboBox.getSelectedItem() != null);
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        parcours.setHasVariantes(true);
        this._raidView.update(this._desktopPresenter);
    }

    void deleteParcours() {
        assert (this._parcoursComboBox.getSelectedItem() != null);
        String message = String.format(L10n.getString("raid_panel.parcours.delete.confirmation", this._parcoursComboBox.getSelectedItem().toString()), new Object[0]);
        int choice = JOptionPane.showConfirmDialog(this._raidView.getRootPane(), message, L10n.getString("confirmation_title"), 0, 3);
        if (choice == 0) {
            this._desktopPresenter.getRaid().removeParcours((Parcours)this._parcoursComboBox.getSelectedItem());
            this._parcoursComboBox.repaint();
            this._desktopPresenter.updateRaidPanel();
            this._desktopPresenter.setModified(true);
            this._parcoursComboBox.setSelectedIndex(this._parcoursComboBox.getItemCount() - 1);
        }
    }

    void editParcours() {
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        ParcoursEditor parcoursEditor = new ParcoursEditor(this._desktopPresenter.getFrame(), this._desktopPresenter, parcours, p -> {
            JComboBox<Parcours> comboBox = this._desktopPresenter.getParcoursComboBox();
            comboBox.repaint();
            if (this._varianteComboBox.getSelectedItemIndex() <= -1) {
                Parcours selectedItem = (Parcours)comboBox.getSelectedItem();
                assert (selectedItem != null);
                this._equipeList.setListData(selectedItem.getEquipeVector().getEquipeVector());
                this._equipeList.repaint();
                this._equipeList.setSelectedIndex(this._equipeList.getModel().getSize() > 0 ? 0 : -1);
                this._desktopPresenter.setModified(true);
            }
            this._desktopPresenter.getEquipeList().repaint();
        }, false);
        parcoursEditor.setLocationRelativeTo(null);
        parcoursEditor.setVisible(true);
    }

    void selectEtape() {
        if (this.isEtapeSelected()) {
            Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
            ParcoursVariante variante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
            Etape etape = (Etape)this._etapeComboBox.getSelectedItem();
            assert (etape != null);
            EpreuveVector epreuveVector = etape.getEpreuvesBetween(parcours, variante);
            assert (epreuveVector != null);
            this._epreuveList.setListData(epreuveVector.getEpreuveVector());
            this._epreuveList.repaint();
            if (this._epreuveList.getModel().getSize() > 0) {
                this._epreuveList.setSelectedIndex(0);
                this._raidView.setBaliseAndPointTotal(this._epreuveList.getSelectedValue().getNbBalises(), this._epreuveList.getSelectedValue().getTotalPoints());
            } else {
                this._epreuveList.setSelectedIndex(-1);
                this._raidView.setBaliseAndPointTotal(0, 0);
            }
        } else {
            this._epreuveList.setListData(new Vector());
            this._epreuveList.repaint();
            this._epreuveList.setSelectedIndex(-1);
            this._raidView.setBaliseAndPointTotal(0, 0);
        }
        this._equipeList.repaint();
        this._equipeList.setSelectedIndex(this._equipeList.getModel().getSize() > 0 ? 0 : -1);
        this._desktopPresenter.refreshResultTable();
    }

    boolean isEtapeSelected() {
        return this._etapeComboBox.getSelectedIndex() > -1;
    }

    boolean isEpreuveSelected() {
        return this._epreuveList.getModel().getSize() > 0;
    }

    boolean isBaliseSelected() {
        return this._baliseList.getModel().getSize() > 0;
    }

    void addEtape() {
        EtapeEditor editor = new EtapeEditor(this._desktopPresenter.getFrame(), (Parcours)this._parcoursComboBox.getSelectedItem(), new Etape(), e -> {
            assert (this._parcoursComboBox.getSelectedItem() != null);
            ((Parcours)this._parcoursComboBox.getSelectedItem()).addEtape((Etape)e);
            this._etapeComboBox.setModel(new DefaultComboBoxModel<Etape>(((Parcours)this._parcoursComboBox.getSelectedItem()).getEtapeVector()));
            this._etapeComboBox.setSelectedIndex(((Parcours)this._parcoursComboBox.getSelectedItem()).getEtapeVector().size() - 1);
            this._desktopPresenter.setModified(true);
            this._raidView.update(this._desktopPresenter);
        }, true);
        editor.setLocationRelativeTo(null);
        editor.setVisible(true);
    }

    void editEtape() {
        Parcours selectedItem = (Parcours)this._parcoursComboBox.getSelectedItem();
        assert (selectedItem != null);
        EtapeEditor editor = new EtapeEditor(this._desktopPresenter.getFrame(), selectedItem, (Etape)this._etapeComboBox.getSelectedItem(), etape -> {
            this._etapeComboBox.repaint();
            this._desktopPresenter.setModified(true);
        }, false);
        editor.setLocationRelativeTo(null);
        editor.setVisible(true);
    }

    void deleteEtape() {
        JComboBox<Etape> etapeComboBox = this._etapeComboBox;
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        Etape etape = (Etape)etapeComboBox.getSelectedItem();
        assert (parcours != null);
        if (this._parcoursComboBox.getSelectedIndex() != -1 && !parcours.getEtapeVector().isEmpty() && etapeComboBox.getSelectedIndex() != -1) {
            assert (etape != null);
            String message = String.format(L10n.getString("raid_panel.etape.delete.confirmation", etape.toString()), new Object[0]);
            int answer = JOptionPane.showConfirmDialog(this._raidView.getRootPane(), message, L10n.getString("confirmation_title"), 0, 3);
            if (answer == 0) {
                parcours.removeEtape(etape);
                this._desktopPresenter.getRaid().getPuceResultVector().removeEtape(etape);
                this._desktopPresenter.getRaid().getPenaliteVector().removeEtape(etape);
                Parcours selectedItem = (Parcours)this._parcoursComboBox.getSelectedItem();
                assert (selectedItem != null);
                this._etapeComboBox.setModel(new DefaultComboBoxModel<Etape>(selectedItem.getEtapeVector()));
                etapeComboBox.repaint();
                etapeComboBox.setSelectedIndex(!parcours.getEtapeVector().isEmpty() ? 0 : -1);
                this._desktopPresenter.setModified(true);
                this._raidView.update(this._desktopPresenter);
            }
        }
    }

    void moveDownEpreuve() {
        assert (this._etapeComboBox.getSelectedItem() != null);
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        assert (parcours != null);
        ParcoursVariante variante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
        EpreuveVector epreuveVector1 = ((Etape)this._etapeComboBox.getSelectedItem()).getEpreuvesBetween(parcours, variante);
        assert (epreuveVector1 != null);
        Epreuve epreuve = this._epreuveList.getSelectedValue();
        epreuveVector1.moveDownEpreuve(epreuve);
        if (!parcours.hasVariantes()) {
            ParcoursVariante variante2 = (ParcoursVariante)this._varianteComboBox.getModel().getElementAt(0);
            EpreuveVector epreuveVector2 = ((Etape)this._etapeComboBox.getSelectedItem()).getEpreuvesBetween(parcours, variante2);
            assert (epreuveVector2 != null);
            epreuveVector2.moveDownEpreuve(epreuve);
        }
        this._epreuveList.repaint();
        int index = this._epreuveList.getSelectedIndex() + 1;
        this._epreuveList.setSelectedIndex(index);
        this._epreuveList.ensureIndexIsVisible(index);
        this._desktopPresenter.setModified(true);
    }

    void moveUpEpreuve() {
        assert (this._etapeComboBox.getSelectedItem() != null);
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        assert (parcours != null);
        ParcoursVariante variante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
        EpreuveVector epreuveVector1 = ((Etape)this._etapeComboBox.getSelectedItem()).getEpreuvesBetween(parcours, variante);
        assert (epreuveVector1 != null);
        Epreuve epreuve = this._epreuveList.getSelectedValue();
        epreuveVector1.moveUpEpreuve(epreuve);
        if (!parcours.hasVariantes()) {
            ParcoursVariante variante2 = (ParcoursVariante)this._varianteComboBox.getModel().getElementAt(0);
            EpreuveVector epreuveVector2 = ((Etape)this._etapeComboBox.getSelectedItem()).getEpreuvesBetween(parcours, variante2);
            assert (epreuveVector2 != null);
            epreuveVector2.moveUpEpreuve(epreuve);
        }
        this._epreuveList.repaint();
        int index = this._epreuveList.getSelectedIndex() - 1;
        this._epreuveList.setSelectedIndex(index);
        this._epreuveList.ensureIndexIsVisible(index);
        this._desktopPresenter.setModified(true);
    }

    void selectEpreuve() {
        if (this._epreuveList.getSelectedIndex() > -1) {
            this._baliseList.setListData(this._epreuveList.getSelectedValue().getBaliseVector().getBaliseVector());
            this._baliseList.repaint();
            if (this._baliseList.getModel().getSize() > 0) {
                this._baliseList.setSelectedIndex(0);
            } else {
                this._baliseList.setSelectedIndex(-1);
            }
            this._raidView.setBaliseAndPointTotal(this._epreuveList.getSelectedValue().getNbBalises(), this._epreuveList.getSelectedValue().getTotalPoints());
        } else {
            this._baliseList.setListData(new Vector());
            this._baliseList.repaint();
            this._baliseList.setSelectedIndex(-1);
            this._raidView.setBaliseAndPointTotal(0, 0);
        }
        this._desktopPresenter.update();
        this._desktopPresenter.refreshResultTable();
    }

    void addEpreuve() {
        if (this._etapeComboBox.getSelectedIndex() > -1 && this._parcoursComboBox.getSelectedIndex() > -1) {
            EtapeEpreuveMap etapeEpreuveMap;
            Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
            ParcoursVariante variante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
            if (variante == null) {
                assert (parcours != null);
                etapeEpreuveMap = parcours.getEtapeEpreuveMap();
            } else {
                etapeEpreuveMap = variante.getEtapeEpreuveMap();
            }
            Epreuve newEpreuve = new StandardEpreuveFactory().createEpreuve(this._desktopPresenter.getGlobalSettings());
            EpreuveEditor editor = new EpreuveEditor(this._desktopPresenter.getFrame(), newEpreuve, (Etape)this._etapeComboBox.getSelectedItem(), etapeEpreuveMap, epreuve -> {
                Etape etape = (Etape)this._etapeComboBox.getSelectedItem();
                assert (etape != null);
                EpreuveVector epreuves = etapeEpreuveMap.getEpreuvesOfEtape(etape);
                if (variante != null) {
                    epreuve.setVariante(true);
                    variante.addEpreuveToEtape(etape, (Epreuve)epreuve);
                } else {
                    parcours.addEpreuveToEtape(etape, (Epreuve)epreuve);
                }
                this._epreuveList.setListData(epreuves.getEpreuveVector());
                this._epreuveList.setSelectedValue(epreuve, true);
                this._desktopPresenter.setModified(true);
                this._raidView.update(this._desktopPresenter);
            }, true, variante != null);
            editor.setLocationRelativeTo(null);
            editor.setVisible(true);
        }
    }

    void editEpreuve() {
        EtapeEpreuveMap etapeEpreuveMap;
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        ParcoursVariante variante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
        if (variante == null) {
            assert (parcours != null);
            etapeEpreuveMap = parcours.getEtapeEpreuveMap();
        } else {
            etapeEpreuveMap = variante.getEtapeEpreuveMap();
        }
        Epreuve selectedEpreuve = this._epreuveList.getSelectedValue();
        Balise baliseModel = new Balise(selectedEpreuve.getBaliseModel());
        EpreuveEditor editor = new EpreuveEditor(this._desktopPresenter.getFrame(), selectedEpreuve, (Etape)this._etapeComboBox.getSelectedItem(), etapeEpreuveMap, e -> {
            int answer;
            this._etapeComboBox.repaint();
            assert (this._etapeComboBox.getSelectedItem() != null);
            Etape selectedEtape = (Etape)this._etapeComboBox.getSelectedItem();
            if (e.isVariante()) {
                assert (parcours != null);
                parcours.dissociateEpreuveOfEtape(selectedEtape, (Epreuve)e);
            }
            this._epreuveList.setListData(etapeEpreuveMap.getEpreuvesOfEtape(selectedEtape).getEpreuveVector());
            this._epreuveList.setSelectedValue(e, true);
            if (baliseModel.differsFrom(e.getBaliseModel()) && (answer = JOptionPane.showConfirmDialog(this._raidView.getRootPane(), L10n.getString("raid_panel.etape.modify_balise_model.confirmation"), L10n.getString("confirmation_title"), 0, 3)) == 0) {
                e.applyBaliseModelToAllBalises();
            }
            this._desktopPresenter.setModified(true);
        }, false, variante != null);
        editor.setLocationRelativeTo(null);
        editor.setVisible(true);
    }

    void deleteEpreuve() {
        Etape selectedItem = (Etape)this._etapeComboBox.getSelectedItem();
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        assert (parcours != null);
        ParcoursVariante variante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
        assert (selectedItem != null);
        EpreuveVector epreuveVector = selectedItem.getEpreuvesBetween(parcours, variante);
        assert (epreuveVector != null);
        if (this.isEtapeSelected() && epreuveVector.getSize() != 0 && this._epreuveList.getSelectedIndex() != -1) {
            boolean isInVariante;
            Epreuve epreuve = this._epreuveList.getSelectedValue();
            boolean bl = isInVariante = variante != null;
            if (!epreuve.isVariante() && isInVariante) {
                String confirmationMessage = String.format(L10n.getString("raid_panel.epreuve.delete.error", this._epreuveList.getSelectedValue().toString()), new Object[0]);
                JOptionPane.showMessageDialog(this._raidView.getRootPane(), confirmationMessage, L10n.getString("error"), 0);
            } else {
                String confirmationMessage = String.format(L10n.getString("raid_panel.epreuve.delete.confirmation", this._epreuveList.getSelectedValue().toString()), new Object[0]);
                int answer = JOptionPane.showConfirmDialog(this._raidView.getRootPane(), confirmationMessage, L10n.getString("confirmation_title"), 0, 3);
                if (answer == 0) {
                    if (epreuve.isVariante() && isInVariante) {
                        epreuveVector.removeEpreuve(epreuve);
                    } else {
                        parcours.removeEpreuveOfEtapeGlobally(selectedItem, epreuve);
                    }
                    this._epreuveList.setListData(epreuveVector.getEpreuveVector());
                    this._epreuveList.setSelectedIndex(epreuveVector.getSize() > 0 ? 0 : -1);
                    this._epreuveList.repaint();
                    this._desktopPresenter.setModified(true);
                    this._raidView.update(this._desktopPresenter);
                }
            }
        }
    }

    void importEpreuve() {
        JFileChooser fileChooser = new JFileChooser(new File(this._desktopPresenter.getRaidFolderPath()));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("csv_file.description"), "csv");
        fileChooser.setFileFilter(filter);
        int choice = fileChooser.showOpenDialog(this._raidView.getRootPane());
        if (choice == 0) {
            String filePath = fileChooser.getSelectedFile().getAbsolutePath();
            this._desktopPresenter.setLastOpenDirectory(fileChooser.getSelectedFile());
            Etape etape = (Etape)this._etapeComboBox.getSelectedItem();
            Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
            ParcoursVariante variante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
            assert (etape != null && parcours != null);
            if (variante == null) {
                CsvEpreuveHelper.importEpreuvesOfEtape(this._desktopPresenter.getGlobalSettings(), parcours, etape, filePath);
                this._epreuveList.setListData(parcours.getEpreuvesOfEtape(etape).getEpreuveVector());
            } else {
                CsvEpreuveHelper.importEpreuvesOfEtape(this._desktopPresenter.getGlobalSettings(), variante, etape, filePath);
                this._epreuveList.setListData(variante.getEpreuvesOfEtape(etape).getEpreuveVector());
            }
            this._epreuveList.repaint();
            if (this._epreuveList.getModel().getSize() > 0) {
                this._epreuveList.setSelectedIndex(0);
            }
            this._desktopPresenter.setModified(true);
        }
    }

    void exportEpreuve() {
        JFileChooser fileChooser = new JFileChooser(new File(this._desktopPresenter.getRaidFolderPath()));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("csv_file.description"), "csv");
        fileChooser.setFileFilter(filter);
        int choice = fileChooser.showSaveDialog(this._raidView);
        if (choice == 0) {
            String filePath = FileUtils.checkExtension(fileChooser.getSelectedFile().getAbsolutePath(), ".csv");
            this._desktopPresenter.setLastOpenDirectory(fileChooser.getSelectedFile());
            Etape etape = (Etape)this._etapeComboBox.getSelectedItem();
            assert (etape != null);
            Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
            ParcoursVariante variante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
            EpreuveVector epreuveVector = etape.getEpreuvesBetween(parcours, variante);
            assert (epreuveVector != null);
            CsvEpreuveHelper.exportEpreuve(epreuveVector, filePath);
        }
    }

    void addBalise() {
        assert (this._etapeComboBox.getSelectedItem() != null);
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        ParcoursVariante variante = (ParcoursVariante)this._varianteComboBox.getSelectedItemValue();
        EpreuveVector epreuveVector = ((Etape)this._etapeComboBox.getSelectedItem()).getEpreuvesBetween(parcours, variante);
        assert (epreuveVector != null);
        int index = epreuveVector.getHigherBaliseNumber();
        Balise balise = new Balise(index + 1);
        Epreuve selectedEpreuve = this._epreuveList.getSelectedValue();
        balise.applyModel(selectedEpreuve.getBaliseModel());
        BaliseEditor editor = new BaliseEditor(this._desktopPresenter.getFrame(), balise, b -> {
            selectedEpreuve.addBalise((Balise)b);
            this._baliseList.setListData(selectedEpreuve.getBaliseVector().getBaliseVector());
            this._baliseList.setSelectedValue(b, true);
            this._raidView.setBaliseAndPointTotal(selectedEpreuve.getNbBalises(), selectedEpreuve.getTotalPoints());
            this._desktopPresenter.setModified(true);
            this._raidView.update(this._desktopPresenter);
        }, true, false);
        editor.setLocationRelativeTo(null);
        editor.setVisible(true);
    }

    void editBalise() {
        BaliseEditor editor = new BaliseEditor(this._desktopPresenter.getFrame(), this._baliseList.getSelectedValue(), b -> {
            this._baliseList.repaint();
            this._desktopPresenter.setModified(true);
        }, false, false);
        editor.setLocationRelativeTo(null);
        editor.setVisible(true);
    }

    void moveUpBalise() {
        List<Balise> selectedValues = this._baliseList.getSelectedValuesList();
        int[] selectedIndices = this._baliseList.getSelectedIndices();
        if (selectedIndices[0] > 0) {
            for (int i = 0; i < selectedValues.size(); ++i) {
                this._epreuveList.getSelectedValue().getBaliseVector().moveUpBalise(selectedIndices[i]);
                selectedIndices[i] = selectedIndices[i] - 1;
            }
            this._baliseList.repaint();
            this._baliseList.setSelectedIndices(selectedIndices);
            this._baliseList.ensureIndexIsVisible(selectedIndices[0] + 1);
            this._desktopPresenter.setModified(true);
        }
    }

    void moveDownBalise() {
        int last;
        List<Balise> selectedValues = this._baliseList.getSelectedValuesList();
        int[] selectedIndices = this._baliseList.getSelectedIndices();
        if (selectedIndices[last = selectedIndices.length - 1] < this._epreuveList.getSelectedValue().getBaliseVector().getSize() - 1) {
            for (int i = selectedValues.size() - 1; i >= 0; --i) {
                this._epreuveList.getSelectedValue().getBaliseVector().moveDownBalise(selectedIndices[i]);
                selectedIndices[i] = selectedIndices[i] + 1;
            }
            this._baliseList.repaint();
            this._baliseList.setSelectedIndices(selectedIndices);
            this._baliseList.ensureIndexIsVisible(selectedIndices[last] + 1);
            this._desktopPresenter.setModified(true);
        }
    }

    void deleteBalise() {
        List<Balise> selectedValues = this._baliseList.getSelectedValuesList();
        String confirmationMessage = selectedValues.size() == 1 ? L10n.getString("raid_panel.balise.delete.confirmation1", selectedValues.get(0)) : L10n.getString("raid_panel.balise.delete.confirmation2", selectedValues.size());
        int answer = JOptionPane.showConfirmDialog(this._raidView.getRootPane(), confirmationMessage, L10n.getString("confirmation_title"), 0, 3);
        if (answer == 0) {
            for (Balise balise : selectedValues) {
                this._epreuveList.getSelectedValue().getBaliseVector().removeBalise(balise);
            }
            this._baliseList.repaint();
            this._baliseList.setSelectedIndex(this._epreuveList.getSelectedValue().getBaliseVector().getSize() > 0 ? 0 : -1);
            this._desktopPresenter.setModified(true);
            this._raidView.update(this._desktopPresenter);
        }
        this._raidView.setBaliseAndPointTotal(this._epreuveList.getSelectedValue().getNbBalises(), this._epreuveList.getSelectedValue().getTotalPoints());
    }

    void addMultipleBalises() {
        MultipleBaliseEditor editor = new MultipleBaliseEditor(this._desktopPresenter.getFrame(), baliseIds -> {
            Epreuve epreuve = this._epreuveList.getSelectedValue();
            epreuve.addBalisesFromNumbers(baliseIds.getSelectedValuesList());
            this._baliseList.setListData(this._epreuveList.getSelectedValue().getBaliseVector().getBaliseVector());
            this._baliseList.setSelectedIndex(this._epreuveList.getSelectedValue().getBaliseVector().getSize() - 1);
            this._raidView.setBaliseAndPointTotal(this._epreuveList.getSelectedValue().getNbBalises(), this._epreuveList.getSelectedValue().getTotalPoints());
            this._desktopPresenter.setModified(true);
            this._raidView.update(this._desktopPresenter);
        });
        editor.setLocationRelativeTo(null);
        editor.setVisible(true);
    }

    void importBalisesFromIofXmlFile() {
        JFileChooser chooser = new JFileChooser(new File(this._desktopPresenter.getRaidFolderPath()));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("xml_file.description"), "xml");
        chooser.setFileFilter(filter);
        int choice = chooser.showOpenDialog(this._raidView.getRootPane());
        if (choice == 0) {
            String filePath = chooser.getSelectedFile().getAbsolutePath();
            this._desktopPresenter.setLastOpenDirectory(chooser.getSelectedFile());
            Epreuve epreuve = this._epreuveList.getSelectedValue();
            XmlParcoursReader.importEpreuve(epreuve, filePath);
            this._baliseList.setListData(epreuve.getBaliseVector().getBaliseVector());
            this._baliseList.repaint();
            this._baliseList.setSelectedIndex(this._baliseList.getModel().getSize() > 0 ? 0 : -1);
            this._raidView.setBaliseAndPointTotal(epreuve.getNbBalises(), epreuve.getTotalPoints());
            this._desktopPresenter.setModified(true);
            this._raidView.update(this._desktopPresenter);
        }
    }
}

