/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_panel;

import com.formdev.flatlaf.ui.FlatLineBorder;
import fr.geraidv3.L10n;
import fr.geraidv3.LookAndFeelTheme;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.raid_panel.EpreuveListCellRenderer;
import fr.geraidv3.desktop.raid_panel.RaidPresenter;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.desktop.swing_ext.MyComboBox;
import fr.geraidv3.desktop.swing_ext.StatefulComponent;
import fr.geraidv3.desktop.swing_ext.SwingUtils;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

@ExcludeFromJacocoGeneratedReport
public final class RaidView
extends JPanel
implements StatefulComponent {
    public static final String INTEGER_FORMAT = "%3d";
    public static final int COMBO_BOX_WIDTH = 300;
    private static final String DELETE_IMAGE_NAME = "delete-24.png";
    private static final String ADD_IMAGE_NAME = "add-24.png";
    private static final String EDIT_IMAGE_NAME = "edit-24.png";
    private final transient RaidPresenter _presenter;
    private JLabel _baliseCountLabel;
    private JButton _editParcoursButton;
    private JButton _removeParcoursButton;
    private JButton _duplicateParcoursButton;
    private JButton _toggleVarianteInParcoursButton;
    private JButton _addVarianteButton;
    private JButton _addMultipleVariantesButton;
    private JButton _editVarianteButton;
    private JButton _duplicateVarianteButton;
    private JButton _removeVarianteButton;
    private JButton _addEtapeButton;
    private JButton _editEtapeButton;
    private JButton _removeEtapeButton;
    private JButton _moveUpEpreuveButton;
    private JButton _moveDownEpreuveButton;
    private JButton _addEpreuveButton;
    private IconButton _editEpreuveButton;
    private JButton _importEpreuvesButton;
    private JButton _exportEpreuvesButton;
    private JButton _moveUpBalise;
    private JButton _moveDownBalise;
    private JButton _addBaliseButton;
    private JButton _editBaliseButton;
    private JButton _removeBaliseButton;
    private JButton _addMultipleBalisesButton;
    private JButton _removeEpreuveButton;
    private JButton _importIofXmlBalisesButton;
    private JPanel _variantePanel;

    public RaidView(DesktopPresenter presenter, JList<Equipe> equipeList, JComboBox<Parcours> parcoursComboBox, MyComboBox<ParcoursVariante> varianteCombBox, JList<Epreuve> epreuveList, JComboBox<Etape> etapeComboBox, JList<Balise> baliseList) {
        this._presenter = new RaidPresenter(this, presenter, equipeList, parcoursComboBox, varianteCombBox, epreuveList, etapeComboBox, baliseList);
        this._initializeUI();
    }

    @Override
    public void update(DesktopPresenter presenter) {
        boolean hasParcours = presenter.hasParcours();
        this._editParcoursButton.setEnabled(hasParcours);
        this._removeParcoursButton.setEnabled(hasParcours);
        this._duplicateParcoursButton.setEnabled(hasParcours);
        this._toggleVarianteInParcoursButton.setEnabled(hasParcours && !presenter.hasVariantes());
        this._addVarianteButton.setEnabled(hasParcours);
        this._addMultipleVariantesButton.setEnabled(hasParcours);
        boolean varianteSelected = hasParcours && presenter.getVarianteComboBox().getSelectedIndex() > 0;
        this._editVarianteButton.setEnabled(varianteSelected);
        this._duplicateVarianteButton.setEnabled(varianteSelected);
        this._removeVarianteButton.setEnabled(varianteSelected && presenter.getVarianteComboBox().getModel().getSize() > 1);
        this._addEtapeButton.setEnabled(hasParcours);
        boolean etapeSelected = hasParcours && this._presenter.isEtapeSelected();
        this._editEtapeButton.setEnabled(etapeSelected);
        this._removeEtapeButton.setEnabled(etapeSelected);
        this._addEpreuveButton.setEnabled(etapeSelected);
        this._importEpreuvesButton.setEnabled(etapeSelected);
        boolean epreuveSelected = hasParcours && etapeSelected && this._presenter.isEpreuveSelected();
        this._moveUpEpreuveButton.setEnabled(epreuveSelected && (!presenter.hasVariantes() || varianteSelected));
        this._moveDownEpreuveButton.setEnabled(epreuveSelected && (!presenter.hasVariantes() || varianteSelected));
        this._editEpreuveButton.setEnabled(epreuveSelected);
        this._removeEpreuveButton.setEnabled(epreuveSelected);
        this._exportEpreuvesButton.setEnabled(epreuveSelected);
        this._addBaliseButton.setEnabled(epreuveSelected);
        this._addMultipleBalisesButton.setEnabled(epreuveSelected);
        this._importIofXmlBalisesButton.setEnabled(epreuveSelected);
        boolean baliseSelected = hasParcours && etapeSelected && epreuveSelected && this._presenter.isBaliseSelected();
        this._moveUpBalise.setEnabled(baliseSelected);
        this._moveDownBalise.setEnabled(baliseSelected);
        this._editBaliseButton.setEnabled(baliseSelected);
        this._removeBaliseButton.setEnabled(baliseSelected);
        this._variantePanel.setVisible(presenter.hasVariantes());
    }

    void setBaliseAndPointTotal(int balises, int points) {
        this._baliseCountLabel.setText(L10n.getString("raid_panel.balises.label", String.format(INTEGER_FORMAT, balises), String.format(INTEGER_FORMAT, points)));
        this._baliseCountLabel.setOpaque(true);
        this._baliseCountLabel.setBorder((Border)new FlatLineBorder(new Insets(5, 10, 5, 10), LookAndFeelTheme.ACCENT_COLOR, 0.0f, 15));
        this._baliseCountLabel.setForeground(Color.WHITE);
        this._baliseCountLabel.setBackground(LookAndFeelTheme.ACCENT_COLOR);
    }

    private void _initializeUI() {
        this.setLayout(new BorderLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        panel1.add(this._createParcoursPanel());
        this._variantePanel = this._createVariantePanel();
        this._variantePanel.setVisible(false);
        panel1.add(this._variantePanel);
        panel1.add(this._createEtapePanel());
        this.add((Component)panel1, "North");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add(this._createEpreuvePanel());
        panel2.add(this._createBalisePanel());
        this.add((Component)panel2, "Center");
    }

    private JPanel _createParcoursPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("raid_panel.parcours.title"), 4, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 12, 0, 0);
        panel.add((Component)this._createParcoursComboBox(), c);
        c.gridx = 1;
        c.insets = new Insets(0, 10, 0, 0);
        panel.add((Component)this._createAddParcoursButton(), c);
        c.gridx = 2;
        c.insets = new Insets(0, 3, 0, 0);
        panel.add((Component)this._createEditParcoursButton(), c);
        c.gridx = 3;
        panel.add((Component)this._createRemoveParcoursButton(), c);
        c.gridx = 4;
        panel.add((Component)this._createDuplicateParcoursButton(), c);
        c.gridx = 5;
        panel.add((Component)this._createToggleVarianteInParcoursButton(), c);
        c.gridx = 6;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add(Box.createHorizontalGlue(), c);
        return panel;
    }

    private JPanel _createVariantePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("raid_panel.variante.title"), 4, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 12, 0, 0);
        panel.add(this._createVarianteComboBox(), c);
        c.gridx = 1;
        c.insets = new Insets(0, 10, 0, 0);
        panel.add((Component)this._createAddVarianteButton(), c);
        c.gridx = 2;
        c.insets = new Insets(0, 3, 0, 0);
        panel.add((Component)this._createAddMultipleVarianteButton(), c);
        c.gridx = 3;
        panel.add((Component)this._createEditVarianteButton(), c);
        c.gridx = 4;
        panel.add((Component)this._createDuplicateVarianteButton(), c);
        c.gridx = 5;
        panel.add((Component)this._createDeleteVarianteButton(), c);
        c.gridx = 6;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add(Box.createHorizontalGlue(), c);
        return panel;
    }

    private JButton _createAddVarianteButton() {
        this._addVarianteButton = new IconButton(ADD_IMAGE_NAME);
        this._addVarianteButton.setToolTipText(L10n.getString("raid_panel.variante.add.tooltip"));
        this._addVarianteButton.addActionListener(event -> this._presenter.addVariante());
        return this._addVarianteButton;
    }

    private JButton _createEditVarianteButton() {
        this._editVarianteButton = new IconButton(EDIT_IMAGE_NAME);
        this._editVarianteButton.setToolTipText(L10n.getString("raid_panel.variante.edit.tooltip"));
        this._editVarianteButton.addActionListener(event -> this._presenter.editVariante());
        return this._editVarianteButton;
    }

    private JButton _createDeleteVarianteButton() {
        this._removeVarianteButton = new IconButton(DELETE_IMAGE_NAME);
        this._removeVarianteButton.setToolTipText(L10n.getString("raid_panel.variante.remove.tooltip"));
        this._removeVarianteButton.addActionListener(event -> this._presenter.removeVariante());
        return this._removeVarianteButton;
    }

    private JButton _createAddMultipleVarianteButton() {
        this._addMultipleVariantesButton = new IconButton("add-multiple-24.png");
        this._addMultipleVariantesButton.setToolTipText(L10n.getString("raid_panel.variante.add_multiple.tooltip"));
        this._addMultipleVariantesButton.addActionListener(event -> this._presenter.addMultipleVariantes());
        return this._addMultipleVariantesButton;
    }

    private MyComboBox<ParcoursVariante> _createVarianteComboBox() {
        MyComboBox<ParcoursVariante> varianteComboBox = this._presenter.getVarianteComboBox();
        Dimension preferredSize = varianteComboBox.getPreferredSize();
        preferredSize.width = 300;
        varianteComboBox.setPreferredSize(preferredSize);
        varianteComboBox.addItemListener(event -> this._presenter.selectVariante());
        return varianteComboBox;
    }

    private JComponent _createParcoursComboBox() {
        JComboBox<Parcours> parcoursComboBox = this._presenter.getParcoursComboBox();
        Dimension preferredSize = parcoursComboBox.getPreferredSize();
        preferredSize.width = 300;
        parcoursComboBox.setPreferredSize(preferredSize);
        parcoursComboBox.addActionListener(event -> this._presenter.selectParcours());
        return parcoursComboBox;
    }

    private JButton _createAddParcoursButton() {
        IconButton button = new IconButton(ADD_IMAGE_NAME);
        button.setToolTipText(L10n.getString("raid_panel.parcours.add.tooltip"));
        button.addActionListener(event -> this._presenter.addParcours());
        return button;
    }

    private JButton _createEditParcoursButton() {
        this._editParcoursButton = new IconButton(EDIT_IMAGE_NAME);
        this._editParcoursButton.setToolTipText(L10n.getString("raid_panel.parcours.edit.tooltip"));
        this._editParcoursButton.addActionListener(event -> this._presenter.editParcours());
        return this._editParcoursButton;
    }

    private JButton _createRemoveParcoursButton() {
        this._removeParcoursButton = new IconButton(DELETE_IMAGE_NAME);
        this._removeParcoursButton.setToolTipText(L10n.getString("raid_panel.parcours.delete.tooltip"));
        this._removeParcoursButton.addActionListener(event -> this._presenter.deleteParcours());
        return this._removeParcoursButton;
    }

    private JButton _createDuplicateParcoursButton() {
        this._duplicateParcoursButton = new IconButton("copy-24.png");
        this._duplicateParcoursButton.setToolTipText(L10n.getString("raid_panel.parcours.duplicate.tooltip"));
        this._duplicateParcoursButton.addActionListener(event -> this._presenter.duplicateParcours());
        return this._duplicateParcoursButton;
    }

    private JButton _createToggleVarianteInParcoursButton() {
        this._toggleVarianteInParcoursButton = new IconButton("shuffle-24.png");
        this._toggleVarianteInParcoursButton.setToolTipText(L10n.getString("raid_panel.parcours.toggle_variante.tooltip"));
        this._toggleVarianteInParcoursButton.addActionListener(event -> this._presenter.toggleVarianteInParcours());
        return this._toggleVarianteInParcoursButton;
    }

    private JButton _createDuplicateVarianteButton() {
        this._duplicateVarianteButton = new IconButton("copy-24.png");
        this._duplicateVarianteButton.setToolTipText(L10n.getString("raid_panel.parcours.duplicate.tooltip"));
        this._duplicateVarianteButton.addActionListener(event -> this._presenter.duplicateVariante());
        return this._duplicateVarianteButton;
    }

    private JPanel _createEtapePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("raid_panel.etape.title"), 4, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 12, 0, 0);
        panel.add(this._createEtapeComboBox(), c);
        c.gridx = 1;
        c.insets = new Insets(0, 10, 0, 0);
        panel.add((Component)this._createAddEtapeButton(), c);
        c.gridx = 2;
        c.insets = new Insets(0, 3, 0, 0);
        panel.add((Component)this._createEditEtapeButton(), c);
        c.gridx = 3;
        panel.add((Component)this._createRemoveEtapeButton(), c);
        c.gridx = 4;
        c.weightx = 1.0;
        c.fill = 0;
        panel.add(Box.createHorizontalGlue(), c);
        return panel;
    }

    private JComboBox<Etape> _createEtapeComboBox() {
        JComboBox<Etape> etapeComboBox = this._presenter.getEtapeComboBox();
        Dimension preferredSize = etapeComboBox.getPreferredSize();
        preferredSize.width = 300;
        etapeComboBox.setPreferredSize(preferredSize);
        etapeComboBox.addActionListener(event -> this._presenter.selectEtape());
        return etapeComboBox;
    }

    private JButton _createAddEtapeButton() {
        this._addEtapeButton = new IconButton(ADD_IMAGE_NAME);
        this._addEtapeButton.setToolTipText(L10n.getString("raid_panel.etape.add.tooltip"));
        this._addEtapeButton.addActionListener(event -> this._presenter.addEtape());
        return this._addEtapeButton;
    }

    private JButton _createEditEtapeButton() {
        this._editEtapeButton = new IconButton(EDIT_IMAGE_NAME);
        this._editEtapeButton.setToolTipText(L10n.getString("raid_panel.etape.edit.tooltip"));
        this._editEtapeButton.addActionListener(event -> this._presenter.editEtape());
        return this._editEtapeButton;
    }

    private JButton _createRemoveEtapeButton() {
        this._removeEtapeButton = new IconButton(DELETE_IMAGE_NAME);
        this._removeEtapeButton.setToolTipText(L10n.getString("raid_panel.etape.delete.tooltip"));
        this._removeEtapeButton.addActionListener(event -> this._presenter.deleteEtape());
        return this._removeEtapeButton;
    }

    private JComponent _createEpreuvePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("raid_panel.epreuve.title"), 4, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.5;
        panel.add((Component)this._createEpreuveGoUpAndDownButtonsPanel(), c);
        c.fill = 3;
        c.gridx = 1;
        panel.add((Component)this._createEpreuveScrollPanel(), c);
        c.fill = 0;
        c.gridx = 2;
        c.anchor = 11;
        panel.add((Component)this._createEpreuveButtonPanel(), c);
        Component glueBox = Box.createHorizontalGlue();
        glueBox.setBackground(Color.PINK);
        c.fill = 2;
        c.gridx = 3;
        c.weightx = 1.0;
        panel.add(glueBox, c);
        return panel;
    }

    private JComponent _createEpreuveGoUpAndDownButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.PINK);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._createUpButton());
        panel.add(this._createDownButton());
        return panel;
    }

    private JButton _createUpButton() {
        this._moveUpEpreuveButton = new IconButton("up-24.png");
        this._moveUpEpreuveButton.setToolTipText(L10n.getString("raid_panel.epreuve.move_up.tooltip"));
        this._moveUpEpreuveButton.addActionListener(event -> this._presenter.moveUpEpreuve());
        return this._moveUpEpreuveButton;
    }

    private JButton _createDownButton() {
        this._moveDownEpreuveButton = new IconButton("down-24.png");
        this._moveDownEpreuveButton.setToolTipText(L10n.getString("raid_panel.epreuve.move_down.tooltip"));
        this._moveDownEpreuveButton.addActionListener(event -> this._presenter.moveDownEpreuve());
        return this._moveDownEpreuveButton;
    }

    private JScrollPane _createEpreuveScrollPanel() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setMinimumSize(new Dimension(300, 100));
        scrollPane.setPreferredSize(new Dimension(300, 100));
        scrollPane.setViewportView(this._createEpreuveList());
        return scrollPane;
    }

    private JList<Epreuve> _createEpreuveList() {
        JList<Epreuve> epreuveList = this._presenter.getEpreuveList();
        epreuveList.addListSelectionListener(event -> this._presenter.selectEpreuve());
        epreuveList.setVisibleRowCount(5);
        epreuveList.setSelectionMode(0);
        epreuveList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() > 1) {
                    RaidView.this._presenter.editEpreuve();
                }
            }
        });
        SwingUtils.addDeleteShortcut(epreuveList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RaidView.this._removeEpreuveButton.isEnabled()) {
                    RaidView.this._presenter.deleteEpreuve();
                }
            }
        });
        epreuveList.setCellRenderer(new EpreuveListCellRenderer());
        return epreuveList;
    }

    private JPanel _createEpreuveButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this._createAddEpreuveButton());
        panel.add(this._createEditEpreuveButton());
        panel.add(this._createRemoveEpreuveButton());
        panel.add(this._createImportEpreuveButton());
        panel.add(this._createExportEpreuveButton());
        return panel;
    }

    private JButton _createAddEpreuveButton() {
        this._addEpreuveButton = new IconButton(ADD_IMAGE_NAME);
        this._addEpreuveButton.setToolTipText(L10n.getString("raid_panel.epreuve.add.tooltip"));
        this._addEpreuveButton.addActionListener(event -> this._presenter.addEpreuve());
        return this._addEpreuveButton;
    }

    private JButton _createEditEpreuveButton() {
        this._editEpreuveButton = new IconButton(EDIT_IMAGE_NAME);
        this._editEpreuveButton.setToolTipText(L10n.getString("raid_panel.epreuve.edit.tooltip"));
        this._editEpreuveButton.addActionListener(event -> this._presenter.editEpreuve());
        return this._editEpreuveButton;
    }

    private JButton _createRemoveEpreuveButton() {
        this._removeEpreuveButton = new IconButton(DELETE_IMAGE_NAME);
        this._removeEpreuveButton.setToolTipText(L10n.getString("raid_panel.epreuve.delete.tooltip"));
        this._removeEpreuveButton.addActionListener(event -> this._presenter.deleteEpreuve());
        return this._removeEpreuveButton;
    }

    private JButton _createImportEpreuveButton() {
        this._importEpreuvesButton = new IconButton("import-csv-24.png");
        this._importEpreuvesButton.setToolTipText(L10n.getString("raid_panel.epreuve.import.tooltip"));
        this._importEpreuvesButton.addActionListener(event -> this._presenter.importEpreuve());
        return this._importEpreuvesButton;
    }

    private JButton _createExportEpreuveButton() {
        this._exportEpreuvesButton = new IconButton("export-csv-24.png");
        this._exportEpreuvesButton.setToolTipText(L10n.getString("raid_panel.epreuve.export.tooltip"));
        this._exportEpreuvesButton.addActionListener(event -> this._presenter.exportEpreuve());
        return this._exportEpreuvesButton;
    }

    private JPanel _createBalisePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("raid_panel.balise.title"), 4, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 10;
        c.gridy = 0;
        c.weighty = 0.5;
        panel.add((Component)this._createBaliseUpDownPanel(), c);
        c.gridx = 1;
        c.fill = 3;
        panel.add((Component)this._createBaliseScrollPane(), c);
        c.gridx = 2;
        c.fill = 0;
        c.insets = new Insets(0, 10, 0, 0);
        c.anchor = 18;
        c.weighty = 0.5;
        panel.add((Component)this._createBaliseButtonsPanel(), c);
        Component glueBox = Box.createHorizontalGlue();
        c.gridx = 3;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        panel.add(glueBox, c);
        return panel;
    }

    private JPanel _createBaliseButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this._baliseCountLabel = new JLabel();
        this.setBaliseAndPointTotal(0, 0);
        this._baliseCountLabel.setAlignmentX(0.0f);
        panel.add(this._baliseCountLabel);
        JPanel panel1 = new JPanel(new FlowLayout(0));
        panel1.add(this._createAddBaliseButton());
        panel1.add(this._createAddMultipleBalisesButton());
        panel1.add(this._createEditBaliseButton());
        panel1.add(this._createRemoveBaliseButton());
        panel1.add(this._createOcadBaliseButton());
        panel1.setAlignmentX(0.0f);
        panel.add(panel1);
        return panel;
    }

    private JPanel _createBaliseUpDownPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._createBaliseUpButton());
        panel.add(this._createBaliseDownButton());
        return panel;
    }

    private JButton _createBaliseUpButton() {
        this._moveUpBalise = new IconButton("up-24.png");
        this._moveUpBalise.setToolTipText(L10n.getString("raid_panel.balise.move_up.tooltip"));
        this._moveUpBalise.addActionListener(event -> this._presenter.moveUpBalise());
        return this._moveUpBalise;
    }

    private JButton _createBaliseDownButton() {
        this._moveDownBalise = new IconButton("down-24.png");
        this._moveDownBalise.setToolTipText(L10n.getString("raid_panel.balise.move_down.tooltip"));
        this._moveDownBalise.addActionListener(event -> this._presenter.moveDownBalise());
        return this._moveDownBalise;
    }

    private JButton _createOcadBaliseButton() {
        this._importIofXmlBalisesButton = new IconButton("iof-24.png");
        this._importIofXmlBalisesButton.setToolTipText(L10n.getString("raid_panel.balise.import_iof_parcours"));
        this._importIofXmlBalisesButton.addActionListener(event -> this._presenter.importBalisesFromIofXmlFile());
        return this._importIofXmlBalisesButton;
    }

    private JButton _createAddBaliseButton() {
        this._addBaliseButton = new IconButton(ADD_IMAGE_NAME);
        this._addBaliseButton.setToolTipText(L10n.getString("raid_panel.balise.add.tooltip"));
        this._addBaliseButton.addActionListener(event -> this._presenter.addBalise());
        return this._addBaliseButton;
    }

    private JButton _createEditBaliseButton() {
        this._editBaliseButton = new IconButton(EDIT_IMAGE_NAME);
        this._editBaliseButton.setToolTipText(L10n.getString("raid_panel.balise.edit.tooltip"));
        this._editBaliseButton.addActionListener(event -> this._presenter.editBalise());
        return this._editBaliseButton;
    }

    private JButton _createRemoveBaliseButton() {
        this._removeBaliseButton = new IconButton(DELETE_IMAGE_NAME);
        this._removeBaliseButton.setToolTipText(L10n.getString("raid_panel.balise.delete.tooltip"));
        this._removeBaliseButton.addActionListener(event -> this._presenter.deleteBalise());
        return this._removeBaliseButton;
    }

    private JComponent _createBaliseScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setMinimumSize(new Dimension(300, 100));
        scrollPane.setPreferredSize(new Dimension(300, 100));
        scrollPane.setViewportView(this._createBaliseList());
        return scrollPane;
    }

    private JList<Balise> _createBaliseList() {
        JList<Balise> baliseList = this._presenter.getBaliseList();
        baliseList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() > 1) {
                    RaidView.this._presenter.editBalise();
                }
            }
        });
        SwingUtils.addDeleteShortcut(baliseList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RaidView.this._presenter.deleteBalise();
            }
        });
        return baliseList;
    }

    private JButton _createAddMultipleBalisesButton() {
        this._addMultipleBalisesButton = new IconButton("add-multiple-24.png");
        this._addMultipleBalisesButton.setToolTipText(L10n.getString("raid_panel.balise.add_multiple.tooltip"));
        this._addMultipleBalisesButton.addActionListener(event -> this._presenter.addMultipleBalises());
        return this._addMultipleBalisesButton;
    }
}

