/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.raid_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.swing_ext.AbstractTextFieldListener;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

@ExcludeFromJacocoGeneratedReport
final class VarianteEditor
extends GDialog {
    private final transient DesktopPresenter _presenter;
    private final transient ParcoursVariante _variante;
    private final transient Consumer<ParcoursVariante> _updateCallback;
    private final boolean _isCreation;
    private JTextField _varianteNameTextField;
    private JLabel _errorLabel;
    private JButton _validationButton;

    VarianteEditor(JFrame parent, DesktopPresenter presenter, ParcoursVariante variante, Consumer<ParcoursVariante> updateCallback, boolean isCreation) {
        super(parent);
        this._presenter = presenter;
        this._updateCallback = updateCallback;
        this._isCreation = isCreation;
        this._variante = variante;
        this._initializeUI();
        this._varianteNameTextField.setText(this._variante.getName());
        this._validationButton.setEnabled(false);
    }

    private void _initializeUI() {
        this.setTitle(L10n.getString(this._isCreation ? "variante_editor.title1" : "variante_editor.title2"));
        this.setModal(true);
        this._createContent();
        this.pack();
    }

    private void _createContent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this._createTitleLabel(), "North");
        panel.add((Component)this._createContentPanel(), "Center");
        panel.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(panel);
    }

    private JPanel _createTitleLabel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(L10n.getString("variante_editor.name.label")));
        return panel;
    }

    private JPanel _createContentPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel panelTextField = new JPanel(new GridLayout(1, 1));
        this._varianteNameTextField = new JTextField();
        this._varianteNameTextField.getDocument().addDocumentListener(new AbstractTextFieldListener(){

            @Override
            public void perform() {
                VarianteEditor.this._validationButton.setEnabled(!VarianteEditor.this._varianteNameTextField.getText().trim().isEmpty());
            }
        });
        panelTextField.add((Component)this._varianteNameTextField, "Center");
        panel.add(panelTextField);
        JPanel panelError = new JPanel(new FlowLayout(0));
        this._errorLabel = new JLabel(" ");
        this._errorLabel.setForeground(Color.red);
        Dimension preferredSize = this._errorLabel.getPreferredSize();
        preferredSize.width = 300;
        this._errorLabel.setPreferredSize(preferredSize);
        panelError.add(this._errorLabel);
        panel.add(panelError);
        return panel;
    }

    private JComponent _createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 10, 5));
        buttonPanel.add(this._createValidateButton());
        buttonPanel.add(this._createCancelButton());
        return buttonPanel;
    }

    private JButton _createValidateButton() {
        this._validationButton = new JButton(L10n.getString(this._isCreation ? "variante_editor.button.validate1" : "variante_editor.button.validate2"));
        this._validationButton.addActionListener(event -> {
            if (this._varianteNameTextField.getText().trim().isEmpty()) {
                DesktopView.beep();
                this._errorLabel.setText(L10n.getString("variante_editor.error1"));
            } else {
                String varianteName = this._varianteNameTextField.getText().trim();
                if (this._presenter.getRaid().existsAnotherVarianteWithSameName(varianteName, this._variante)) {
                    DesktopView.beep();
                    this._errorLabel.setText(L10n.getString("variante_editor.error2"));
                } else {
                    this._variante.setName(varianteName);
                    this._updateCallback.accept(this._variante);
                    this.dispose();
                }
            }
        });
        this.setDefaultButton(this._validationButton);
        return this._validationButton;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

