/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.result_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.LookAndFeelTheme;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.result_panel.EpreuveTableModel;
import fr.geraidv3.desktop.result_panel.EtapeTableModel;
import fr.geraidv3.desktop.result_panel.ParcoursTableModel;
import fr.geraidv3.desktop.result_panel.ResultPresenter;
import fr.geraidv3.desktop.result_panel.VisualizationType;
import fr.geraidv3.desktop.sportident_panel.DocumentRenderer;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.desktop.swing_ext.StatefulComponent;
import fr.geraidv3.desktop.swing_ext.TableWithHeaderTooltips;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.EpreuveVisualizationLevel;
import fr.geraidv3.result.EtapeVisualizationLevel;
import fr.geraidv3.result.IVisualization;
import fr.geraidv3.result.ParcoursVisualizationLevel;
import fr.geraidv3.result.epreuve.EpreuveResult;
import fr.geraidv3.result.etape.EtapeResult;
import fr.geraidv3.result.parcours.ParcoursResult;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@ExcludeFromJacocoGeneratedReport
final class DetailedResultView
extends JPanel
implements StatefulComponent {
    private static final int SUB_PANEL_HEIGHT = 90;
    private final DesktopView _desktopView;
    private final transient ResultPresenter _presenter;
    private final JComboBox<Categorie> _categoriesComboBox;
    private final JComboBox<Etape> _etapesComboBox;
    private final JComboBox<Parcours> _parcoursComboBox;
    private final JList<Epreuve> _epreuvesList;
    private final JPopupMenu _popupMenu;
    private final JComboBox<IVisualization> _typeVisualisationComboBox;
    private final JLabel _courseStateLabel;
    private TableWithHeaderTooltips _resultTable;
    private JRadioButton _epreuveRadioButton;
    private JSpinner _podiumPlaceNumberSpinner;
    private JButton _exportHtmlButton;
    private JSpinner _autoExportSpinnerSeconds;
    private JRadioButton _etapeRadioButton;
    private JRadioButton _parcoursRadioButton;
    private JCheckBox _worstPucePerEquipeCheckBox;
    private JCheckBox _cumulativePenalitesCheckBox;
    private JCheckBox _publicationOnWebSiteCheckBox;
    private JButton _podiumButton;
    private JButton _printButton;
    private JButton _exportCsvButton;
    private JButton _automaticPublicationButton;
    private boolean _modified = false;

    DetailedResultView(DesktopView parent, JLabel courseStateLabel, ResultPresenter presenter, JComboBox<Parcours> parcoursComboBox, JList<Epreuve> epreuvesList, JComboBox<Etape> etapesComboBox, JComboBox<Categorie> categoriesComboBox) {
        super(new BorderLayout());
        this._desktopView = parent;
        this._courseStateLabel = courseStateLabel;
        this._presenter = presenter;
        this._parcoursComboBox = parcoursComboBox;
        this._epreuvesList = epreuvesList;
        this._etapesComboBox = etapesComboBox;
        this._categoriesComboBox = categoriesComboBox;
        this._popupMenu = this._createPopupMenu();
        this._typeVisualisationComboBox = new JComboBox();
        this._initializeUI();
    }

    @Override
    public void update(DesktopPresenter presenter) {
        boolean hasResult = this._epreuvesList.getSelectedIndex() > -1;
        this._exportHtmlButton.setEnabled(hasResult);
        this._podiumButton.setEnabled(hasResult);
        this._printButton.setEnabled(hasResult);
        this._exportCsvButton.setEnabled(hasResult);
        this._automaticPublicationButton.setEnabled(hasResult);
        this._updateEquipeInCourseStatusMessage((Etape)this._etapesComboBox.getSelectedItem());
    }

    int getPublishingFrequencyInS() {
        return (Integer)this._autoExportSpinnerSeconds.getValue();
    }

    void cleanTable() {
        this._resultTable.setModel(new EtapeTableModel(new EtapeResult(this._presenter.getRaid(), null, null, null, null, null, false, false)));
        this._modified = true;
    }

    void refreshResultTable() {
        if (this._parcoursComboBox.getSelectedIndex() >= 0) {
            if (this._isParcoursRadioButtonSelected()) {
                this._resultTable.setModel(new ParcoursTableModel(new ParcoursResult(this._presenter.getRaid(), (Parcours)this._parcoursComboBox.getSelectedItem(), (Categorie)this._categoriesComboBox.getSelectedItem(), (ParcoursVisualizationLevel)this._typeVisualisationComboBox.getSelectedItem(), this._isWorstPuceParEquipeCheckBoxSelected(), this.isCumulativePenalitesCheckBoxSelected())));
                this._updateEquipeInCourseStatusMessage((Etape)this._etapesComboBox.getSelectedItem());
            } else if (this._isRadiobuttonEtapeSelected()) {
                this._resultTable.setModel(new EtapeTableModel(new EtapeResult(this._presenter.getRaid(), (Etape)this._etapesComboBox.getSelectedItem(), (Parcours)this._desktopView.getParcoursComboBox().getSelectedItem(), this._desktopView.getSelectedVariante(), (Categorie)this._categoriesComboBox.getSelectedItem(), (EtapeVisualizationLevel)this._typeVisualisationComboBox.getSelectedItem(), this._isWorstPuceParEquipeCheckBoxSelected(), this.isCumulativePenalitesCheckBoxSelected())));
                this._updateEquipeInCourseStatusMessage((Etape)this._etapesComboBox.getSelectedItem());
            } else if (this._isRadiobuttonEpreuveSelected()) {
                this._resultTable.setModel(new EpreuveTableModel(new EpreuveResult(this._presenter.getRaid(), this._epreuvesList.getSelectedValue(), (Etape)this._etapesComboBox.getSelectedItem(), this._desktopView.getSelectedVariante(), (Categorie)this._categoriesComboBox.getSelectedItem(), (EpreuveVisualizationLevel)this._typeVisualisationComboBox.getSelectedItem(), this._isWorstPuceParEquipeCheckBoxSelected(), this.isCumulativePenalitesCheckBoxSelected())));
                this._updateEquipeInCourseStatusMessage((Etape)this._etapesComboBox.getSelectedItem());
            }
            this._updateTableColumnModel();
            this._modified = true;
        } else {
            this._resultTable.setModel(new DefaultTableModel());
        }
    }

    void fillCategoriesComboBox() {
        if (this._categoriesComboBox.getActionListeners().length > 0) {
            this._categoriesComboBox.removeActionListener(this._categoriesComboBox.getActionListeners()[0]);
            this._typeVisualisationComboBox.removeActionListener(this._typeVisualisationComboBox.getActionListeners()[0]);
        }
        this._categoriesComboBox.removeAllItems();
        this._typeVisualisationComboBox.removeAllItems();
        this._categoriesComboBox.addItem(new Categorie(L10n.getString("result_view.detailed_result.categorie.label1"), L10n.getString("result_view.detailed_result.categorie.label2")));
        Vector<Categorie> categorieVector = this._presenter.getRaid().getCategorieVector().getCategorieVector();
        for (Categorie categorie : categorieVector) {
            this._categoriesComboBox.addItem(categorie);
        }
        this._categoriesComboBox.setSelectedIndex(0);
        if (this._isRadiobuttonEtapeSelected()) {
            this._typeVisualisationComboBox.setModel(new DefaultComboBoxModel<EtapeVisualizationLevel>(EtapeVisualizationLevel.values()));
        } else if (this._isParcoursRadioButtonSelected()) {
            this._typeVisualisationComboBox.setModel(new DefaultComboBoxModel<ParcoursVisualizationLevel>(ParcoursVisualizationLevel.values()));
        } else {
            this._typeVisualisationComboBox.setModel(new DefaultComboBoxModel<EpreuveVisualizationLevel>(EpreuveVisualizationLevel.values()));
        }
        this._typeVisualisationComboBox.addActionListener(event -> this._desktopView.refreshResultTable());
        this._categoriesComboBox.addActionListener(event -> this._desktopView.refreshResultTable());
    }

    void setExportSuccess() {
        this._exportHtmlButton.setIcon(new ImageIcon(DesktopView.class.getClassLoader().getResource("fr/geraidv3/icon/success-24.png")));
    }

    void setExportFailure() {
        this._exportHtmlButton.setIcon(new ImageIcon(DesktopView.class.getClassLoader().getResource("fr/geraidv3/icon/error-24.png")));
    }

    void setExportNormal() {
        this._exportHtmlButton.setIcon(new ImageIcon(DesktopView.class.getClassLoader().getResource("fr/geraidv3/icon/html-24.png")));
    }

    boolean isModified() {
        return this._resultTable.getRowCount() != 0 && this._modified;
    }

    String exportResultIntoHtmlFile() {
        this._modified = false;
        if (this._parcoursComboBox.getSelectedItem() != null && this._categoriesComboBox.getSelectedItem() != null && this._etapesComboBox.getSelectedItem() != null) {
            return this._presenter.exportResultIntoHtmlFile(this._getVisualizationType(), ((Parcours)this._parcoursComboBox.getSelectedItem()).getName(), ((Categorie)this._categoriesComboBox.getSelectedItem()).getShortName(), ((Etape)this._etapesComboBox.getSelectedItem()).getName(), this._epreuvesList.getSelectedValue().getName(), this._resultTable, this._publicationOnWebSiteCheckBox.isSelected());
        }
        return null;
    }

    boolean isCumulativePenalitesCheckBoxSelected() {
        return this._cumulativePenalitesCheckBox.isSelected();
    }

    private boolean _isParcoursRadioButtonSelected() {
        return this._parcoursRadioButton.isSelected();
    }

    private boolean _isRadiobuttonEtapeSelected() {
        return this._etapeRadioButton.isSelected();
    }

    private boolean _isRadiobuttonEpreuveSelected() {
        return this._epreuveRadioButton.isSelected();
    }

    private boolean _isWorstPuceParEquipeCheckBoxSelected() {
        return this._worstPucePerEquipeCheckBox.isSelected();
    }

    private void _updateTableColumnModel() {
        int i;
        DefaultTableCellRenderer rightCellRender = new DefaultTableCellRenderer();
        rightCellRender.setHorizontalAlignment(0);
        TableColumnModel columnModel = this._resultTable.getColumnModel();
        for (i = 0; i < columnModel.getColumnCount(); ++i) {
            if (i == 3) continue;
            columnModel.getColumn(i).setCellRenderer(rightCellRender);
        }
        for (i = 0; i < this._resultTable.getColumnCount(); ++i) {
            TableColumn tableColumn = this._resultTable.getColumnModel().getColumn(i);
            int preferredWidth = tableColumn.getPreferredWidth();
            int maxWidth = tableColumn.getMaxWidth();
            for (int row = 0; row < this._resultTable.getRowCount(); ++row) {
                TableCellRenderer cellRenderer = this._resultTable.getCellRenderer(row, i);
                Component c = this._resultTable.prepareRenderer(cellRenderer, row, i);
                int width = c.getPreferredSize().width + this._resultTable.getIntercellSpacing().width;
                if ((preferredWidth = Math.max(preferredWidth, width)) < maxWidth) continue;
                preferredWidth = maxWidth;
                break;
            }
            tableColumn.setPreferredWidth((int)((double)preferredWidth * 1.2));
        }
    }

    private void setTextInCourseStateLabel(String text, Color color) {
        if (text == null) {
            text = " ";
        }
        this._courseStateLabel.setText(text);
        this._courseStateLabel.setBackground(color);
        this.getParent().repaint();
    }

    private void _updateEquipeInCourseStatusMessage(Etape etape) {
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        assert (parcours != null);
        if (etape == null || parcours.getEquipeVector().getSize() == 0) {
            this.setTextInCourseStateLabel(null, Color.WHITE);
        } else {
            int numberOfPendingEquipes = parcours.getEquipeVector().getNotArrivedEquipes(parcours, etape);
            if (numberOfPendingEquipes <= 0) {
                this.setTextInCourseStateLabel(L10n.getString("result_view.detailed_result.status.message1"), LookAndFeelTheme.SUCCESS_COLOR);
            } else if (numberOfPendingEquipes == 1) {
                this.setTextInCourseStateLabel(L10n.getString("result_view.detailed_result.status.message2"), LookAndFeelTheme.FAILURE_COLOR);
            } else {
                this.setTextInCourseStateLabel(L10n.getString("result_view.detailed_result.status.message3", numberOfPendingEquipes), LookAndFeelTheme.FAILURE_COLOR);
            }
        }
    }

    private JPopupMenu _createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(this.getReducedMenuItem());
        popupMenu.add(this.getCompleteMenuItem());
        popupMenu.add(this.getSPORTIdentResultMenuItem());
        return popupMenu;
    }

    private JMenuItem getReducedMenuItem() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("result_view.popup_menu_label1"));
        menuItem.addActionListener(event -> {
            this._popupMenu.setVisible(false);
            int row = this._resultTable.getSelectedRow();
            this._presenter.displayReduceResults((Parcours)this._parcoursComboBox.getSelectedItem(), (Etape)this._etapesComboBox.getSelectedItem(), (String)this._resultTable.getValueAt(row, 2));
        });
        return menuItem;
    }

    private JMenuItem getCompleteMenuItem() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("result_view.popup_menu_label2"));
        menuItem.setEnabled(true);
        menuItem.addActionListener(event -> {
            this._popupMenu.setVisible(false);
            int row = this._resultTable.getSelectedRow();
            this._presenter.displayCompleteResults((Parcours)this._parcoursComboBox.getSelectedItem(), (Etape)this._etapesComboBox.getSelectedItem(), (String)this._resultTable.getValueAt(row, 2));
        });
        return menuItem;
    }

    private JMenuItem getSPORTIdentResultMenuItem() {
        JMenuItem menuItem = new JMenuItem(L10n.getString("result_view.popup_menu_label3"));
        menuItem.addActionListener(event -> {
            this._popupMenu.setVisible(false);
            int row = this._resultTable.getSelectedRow();
            this._presenter.displaySPORTIdentResults((Parcours)this._parcoursComboBox.getSelectedItem(), (Etape)this._etapesComboBox.getSelectedItem(), this._resultTable.getValueAt(row, 2).toString());
        });
        return menuItem;
    }

    private void _initializeUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this._createDetailedResultsControlPanel(), "North");
        this.add((Component)this._createDetailedResultsDataPanel(), "Center");
    }

    private JPanel _createDetailedResultsControlPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this._createDetailedResultsControlSubPanel());
        return panel;
    }

    private JPanel _createDetailedResultsControlSubPanel() {
        FlowLayout layout = new FlowLayout(3);
        layout.setAlignOnBaseline(true);
        JPanel panel = new JPanel(layout);
        panel.add(this._createTypeToolbar());
        panel.add(this._createFilterToolbar());
        panel.add(this._createVisualizationToolbar());
        panel.add(this._createToolsToolbar());
        panel.add(this._createResultHtmlToolbar());
        panel.add(this._createPodiumHtmlToolbar());
        return panel;
    }

    private JComponent _createDetailedResultsDataPanel() {
        JTable table = this._createDetailedResultsTable();
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setHorizontalScrollBarPolicy(30);
        return scrollPane;
    }

    private JTable _createDetailedResultsTable() {
        this._resultTable = new TableWithHeaderTooltips();
        this._resultTable.setAutoResizeMode(4);
        this._resultTable.setSelectionMode(0);
        this._resultTable.setAutoscrolls(true);
        this._resultTable.getTableHeader().setReorderingAllowed(false);
        this._resultTable.getTableHeader().setBackground(Color.BLACK);
        this._resultTable.getTableHeader().setForeground(Color.WHITE);
        this._resultTable.setFocusable(true);
        Font font = this._resultTable.getTableHeader().getFont();
        this._resultTable.getTableHeader().setFont(font.deriveFont(12.0f));
        this._resultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                DetailedResultView.this._popupMenu.setVisible(false);
                DetailedResultView.this._resultTable.changeSelection(DetailedResultView.this._resultTable.rowAtPoint(event.getPoint()), 0, false, false);
                if (event.getButton() == 3) {
                    DetailedResultView.this._popupMenu.setLocation(event.getXOnScreen(), event.getYOnScreen());
                    DetailedResultView.this._popupMenu.setVisible(true);
                }
            }
        });
        this._resultTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                DetailedResultView.this._popupMenu.setVisible(false);
            }
        });
        return this._resultTable;
    }

    private JRadioButton _createEpreuveRadioButton() {
        this._epreuveRadioButton = new JRadioButton(L10n.getString("result_view.detailed_result.type.choice1"));
        this._epreuveRadioButton.addActionListener(event -> this._presenter.fillCategoriesComboBox());
        return this._epreuveRadioButton;
    }

    private JRadioButton _createEtapeRadioButton() {
        this._etapeRadioButton = new JRadioButton(L10n.getString("result_view.detailed_result.type.choice2"));
        this._etapeRadioButton.addActionListener(event -> this._presenter.fillCategoriesComboBox());
        return this._etapeRadioButton;
    }

    private JRadioButton _createParcoursButton() {
        this._parcoursRadioButton = new JRadioButton(L10n.getString("result_view.detailed_result.type.choice3"));
        this._parcoursRadioButton.addActionListener(event -> this._presenter.fillCategoriesComboBox());
        return this._parcoursRadioButton;
    }

    private JPanel _createTypeToolbar() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder(null, L10n.getString("result_view.detailed_result.type.title"), 4, 2));
        panel.add(this._createParcoursButton());
        panel.add(this._createEtapeRadioButton());
        panel.add(this._createEpreuveRadioButton());
        ButtonGroup group = new ButtonGroup();
        group.add(this._parcoursRadioButton);
        group.add(this._etapeRadioButton);
        group.add(this._epreuveRadioButton);
        this._parcoursRadioButton.setSelected(true);
        Dimension preferredSize = panel.getPreferredSize();
        preferredSize.height = 90;
        panel.setPreferredSize(preferredSize);
        return panel;
    }

    private JPanel _createFilterToolbar() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        panel.setBorder(new TitledBorder(null, L10n.getString("result_view.detailed_result.filter.title"), 4, 2));
        panel.add(new JLabel(L10n.getString("result_view.detailed_result.filter.label1")));
        panel.add(this._createCategorieComboBox());
        panel.add(new JLabel(L10n.getString("result_view.detailed_result.filter.label2")));
        panel.add(this._createVisualizationTypeComboBox());
        Dimension preferredSize = panel.getPreferredSize();
        preferredSize.height = 90;
        panel.setPreferredSize(preferredSize);
        return panel;
    }

    private JPanel _createVisualizationToolbar() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder(null, L10n.getString("result_view.detailed_result.visualization.title"), 4, 2));
        panel.add(this._createPuceParEquipeCheckbox());
        panel.add(this._createDisplayParticipantsNamesCheckbox());
        panel.add(this._createCumulativeTeammatePenalitesCheckbox());
        Dimension preferredSize = panel.getPreferredSize();
        preferredSize.height = 90;
        panel.setPreferredSize(preferredSize);
        return panel;
    }

    private JComboBox<Categorie> _createCategorieComboBox() {
        this._categoriesComboBox.setSelectedIndex(-1);
        Dimension preferredSize = this._categoriesComboBox.getPreferredSize();
        preferredSize.width = 150;
        this._categoriesComboBox.setPreferredSize(preferredSize);
        return this._categoriesComboBox;
    }

    private JComboBox<IVisualization> _createVisualizationTypeComboBox() {
        Dimension preferredSize = this._typeVisualisationComboBox.getPreferredSize();
        preferredSize.width = 150;
        this._typeVisualisationComboBox.setPreferredSize(preferredSize);
        return this._typeVisualisationComboBox;
    }

    private JPanel _createToolsToolbar() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("result_view.detailed_result.tools.title"), 4, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        panel.add((Component)this._createReloadButton(), c);
        c.gridx = 1;
        panel.add((Component)this._createPrintButton(), c);
        c.gridx = 2;
        panel.add((Component)this._createExportButton(), c);
        Dimension preferredSize = panel.getPreferredSize();
        preferredSize.height = 90;
        panel.setPreferredSize(preferredSize);
        return panel;
    }

    private JButton _createReloadButton() {
        IconButton button = new IconButton("reload-24.png");
        button.setToolTipText(L10n.getString("result_view.detailed_result.tools.button1"));
        button.addActionListener(event -> this._desktopView.refreshResultTable());
        return button;
    }

    private JButton _createPrintButton() {
        this._printButton = new IconButton("printer-24.png");
        this._printButton.setToolTipText(L10n.getString("result_view.detailed_result.tools.button2"));
        this._printButton.addActionListener(event -> {
            try {
                if (this._parcoursComboBox.getSelectedItem() != null && this._categoriesComboBox.getSelectedItem() != null && this._etapesComboBox.getSelectedItem() != null) {
                    this._presenter.printResults(this._resultTable, this._getVisualizationType(), (Parcours)this._parcoursComboBox.getSelectedItem(), (Categorie)this._categoriesComboBox.getSelectedItem(), (Etape)this._etapesComboBox.getSelectedItem(), this._epreuvesList.getSelectedValue());
                }
            }
            catch (PrinterException ex) {
                ErrorPane.showMessageDialog(this._desktopView.getRootPane(), L10n.getString("result_view.detailed_result.tools.print.error", ex.getMessage()));
            }
        });
        return this._printButton;
    }

    private JButton _createExportButton() {
        this._exportCsvButton = new IconButton("export-csv-24.png");
        this._exportCsvButton.setToolTipText(L10n.getString("result_view.detailed_result.tools.button3"));
        this._exportCsvButton.addActionListener(event -> {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(L10n.getString("csv_file.description"), "csv");
            chooser.setFileFilter(filter);
            chooser.setCurrentDirectory(new File(this._presenter.getRaidFolderPath()));
            int returnVal = chooser.showSaveDialog(this.getRootPane());
            if (returnVal == 0) {
                this._presenter.exportResultAsCSV(chooser.getSelectedFile().getAbsolutePath(), this._resultTable, this._getVisualizationType());
            }
        });
        return this._exportCsvButton;
    }

    private JPanel _createResultHtmlToolbar() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("result_view.detailed_result.result_export.title"), 4, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this._createButtonExportResultAsHTML(), c);
        c.gridx = 1;
        JSeparator separator1 = new JSeparator(1);
        separator1.setPreferredSize(new Dimension(5, 45));
        panel.add((Component)separator1, c);
        c.gridx = 2;
        panel.add((Component)this._createExportAutoSpinnerSec(), c);
        c.gridx = 3;
        panel.add((Component)new JLabel(L10n.getString("second_abbreviation")), c);
        c.gridx = 4;
        panel.add((Component)this._createExportAutoButton(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 5;
        panel.add((Component)this._createPublishCheckBox(), c);
        return panel;
    }

    private JPanel _createPodiumHtmlToolbar() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(null, L10n.getString("result_view.detailed_result.podium_export.title"), 4, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 2;
        c.gridy = 0;
        panel.add((Component)this._createPodiumButton(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.ipadx = 5;
        c.gridwidth = 1;
        panel.add((Component)this._createPodiumSpinner(), c);
        c.gridx = 1;
        c.insets = new Insets(0, 10, 0, 0);
        panel.add((Component)new JLabel(L10n.getString("result_view.detailed_result.podium_export.places")), c);
        Dimension preferredSize = panel.getPreferredSize();
        preferredSize.height = 90;
        panel.setPreferredSize(preferredSize);
        return panel;
    }

    private JCheckBox _createPublishCheckBox() {
        this._publicationOnWebSiteCheckBox = new JCheckBox(L10n.getString("result_view.detailed_result.publish.checkbox"));
        this._publicationOnWebSiteCheckBox.setToolTipText(L10n.getString("result_view.detailed_result.publish.tooltip"));
        this._publicationOnWebSiteCheckBox.addActionListener(event -> {
            if (this._publicationOnWebSiteCheckBox.isSelected() && !this._presenter.showConnectionViewIfNeeded()) {
                this._publicationOnWebSiteCheckBox.setSelected(false);
            }
        });
        return this._publicationOnWebSiteCheckBox;
    }

    private JSpinner _createExportAutoSpinnerSec() {
        this._autoExportSpinnerSeconds = new JSpinner();
        this._autoExportSpinnerSeconds.setModel(new SpinnerNumberModel(60, 10, 3600, 1));
        JFormattedTextField textField = ((JSpinner.DefaultEditor)this._autoExportSpinnerSeconds.getEditor()).getTextField();
        textField.setColumns(3);
        return this._autoExportSpinnerSeconds;
    }

    private JButton _createExportAutoButton() {
        this._automaticPublicationButton = new IconButton("play-24.png");
        this._automaticPublicationButton.addActionListener(event -> {
            if (!this._presenter.runOrStopAutomaticExportResultsAsHtml()) {
                this._automaticPublicationButton.setIcon(new ImageIcon(DesktopView.class.getClassLoader().getResource("fr/geraidv3/icon/play-24.png")));
                this._automaticPublicationButton.setToolTipText(L10n.getString("result_view.detailed_result.export.tooltip2"));
            } else {
                this._automaticPublicationButton.setIcon(new ImageIcon(DesktopView.class.getClassLoader().getResource("fr/geraidv3/icon/stop-24.png")));
                this._automaticPublicationButton.setToolTipText(L10n.getString("result_view.detailed_result.export.tooltip5"));
            }
        });
        this._automaticPublicationButton.setToolTipText(L10n.getString("result_view.detailed_result.export.tooltip4"));
        this._automaticPublicationButton.setSize(new Dimension(30, 30));
        return this._automaticPublicationButton;
    }

    private JCheckBox _createPuceParEquipeCheckbox() {
        this._worstPucePerEquipeCheckBox = new JCheckBox(L10n.getString("result_view.detailed_result.visualization.checkbox1"));
        this._worstPucePerEquipeCheckBox.setToolTipText(L10n.getString("result_view.detailed_result.visualization.tooltip1"));
        this._worstPucePerEquipeCheckBox.addActionListener(event -> this._desktopView.refreshResultTable());
        return this._worstPucePerEquipeCheckBox;
    }

    private JCheckBox _createDisplayParticipantsNamesCheckbox() {
        JCheckBox checkbox = new JCheckBox(L10n.getString("result_view.detailed_result.visualization.checkbox2"));
        checkbox.setToolTipText(L10n.getString("result_view.detailed_result.visualization.tooltip2"));
        checkbox.addActionListener(event -> this._presenter.setEnabledDisplayTeammate(checkbox.isSelected()));
        return checkbox;
    }

    private JCheckBox _createCumulativeTeammatePenalitesCheckbox() {
        this._cumulativePenalitesCheckBox = new JCheckBox(L10n.getString("result_view.detailed_result.visualization.checkbox3"));
        this._cumulativePenalitesCheckBox.setToolTipText(L10n.getString("result_view.detailed_result.visualization.tooltip3"));
        this._cumulativePenalitesCheckBox.addActionListener(event -> this._desktopView.refreshResultTable());
        return this._cumulativePenalitesCheckBox;
    }

    private JSpinner _createPodiumSpinner() {
        this._podiumPlaceNumberSpinner = new JSpinner();
        this._podiumPlaceNumberSpinner.setModel(new SpinnerNumberModel((Number)3, Integer.valueOf(1), null, (Number)1));
        return this._podiumPlaceNumberSpinner;
    }

    private JButton _createButtonExportResultAsHTML() {
        this._exportHtmlButton = new IconButton("html-24.png");
        this._exportHtmlButton.setToolTipText(L10n.getString("result_view.detailed_result.export.tooltip1"));
        this._exportHtmlButton.addActionListener(event -> {
            if (this._epreuvesList.getSelectedIndex() > -1) {
                String filePath = this.exportResultIntoHtmlFile();
                if (filePath != null) {
                    if (this._publicationOnWebSiteCheckBox.isSelected()) {
                        JTextArea message = new JTextArea();
                        message.setEditable(false);
                        File file = new File(filePath);
                        message.setText(L10n.getString("result_view.detailed_result.publish.success", file.getName()));
                        JOptionPane.showMessageDialog(this._desktopView.getRootPane(), message, L10n.getString("information"), 1);
                    } else {
                        JOptionPane.showMessageDialog(this._desktopView.getRootPane(), L10n.getString("result_view.detailed_result.export.success", filePath), L10n.getString("information"), 1);
                    }
                } else {
                    ErrorPane.showMessageDialog(this._desktopView.getRootPane(), L10n.getString("result_view.detailed_result.export.error"));
                }
            }
        });
        return this._exportHtmlButton;
    }

    private JButton _createPodiumButton() {
        this._podiumButton = new IconButton("podium-24.png");
        this._podiumButton.setToolTipText(L10n.getString("result_view.detailed_result.export.tooltip3"));
        this._podiumButton.addActionListener(event -> {
            if (this._parcoursComboBox.getSelectedItem() != null && this._categoriesComboBox.getSelectedItem() != null && this._etapesComboBox.getSelectedItem() != null) {
                String htmlText = this._presenter.exportPodiumAsHtml(this._getVisualizationType(), (Parcours)this._parcoursComboBox.getSelectedItem(), (Categorie)this._categoriesComboBox.getSelectedItem(), (Etape)this._etapesComboBox.getSelectedItem(), this._epreuvesList.getSelectedValue().getName(), this._resultTable, (Integer)this._podiumPlaceNumberSpinner.getValue());
                GDialog dialog = this._createHtmlDialog(this._desktopView, htmlText);
                dialog.setLocationRelativeTo(this._desktopView.getRootPane());
                dialog.setVisible(true);
            }
        });
        return this._podiumButton;
    }

    private GDialog _createHtmlDialog(DesktopView rootPane, String htmlText) {
        GDialog dialog = new GDialog(rootPane, L10n.getString("result_view.detailed_result.podium_export.title"), true);
        Container container = dialog.getContentPane();
        container.setLayout(new BorderLayout());
        JEditorPane editorPane = new JEditorPane("text/html", htmlText);
        editorPane.setEditable(false);
        editorPane.setOpaque(false);
        container.add((Component)new JScrollPane(editorPane), "Center");
        JPanel buttonContainer = new JPanel(new FlowLayout(1));
        JButton printButton = new JButton(L10n.getString("sportident_puce_result_dialog.print.button"));
        buttonContainer.add(printButton);
        printButton.addActionListener(event -> {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            DocumentRenderer documentRenderer = new DocumentRenderer(editorPane);
            documentRenderer.setScale(0.66);
            printerJob.setPrintable(documentRenderer, pageFormat);
            try {
                if (printerJob.printDialog()) {
                    printerJob.print();
                }
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        });
        JButton closeButton = new JButton(L10n.getString("close"));
        closeButton.addActionListener(event -> dialog.dispose());
        dialog.setCancelButton(closeButton);
        buttonContainer.add(closeButton);
        container.add((Component)buttonContainer, "South");
        dialog.setContentPane(container);
        dialog.pack();
        return dialog;
    }

    private VisualizationType _getVisualizationType() {
        if (this._etapeRadioButton.isSelected()) {
            return VisualizationType.ETAPE;
        }
        if (this._parcoursRadioButton.isSelected()) {
            return VisualizationType.PARCOURS;
        }
        return VisualizationType.EPREUVE;
    }
}

