/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.result_panel;

import com.formdev.flatlaf.ui.FlatLineBorder;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.result_panel.DetailedResultView;
import fr.geraidv3.desktop.result_panel.GlobalResultView;
import fr.geraidv3.desktop.result_panel.NotificationLabelLayerUI;
import fr.geraidv3.desktop.result_panel.ResultPresenter;
import fr.geraidv3.desktop.swing_ext.StatefulComponent;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;

@ExcludeFromJacocoGeneratedReport
public final class ResultView
extends JPanel
implements StatefulComponent {
    private final DesktopView _desktopView;
    private final transient ResultPresenter _presenter;
    private final JComboBox<Categorie> _categoriesComboBox;
    private final JComboBox<Etape> _etapesComboBox;
    private final JComboBox<Parcours> _parcoursComboBox;
    private final JList<Epreuve> _epreuvesList;
    private DetailedResultView _detailedResultView;

    public ResultView(DesktopView parent, DesktopPresenter desktopPresenter, JComboBox<Parcours> parcoursComboBox, JList<Epreuve> epreuvesList, JComboBox<Etape> etapesComboBox, JComboBox<Categorie> categoriesComboBox) {
        super(new BorderLayout());
        this._desktopView = parent;
        this._presenter = new ResultPresenter(desktopPresenter, this);
        this._parcoursComboBox = parcoursComboBox;
        this._epreuvesList = epreuvesList;
        this._etapesComboBox = etapesComboBox;
        this._categoriesComboBox = categoriesComboBox;
        this._initializeUI();
    }

    @Override
    public void update(DesktopPresenter presenter) {
        this._detailedResultView.update(presenter);
    }

    public void refreshResultTable() {
        this._detailedResultView.refreshResultTable();
    }

    public void cleanTable() {
        this._detailedResultView.cleanTable();
    }

    public void fillCategoryComboBox() {
        this._detailedResultView.fillCategoriesComboBox();
    }

    public int getPublishingFrequencyInS() {
        return this._detailedResultView.getPublishingFrequencyInS();
    }

    public boolean isCumulativePenalites() {
        return this._detailedResultView.isCumulativePenalitesCheckBoxSelected();
    }

    void setExportSuccess() {
        this._detailedResultView.setExportSuccess();
    }

    void setExportFailure() {
        this._detailedResultView.setExportFailure();
    }

    void setExportNormal() {
        this._detailedResultView.setExportNormal();
    }

    boolean exportResultIntoHtmlFile() {
        if (this._detailedResultView.isModified()) {
            return this._detailedResultView.exportResultIntoHtmlFile() != null;
        }
        return true;
    }

    private void _initializeUI() {
        JLabel courseStateLabel = ResultView._createCourseStateLabel();
        this._detailedResultView = new DetailedResultView(this._desktopView, courseStateLabel, this._presenter, this._parcoursComboBox, this._epreuvesList, this._etapesComboBox, this._categoriesComboBox);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.addTab(L10n.getString("result_view.tab1.title2"), this._detailedResultView);
        JPanel courseStatus = new JPanel(new BorderLayout());
        courseStatus.add(new JLayer<JComponent>(tabbedPane, new NotificationLabelLayerUI(courseStateLabel)), "Center");
        GlobalResultView globalResultView = new GlobalResultView(this._presenter);
        tabbedPane.addTab(L10n.getString("result_view.tab2.title1"), globalResultView);
        this.add(courseStatus);
    }

    private static JLabel _createCourseStateLabel() {
        ImageIcon icon = new ImageIcon(ResultView.class.getClassLoader().getResource("fr/geraidv3/icon/info-24.png"));
        JLabel courseStateLabel = new JLabel(" ", icon, 2);
        courseStateLabel.setBorder((Border)new FlatLineBorder(new Insets(5, 10, 5, 10), Color.WHITE, 0.0f, 15));
        courseStateLabel.setForeground(Color.WHITE);
        return courseStateLabel;
    }
}

