/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.setting_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.CategoryEditorDialog;
import fr.geraidv3.desktop.CategoryTableModel;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.raid_panel.BaliseEditor;
import fr.geraidv3.desktop.setting_menu.GlobalSettingsPresenter;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.categorie.CategorieVector;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.VisibleForTesting;

@ExcludeFromJacocoGeneratedReport
public final class GlobalSettingsDialog
extends GDialog {
    private final transient GlobalSettingsPresenter _presenter;
    private final transient Runnable _updateCallback;
    private final transient CategorieVector _categories = new CategorieVector();
    private JTextField _clubNameTextField;
    private JTextField _workingDirectoryTextField;
    private JTextField _backupDirectoryTextField;
    private JTable _categoryTable;
    private JButton _editCategoryButton;
    private JButton _removeButton;
    private JCheckBox _individualResultReducedPrintCheckbox;
    private JCheckBox _globalResultReducedPrintCheckbox;
    private JButton _okButton;
    private String _currentDirectory;
    private JCheckBox _tooltipsCheckbox;
    private JSlider _fontScaleSlider;

    public GlobalSettingsDialog(JFrame parent, DesktopPresenter presenter, Runnable updateCallback) {
        super(parent);
        this._presenter = new GlobalSettingsPresenter(presenter);
        this._updateCallback = updateCallback;
        this._initializeUI();
        this._initializeData();
    }

    @VisibleForTesting
    static boolean _isInDistributionDirectory(String currentDistributionDirectory, String dirname) {
        return dirname.startsWith(currentDistributionDirectory);
    }

    private void _initializeUI() {
        this.setTitle(L10n.getString("global_settings.title"));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout(0, 8));
        this.add((Component)this._createParametersPanel(), "North");
        this.add((Component)this._createCategoriePanel(), "Center");
        this.add((Component)this._createButtonPanel(), "South");
        this.pack();
    }

    private void _initializeData() {
        this._clubNameTextField.setText(this._presenter.getClubName());
        this._workingDirectoryTextField.setText(this._presenter.getWorkingDirectoryPath());
        this._backupDirectoryTextField.setText(this._presenter.getBackupDirectoryPath());
        this._individualResultReducedPrintCheckbox.setSelected(this._presenter.isShortIndividualResultPrinting());
        this._globalResultReducedPrintCheckbox.setSelected(this._presenter.isShortGlobalResultPrinting());
        this._fontScaleSlider.setValue(this._presenter.getFontScale());
        this._tooltipsCheckbox.setSelected(this._presenter.isTooltipsEnabled());
        CategorieVector categories = this._presenter.getCategoriesTemplateCopy();
        Vector<Categorie> categorieVector = categories.getCategorieVector();
        for (Categorie categorie : categorieVector) {
            this._categories.addCategorie(categorie);
        }
        this._categoryTable.setModel(new CategoryTableModel(this._categories));
    }

    private JPanel _createParametersPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        panel.add(this._createDirectoryPanel());
        panel.add(this._createFontScalePanel());
        panel.add(this._createTooltipPanel());
        panel.add(this._createPrintPanel());
        return panel;
    }

    private JPanel _createFontScalePanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        this._fontScaleSlider = new JSlider(0, 90, 120, 100);
        this._fontScaleSlider.setMinorTickSpacing(5);
        this._fontScaleSlider.setMajorTickSpacing(10);
        this._fontScaleSlider.setSnapToTicks(true);
        this._fontScaleSlider.setPaintTicks(true);
        this._fontScaleSlider.setPaintLabels(true);
        this._fontScaleSlider.setLabelTable(this._createStandardLabels());
        this._fontScaleSlider.addChangeListener(event -> this._enableValidateButtonIfSettingsCompleted());
        panel.add(this._fontScaleSlider);
        Dimension preferredSize = this._fontScaleSlider.getPreferredSize();
        this._fontScaleSlider.setPreferredSize(new Dimension(300, preferredSize.height));
        panel.setBorder(new TitledBorder(null, L10n.getString("global_settings.font_scale.title"), 4, 2));
        return panel;
    }

    private Hashtable<Integer, JComponent> _createStandardLabels() {
        Hashtable<Integer, JComponent> table = new Hashtable<Integer, JComponent>();
        for (int i = 90; i <= 120; i += 10) {
            table.put(i, new JLabel(i + " %"));
        }
        return table;
    }

    private JPanel _createTooltipPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        this._tooltipsCheckbox = new JCheckBox(L10n.getString("global_settings.tooltips.state"));
        this._tooltipsCheckbox.addActionListener(event -> this._enableValidateButtonIfSettingsCompleted());
        panel.add(this._tooltipsCheckbox);
        panel.setBorder(new TitledBorder(null, L10n.getString("global_settings.tooltips.title"), 4, 2));
        return panel;
    }

    private JPanel _createCategoriePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.setBorder(new TitledBorder(null, L10n.getString("global_settings.category.title"), 4, 2));
        panel1.add((Component)this._createCategoryButtonPanel(), "North");
        panel1.add((Component)this._createCategoryList(), "Center");
        panel.add((Component)panel1, "Center");
        return panel;
    }

    private JPanel _createDirectoryPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this._createClubNamePanel());
        panel.add(Box.createVerticalStrut(10));
        panel.add(this._createWorkingDirectoryPanel());
        panel.add(Box.createVerticalStrut(10));
        panel.add(this._createBackupDirectoryPanel());
        panel.add(Box.createVerticalStrut(10));
        panel.add(this._createBaliseSettingButton());
        panel.add(Box.createVerticalStrut(10));
        return panel;
    }

    private JPanel _createWorkingDirectoryPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)new JLabel(L10n.getString("global_settings.working_directory")), "West");
        this._workingDirectoryTextField = new JTextField();
        this._workingDirectoryTextField.setEditable(false);
        panel.add((Component)this._workingDirectoryTextField, "Center");
        panel.add((Component)this._createDirectoryBrowserButton(this._workingDirectoryTextField), "East");
        return panel;
    }

    private JPanel _createBackupDirectoryPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)new JLabel(L10n.getString("global_settings.backup_directory")), "West");
        this._backupDirectoryTextField = new JTextField();
        this._backupDirectoryTextField.setEditable(false);
        panel.add((Component)this._backupDirectoryTextField, "Center");
        panel.add((Component)this._createDirectoryBrowserButton(this._backupDirectoryTextField), "East");
        return panel;
    }

    private JPanel _createClubNamePanel() {
        JPanel panel1 = new JPanel(new BorderLayout(5, 0));
        panel1.add((Component)new JLabel(L10n.getString("global_settings.club_name")), "West");
        this._clubNameTextField = new JTextField(0);
        this._clubNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                GlobalSettingsDialog.this._enableValidateButtonIfSettingsCompleted();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                GlobalSettingsDialog.this._enableValidateButtonIfSettingsCompleted();
            }
        });
        panel1.add((Component)this._clubNameTextField, "Center");
        return panel1;
    }

    private void _enableValidateButtonIfSettingsCompleted() {
        boolean b = this._isValidDirectory(this._workingDirectoryTextField.getText()) && this._isValidDirectory(this._backupDirectoryTextField.getText());
        this._okButton.setEnabled(b);
    }

    private boolean _isValidDirectory(String dirname) {
        if (dirname == null || dirname.isEmpty()) {
            return false;
        }
        File file = new File(dirname);
        return file.exists() && file.canWrite();
    }

    private boolean _isInDistributionDirectory(String dirname) {
        String currentDistributionDirectory = System.getProperty("user.dir");
        return GlobalSettingsDialog._isInDistributionDirectory(currentDistributionDirectory, dirname);
    }

    private JButton _createDirectoryBrowserButton(JTextField directoryTextField) {
        JButton browseButton = new JButton(L10n.getString("browse"));
        browseButton.addActionListener(event -> {
            String initialDirectory = directoryTextField.getText();
            if (initialDirectory.isEmpty()) {
                initialDirectory = this._currentDirectory;
            }
            JFileChooser chooser = new JFileChooser(initialDirectory);
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                String absoluteDirectoryName = chooser.getSelectedFile().toString();
                if (this._isInDistributionDirectory(absoluteDirectoryName)) {
                    DesktopView.beep();
                    ErrorPane.showMessageDialog(this.rootPane, L10n.getString("global_settings.bad_directory"));
                } else if (this._isValidDirectory(absoluteDirectoryName)) {
                    this._currentDirectory = absoluteDirectoryName;
                    directoryTextField.setText(absoluteDirectoryName);
                    this._enableValidateButtonIfSettingsCompleted();
                } else {
                    DesktopView.beep();
                    ErrorPane.showMessageDialog(this.rootPane, L10n.getString("global_settings.directory.error"));
                }
            }
        });
        return browseButton;
    }

    private JPanel _createCategoryButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this._createAddButton());
        panel.add(this._createEditButton());
        panel.add(this._createRemoveButton());
        return panel;
    }

    private JScrollPane _createCategoryList() {
        this._categoryTable = new JTable(null);
        this._categoryTable.setSelectionMode(0);
        this._categoryTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                GlobalSettingsDialog.this._updateButtonState();
                if (event.getClickCount() > 1) {
                    GlobalSettingsDialog.this.openEditorInModifyMode();
                }
            }
        });
        this._categoryTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane scrollPane = new JScrollPane(null);
        scrollPane.setPreferredSize(new Dimension(500, 125));
        scrollPane.setViewportView(this._categoryTable);
        return scrollPane;
    }

    private JButton _createAddButton() {
        IconButton button = new IconButton("add-24.png");
        button.setToolTipText(L10n.getString("global_settings.category.add"));
        button.addActionListener(event -> {
            CategoryEditorDialog editor = new CategoryEditorDialog(this, new Categorie(), this._categories, c -> {
                this._categoryTable.setModel(new CategoryTableModel((CategorieVector)c));
                int lastRow = this._categoryTable.getRowCount() - 1;
                this._categoryTable.setRowSelectionInterval(lastRow, lastRow);
                this._updateButtonState();
                this._enableValidateButtonIfSettingsCompleted();
            }, true);
            editor.setLocationRelativeTo(this);
            editor.setVisible(true);
        });
        return button;
    }

    private JButton _createEditButton() {
        this._editCategoryButton = new IconButton("edit-24.png");
        this._editCategoryButton.setEnabled(false);
        this._editCategoryButton.setToolTipText(L10n.getString("global_settings.category.modify"));
        this._editCategoryButton.addActionListener(event -> this.openEditorInModifyMode());
        return this._editCategoryButton;
    }

    private void openEditorInModifyMode() {
        Categorie selectedCategory = this._categories.getCategorieFromShortName((String)this._categoryTable.getModel().getValueAt(this._categoryTable.getSelectedRow(), 1));
        CategoryEditorDialog editor = new CategoryEditorDialog(this, selectedCategory, this._categories, c -> {
            this._categoryTable.setModel(new CategoryTableModel((CategorieVector)c));
            this._enableValidateButtonIfSettingsCompleted();
        }, false);
        editor.setLocationRelativeTo(this);
        editor.setVisible(true);
    }

    private JButton _createRemoveButton() {
        this._removeButton = new IconButton("delete-24.png");
        this._removeButton.setEnabled(false);
        this._removeButton.setToolTipText(L10n.getString("global_settings.category.delete"));
        this._removeButton.addActionListener(event -> {
            if (this._categoryTable.getSelectedRow() >= 0) {
                String shortName = (String)this._categoryTable.getModel().getValueAt(this._categoryTable.getSelectedRow(), 1);
                this._categories.removeCategorieWithShortName(shortName);
                this._categoryTable.setModel(new CategoryTableModel(this._categories));
                this._updateButtonState();
                this._enableValidateButtonIfSettingsCompleted();
            }
        });
        return this._removeButton;
    }

    private void _updateButtonState() {
        if (this._categoryTable.getSelectedRowCount() > 0) {
            this._editCategoryButton.setEnabled(true);
            this._removeButton.setEnabled(true);
        } else {
            this._editCategoryButton.setEnabled(false);
            this._removeButton.setEnabled(false);
        }
    }

    private JComponent _createBaliseSettingButton() {
        JPanel panel = new JPanel(new FlowLayout(0));
        ImageIcon icon = new ImageIcon(this.getClass().getClassLoader().getResource("fr/geraidv3/icon/flag-24.png"));
        JButton button = new JButton(L10n.getString("global_settings.balises.button"), icon);
        button.setToolTipText(L10n.getString("global_settings.balises.tooltip"));
        button.addActionListener(event -> {
            Balise balise = new Balise(this._presenter.getGlobalSettings().getBaliseModel());
            BaliseEditor view = new BaliseEditor((JFrame)this.getParent(), balise, b -> {
                this._presenter.getGlobalSettings().setPunchPointsBonus(b.getPunchPointsBonus());
                this._presenter.getGlobalSettings().setPunchTimeBonusInS(b.getPunchTimeBonusInS());
                this._presenter.getGlobalSettings().setMispunchPointsPenalty(b.getMispunchPointsPenalty());
                this._presenter.getGlobalSettings().setMispunchTimePenaltyInS(b.getMispunchTimePenaltyInS());
                this._enableValidateButtonIfSettingsCompleted();
            }, true, true);
            view.setLocationRelativeTo(this);
            view.setVisible(true);
        });
        panel.add(button);
        return panel;
    }

    private JPanel _createPrintPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder(null, L10n.getString("global_settings.print.title"), 4, 2));
        JPanel panel1 = new JPanel(new FlowLayout(0));
        panel1.add(this._createIndividualResultReducedPrintCheckbox());
        panel.add(panel1);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this._createGlobalResultReducedPrintCheckbox());
        panel.add(panel2);
        return panel;
    }

    private JCheckBox _createIndividualResultReducedPrintCheckbox() {
        this._individualResultReducedPrintCheckbox = new JCheckBox(L10n.getString("global_settings.print.individual"));
        this._individualResultReducedPrintCheckbox.addActionListener(event -> this._enableValidateButtonIfSettingsCompleted());
        return this._individualResultReducedPrintCheckbox;
    }

    private JCheckBox _createGlobalResultReducedPrintCheckbox() {
        this._globalResultReducedPrintCheckbox = new JCheckBox(L10n.getString("global_settings.print.global"));
        this._globalResultReducedPrintCheckbox.addActionListener(event -> this._enableValidateButtonIfSettingsCompleted());
        return this._globalResultReducedPrintCheckbox;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 10));
        panel.add(this._createValidateButton());
        panel.add(this._createCancelButton());
        return panel;
    }

    private JButton _createValidateButton() {
        this._okButton = new JButton(L10n.getString("validate"));
        this._okButton.setEnabled(false);
        this._okButton.addActionListener(event -> {
            this._presenter.setClubName(this._clubNameTextField.getText().trim());
            this._presenter.setWorkingDirectoryPath(this._workingDirectoryTextField.getText().trim());
            this._presenter.setBackupDirectoryPath(this._backupDirectoryTextField.getText().trim());
            this._presenter.setShortIndividualResultPrinting(this._individualResultReducedPrintCheckbox.isSelected());
            this._presenter.setShortGlobalResultPrinting(this._globalResultReducedPrintCheckbox.isSelected());
            this._presenter.setCategoriesTemplate(this._categories);
            this._presenter.setTooltipsEnabled(this._tooltipsCheckbox.isSelected());
            this._presenter.setFontScale(this._fontScaleSlider.getValue());
            this._presenter.saveGlobalSettings();
            this._updateCallback.run();
            this.dispose();
        });
        this.setDefaultButton(this._okButton);
        return this._okButton;
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("cancel"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

