/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.setting_menu;

import fr.geraidv3.desktop.setting_menu.GlobalSettingsFile;
import fr.geraidv3.model.GlobalSettings;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.VisibleForTesting;

public final class PlatformSettingsHandler {
    private static final String GLOBAL_SETTINGS_DIRNAME = "geraidv3";

    public static void loadGlobalSettings(GlobalSettings globalSettings) {
        String directoryName = PlatformSettingsHandler.getGlobalSettingsDirectory();
        GlobalSettingsFile.load(globalSettings, directoryName);
    }

    public static void saveGlobalSettings(GlobalSettings globalSettings) {
        GlobalSettingsFile.save(globalSettings, PlatformSettingsHandler.getGlobalSettingsDirectory());
    }

    public static void createGlobalSettingsDirectoryIfNeeded() throws IOException {
        String directoryName = PlatformSettingsHandler.getGlobalSettingsDirectory();
        PlatformSettingsHandler._createGlobalSettingsDirectoryIfNeeded(directoryName);
    }

    public static boolean isExistNotEmptyGlobalSettingsDirectory() {
        String directoryName = PlatformSettingsHandler.getGlobalSettingsDirectory();
        File directory = new File(directoryName);
        if (directory.exists() && directory.isDirectory()) {
            String[] files = directory.list();
            return files != null && files.length > 0;
        }
        return false;
    }

    public static boolean platformIsMacOs() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public static boolean platformIsWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean platformIsLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static String getGlobalSettingsDirectory() {
        String homeDirectory = System.getProperty("user.home");
        File directory = PlatformSettingsHandler.platformIsMacOs() ? new File(homeDirectory + "/Library/Application Support/geraidv3") : (PlatformSettingsHandler.platformIsWindows() ? new File(System.getenv("APPDATA") + File.separator + GLOBAL_SETTINGS_DIRNAME) : (PlatformSettingsHandler.platformIsLinux() ? new File(homeDirectory + "/.geraidv3") : new File(homeDirectory + "/.geraidv3")));
        return directory.getAbsolutePath();
    }

    @VisibleForTesting
    public static void _createGlobalSettingsDirectoryIfNeeded(String directoryName) throws IOException {
        File directory = new File(directoryName);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException();
        }
    }
}

