/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.setting_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.model.GlobalSettings;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.io.IOException;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;

@ExcludeFromJacocoGeneratedReport
public final class PublicationClient {
    private PublicationClient() {
    }

    public static void publish(GlobalSettings.PublicationSettings settings, String filename, String sourceAbsoluteFilename) throws IOException {
        SSHClient client = PublicationClient._setupClient(settings);
        Object destinationFolder = settings.getDestinationFolder();
        if (!((String)destinationFolder).endsWith("/")) {
            destinationFolder = (String)destinationFolder + "/";
        }
        PublicationClient._upload(client, sourceAbsoluteFilename, (String)destinationFolder + filename);
        PublicationClient._disconnect(client);
    }

    public static boolean checkConnection(GlobalSettings.PublicationSettings settings) {
        try {
            SSHClient client = PublicationClient._setupClient(settings);
            PublicationClient._disconnect(client);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static SSHClient _setupClient(GlobalSettings.PublicationSettings settings) throws IOException {
        SSHClient client = new SSHClient();
        client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        client.setConnectTimeout(5000);
        PublicationClient._connectClient(client, settings.getHost());
        PublicationClient._authenticateClient(client, settings.getUsername(), settings.getPassword());
        return client;
    }

    private static void _connectClient(SSHClient client, String host) throws IOException {
        try {
            client.connect(host);
        }
        catch (IOException e) {
            throw new IOException(L10n.getString("connection_view.info.error_connect"));
        }
    }

    private static void _authenticateClient(SSHClient client, String username, String password) throws IOException {
        try {
            client.authPassword(username, password);
        }
        catch (UserAuthException e) {
            throw new IOException(L10n.getString("connection_view.info.error_authorization"));
        }
        catch (TransportException e) {
            throw new IOException(L10n.getString("connection_view.info.error_transport"));
        }
    }

    private static void _upload(SSHClient client, String sourceLocalAbsoluteFilename, String destinationFilename) throws IOException {
        try (SFTPClient sftpClient = client.newSFTPClient();){
            sftpClient.put(sourceLocalAbsoluteFilename, destinationFilename);
        }
        catch (IOException e) {
            throw new IOException(L10n.getString("connection_view.info.error_upload", e.getMessage()));
        }
    }

    private static void _disconnect(SSHClient client) throws IOException {
        try {
            client.disconnect();
        }
        catch (IOException ignored) {
            throw new IOException(L10n.getString("connection_view.info.error_disconnect"));
        }
    }
}

