/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.setting_menu;

import fr.geraidv3.desktop.setting_menu.PlatformSettingsHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import org.jetbrains.annotations.VisibleForTesting;

public final class RecentProjectsFileHandler {
    @VisibleForTesting
    static final int RECENT_FILES_SIZE = 10;
    private static final String RECENT_PROJECTS_FILENAME = "recent_projects";

    private RecentProjectsFileHandler() {
    }

    public static String[] getRecentFilePaths() {
        return RecentProjectsFileHandler._getRecentFilePaths(RecentProjectsFileHandler._getAbsoluteRecentProjectsFilename());
    }

    public static String[][] getFileNamesAndDateFromRecentProjectsFile() {
        String absoluteRecentProjectsFilename = RecentProjectsFileHandler._getAbsoluteRecentProjectsFilename();
        return new String[][]{RecentProjectsFileHandler.getFileNamesFromFilePath(RecentProjectsFileHandler.getRecentFilePaths()), RecentProjectsFileHandler._getDates(absoluteRecentProjectsFilename)};
    }

    public static void addVisitedFileToRecentFiles(String filename) {
        RecentProjectsFileHandler._addVisitedFileToRecentFiles(filename, RecentProjectsFileHandler._getAbsoluteRecentProjectsFilename());
    }

    public static void removeFromRecentFiles(String filename) {
        RecentProjectsFileHandler._removeFromRecentFiles(filename, RecentProjectsFileHandler._getAbsoluteRecentProjectsFilename());
    }

    public static void updateRecentFiles() {
        RecentProjectsFileHandler._updateRecentFiles(RecentProjectsFileHandler._getAbsoluteRecentProjectsFilename());
    }

    static String[] getFileNamesFromFilePath(String[] filePaths) {
        String[] filenames = new String[filePaths.length];
        for (int i = 0; i < filePaths.length; ++i) {
            String filename;
            File file = new File(filePaths[i]);
            filenames[i] = filename = RecentProjectsFileHandler._removeExtension(file.getName());
        }
        return filenames;
    }

    @VisibleForTesting
    static void _createRecentProjectFileIfNeeded(String absoluteRecentProjectsFilename) throws IOException {
        File file = new File(absoluteRecentProjectsFilename);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException();
        }
    }

    @VisibleForTesting
    static String[] _getRecentFilePaths(String absoluteRecentProjectsFilename) {
        ArrayList<String> files = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(absoluteRecentProjectsFilename));){
            String fileAndDate;
            while ((fileAndDate = reader.readLine()) != null) {
                if (fileAndDate.isEmpty()) continue;
                files.add(fileAndDate.split(";")[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return files.toArray(new String[0]);
    }

    @VisibleForTesting
    static String _removeExtension(String filename) {
        int index = filename.lastIndexOf(46);
        return filename.substring(0, index);
    }

    @VisibleForTesting
    static void _addVisitedFileToRecentFiles(String filename, String recentProjectsFilename) {
        try {
            if (RecentProjectsFileHandler._isNotExistRecentProjectsFile(recentProjectsFilename)) {
                RecentProjectsFileHandler._createRecentProjectFileIfNeeded(recentProjectsFilename);
            }
            ArrayList<String> files = new ArrayList<String>();
            ArrayList<String> dates = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new FileReader(recentProjectsFilename));){
                String fileAndDate;
                while ((fileAndDate = reader.readLine()) != null) {
                    if (fileAndDate.isEmpty()) continue;
                    files.add(fileAndDate.split(";")[0]);
                    dates.add(fileAndDate.split(";")[1]);
                }
            }
            if (files.size() > 9) {
                files.remove(9);
            }
            if (!files.contains(filename)) {
                RecentProjectsFileHandler._addVisitedFileToRecentProjectFiles(recentProjectsFilename, filename, files, dates);
            } else {
                RecentProjectsFileHandler._changeDateOfVisitedFile(recentProjectsFilename, filename, files, dates);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    static void _removeFromRecentFiles(String filename, String absoluteRecentProjectsFilename) {
        try {
            if (RecentProjectsFileHandler._isNotExistRecentProjectsFile(absoluteRecentProjectsFilename)) {
                RecentProjectsFileHandler._createRecentProjectFileIfNeeded(absoluteRecentProjectsFilename);
            }
            ArrayList<String> files = new ArrayList<String>();
            ArrayList<String> dates = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new FileReader(absoluteRecentProjectsFilename));){
                String fileAndDate;
                while ((fileAndDate = reader.readLine()) != null) {
                    if (fileAndDate.isEmpty()) continue;
                    files.add(fileAndDate.split(";")[0]);
                    dates.add(fileAndDate.split(";")[1]);
                }
            }
            for (int i = 0; i < files.size(); ++i) {
                if (!filename.equals(files.get(i))) continue;
                files.remove(i);
                dates.remove(i);
                break;
            }
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(absoluteRecentProjectsFilename, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
                for (int i = 0; i < files.size(); ++i) {
                    writer.write((String)files.get(i) + ";" + (String)dates.get(i) + "\n");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    static String[] _getDates(String absoluteRecentProjectsFilename) {
        ArrayList<String> dates = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(absoluteRecentProjectsFilename));){
            String fileAndDate;
            while ((fileAndDate = reader.readLine()) != null) {
                if (fileAndDate.isEmpty()) continue;
                String timestampString = fileAndDate.split(";")[1];
                long timestampInMs = Long.parseLong(timestampString) * 1000L;
                LocalDate localDate = Instant.ofEpochMilli(timestampInMs).atZone(ZoneId.systemDefault()).toLocalDate();
                DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
                String frFormattedDate = localDate.format(dateFormatter);
                dates.add(frFormattedDate);
            }
        }
        catch (IOException | NumberFormatException exception) {
            // empty catch block
        }
        return dates.toArray(new String[0]);
    }

    private static boolean _isNotExistRecentProjectsFile(String absoluteRecentProjectsFilename) {
        File file = new File(absoluteRecentProjectsFilename);
        return !file.exists();
    }

    private static void _addVisitedFileToRecentProjectFiles(String absoluteRecentProjectsFilename, String filename, ArrayList<String> files, ArrayList<String> dates) throws IOException {
        files.add(0, filename);
        dates.add(0, "" + Instant.now().getEpochSecond());
        Path path = Paths.get(absoluteRecentProjectsFilename, new String[0]);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
            for (int i = 0; i < files.size(); ++i) {
                writer.write(files.get(i) + ";" + dates.get(i) + "\n");
            }
        }
    }

    private static void _changeDateOfVisitedFile(String absoluteRecentProjectsFilename, String filename, ArrayList<String> files, ArrayList<String> dates) throws IOException {
        Path path = Paths.get(absoluteRecentProjectsFilename, new String[0]);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
            writer.write(filename + ";" + Instant.now().getEpochSecond() + "\n");
            for (int i = 0; i < files.size(); ++i) {
                if (files.get(i).equals(filename)) continue;
                writer.write(files.get(i) + ";" + dates.get(i) + "\n");
            }
        }
    }

    private static void _updateRecentFiles(String absoluteRecentProjectsFilename) {
        try (BufferedReader reader = new BufferedReader(new FileReader(absoluteRecentProjectsFilename));){
            String fileAndDate;
            while ((fileAndDate = reader.readLine()) != null) {
                String fileName;
                File file;
                if (fileAndDate.isEmpty() || (file = new File(fileName = fileAndDate.split(";")[0])).exists()) continue;
                RecentProjectsFileHandler.removeFromRecentFiles(fileName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String _getAbsoluteRecentProjectsFilename() {
        String directory = PlatformSettingsHandler.getGlobalSettingsDirectory();
        return directory + File.separator + RECENT_PROJECTS_FILENAME;
    }
}

