/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.simulation;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Random;
import org.jetbrains.annotations.VisibleForTesting;

final class RandomGenerator {
    private final HashSet<Integer> _generatedIntegers = new HashSet();
    private final HashSet<Integer> _generatedPuceId = new HashSet();
    private final Random _random;

    RandomGenerator(int seed) {
        this._random = new Random(seed);
    }

    RandomGenerator() {
        this._random = new Random();
    }

    void reset() {
        this._generatedIntegers.clear();
        this._generatedPuceId.clear();
    }

    int nextNumberLowerThan(int bound) {
        return this._random.nextInt(bound);
    }

    String nextUniquePuce(int numberOfPuce, boolean isMultiplePucePerTeam) {
        DecimalFormat formatter = new DecimalFormat("0000000");
        StringBuilder builder = new StringBuilder();
        if (!isMultiplePucePerTeam && numberOfPuce > 1) {
            numberOfPuce = 1;
        }
        int size = (int)Math.pow(10.0, 7.0);
        block0: for (int i = 0; i < numberOfPuce; ++i) {
            int randInt = this._nextUniqueNumber(7);
            for (int j = 0; j < 10; ++j) {
                int code = (randInt + j) % size;
                if (this._generatedPuceId.contains(code)) continue;
                this._generatedPuceId.add(code);
                String puce = formatter.format(code);
                builder.append(puce).append(",");
                continue block0;
            }
        }
        int indexToDelete = builder.lastIndexOf(",");
        builder.delete(indexToDelete, indexToDelete + 1);
        return builder.toString();
    }

    @VisibleForTesting
    int _nextUniqueNumber(int exponent) throws ArrayIndexOutOfBoundsException {
        int size = (int)Math.pow(10.0, exponent);
        int randInt = this._random.nextInt(size);
        for (int i = 0; i < size; ++i) {
            int number = (randInt + i) % size;
            if (this._generatedIntegers.contains(number)) continue;
            this._generatedIntegers.add(number);
            return number;
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

