/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.simulation;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.simulation.RandomGenerator;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.StartType;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.equipe.Equipier;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.result.EtapeVisualizationLevel;
import fr.geraidv3.result.ParcoursVisualizationLevel;
import fr.geraidv3.result.data.EtapePuceResult;
import fr.geraidv3.result.etape.EtapeResult;
import fr.geraidv3.result.parcours.ParcoursResult;
import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.result.puce.Puce;
import fr.geraidv3.result.puce.PuceResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.jetbrains.annotations.VisibleForTesting;

final class ResultData {
    private static int _dossardNumberCounter;
    private final Raid _raid;
    private final RandomGenerator _randomGenerator;

    ResultData(Raid raid) {
        ResultData._resetDossardNumberCounter();
        this._randomGenerator = new RandomGenerator();
        this._raid = Raid.copyWithoutEquipes(raid);
    }

    @VisibleForTesting
    ResultData(Raid raid, int seed) {
        ResultData._resetDossardNumberCounter();
        this._randomGenerator = new RandomGenerator(seed);
        this._raid = raid;
    }

    List<Categorie> getCategorieVector() {
        return this._raid.getCategorieVector().getCategorieVector();
    }

    Vector<Parcours> getParcoursVector() {
        return this._raid.getParcoursVector().getParcoursVector();
    }

    ParcoursResult createParcours(Parcours parcours, Categorie categorie) {
        return new ParcoursResult(this._raid, parcours, categorie, ParcoursVisualizationLevel.SIMPLE, false, false);
    }

    EtapeResult createEtapeResult(Etape etape, Categorie categorie) {
        return new EtapeResult(this._raid, etape, null, null, categorie, EtapeVisualizationLevel.SIMPLE, false, false);
    }

    boolean existsPuceResult(Equipe equipe) {
        return this._raid.existsPuceResult(equipe);
    }

    void clearData(Parcours parcours) {
        this._randomGenerator.reset();
        ResultData._resetDossardNumberCounter();
        for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
            EquipeVector equipeVector = variante.getEquipeVector();
            while (equipeVector.getSize() > 0) {
                this._raid.removeEquipe(equipeVector, equipeVector.getEquipeVector().get(0));
            }
        }
    }

    PuceResult getPuceResult(Etape etape, Equipe equipe) {
        if (this._raid.existsPuceResult(equipe)) {
            return this._raid.getPuceResultVector().getPuceResult(etape, equipe);
        }
        return null;
    }

    void removeEquipe(EquipeVector equipes, Equipe equipe) {
        this._raid.removeEquipe(equipes, equipe);
    }

    String getPuceResultAsHtml(Etape etape, Equipe equipe) {
        PuceResult puceResult = this._raid.getPuceResultVector().getPuceResult(etape, equipe);
        if (puceResult != null) {
            EtapePuceResult etapePuceResult = new EtapePuceResult(puceResult, 0, 0, false);
            return etapePuceResult.toHtml(this._raid, false);
        }
        return null;
    }

    void generateResultsToEquipes(Parcours parcours, int totalOfEquipesToGenerate, int totalRandomPmToGenerate, Set<Integer> codesToBeSetAsPm, Date startTime, Date timeGapBetweenBalises) {
        for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
            for (int i = 0; i < totalOfEquipesToGenerate; ++i) {
                Equipe equipe = this._createRandomEquipe(this._raid);
                variante.getEquipeVector().addEquipeIfNotExistWithSamePuceAndBib(equipe);
                this._generateRandomPuceResultsForEquipe(parcours, equipe, totalRandomPmToGenerate, codesToBeSetAsPm, startTime, timeGapBetweenBalises);
            }
        }
    }

    @VisibleForTesting
    void _generateRandomPuceResultsFromEquipeInEtape(Parcours parcours, Equipe equipe, Etape etape, int totalRandomPmToGenerate, Set<Integer> codesToBeSetAsPm, Date startTime, Date timeGapBetweenBalises) {
        PuceResult puceResult = new PuceResult();
        puceResult.setParcours(parcours);
        puceResult.setEtape(etape);
        puceResult.setEquipe(equipe);
        Puce puce = puceResult.getPuce();
        puce.setId(equipe.getPuceIds().get(0));
        puce.setStartTime(startTime);
        ParcoursVariante variante = parcours.getVarianteFromEquipe(equipe);
        EpreuveVector epreuves = variante.getEpreuvesOfEtape(etape);
        EpreuveVector timedEpreuves = new EpreuveVector();
        EpreuveVector untimedEpreuves = new EpreuveVector();
        ResultData._separateTimedAndUntimedEpreuves(epreuves, untimedEpreuves, timedEpreuves);
        Date time = ResultData._calculateStartTime(startTime, etape, puce);
        ArrayList<Partiel> punches = new ArrayList<Partiel>();
        time = ResultData._generateResultsForEpreuves(codesToBeSetAsPm, timeGapBetweenBalises, timedEpreuves.getEpreuveVector(), time, punches);
        Date finishTime = this._calculateFinishTime(timeGapBetweenBalises, time);
        puce.setFinishTime(finishTime);
        time = finishTime;
        ResultData._generateResultsForEpreuves(codesToBeSetAsPm, timeGapBetweenBalises, untimedEpreuves.getEpreuveVector(), time, punches);
        this._generateRandomPm(totalRandomPmToGenerate, punches);
        puce.setPartiels(punches);
        this._raid.addPuceResult(puceResult);
    }

    @VisibleForTesting
    static Date _generateResultsForEpreuves(Set<Integer> codesToBeSetAsPm, Date timeGapBetweenBalises, Vector<Epreuve> epreuves, Date time, List<Partiel> punches) {
        for (Epreuve epreuve : epreuves) {
            Vector<Balise> baliseVector = epreuve.getBaliseVector().getBaliseVector();
            for (Balise balise : baliseVector) {
                time = ResultData._createFakeResult(codesToBeSetAsPm, timeGapBetweenBalises, balise, time, punches);
            }
            if (!epreuve.isBackAndForth()) continue;
            for (int i = baliseVector.size() - 1; i >= 0; --i) {
                Balise balise;
                balise = (Balise)baliseVector.get(i);
                time = ResultData._createFakeResult(codesToBeSetAsPm, timeGapBetweenBalises, balise, time, punches);
            }
        }
        return time;
    }

    @VisibleForTesting
    void _generateRandomPm(int totalRandomPmToGenerate, List<Partiel> punches) {
        while (!punches.isEmpty() && totalRandomPmToGenerate-- > 0) {
            int index = this._randomGenerator.nextNumberLowerThan(punches.size());
            punches.remove(index);
        }
    }

    @VisibleForTesting
    static Date _createFakeResult(Set<Integer> codesToBeSetAsPm, Date timeGapBetweenBalises, Balise balise, Date time, List<Partiel> punches) {
        if (!codesToBeSetAsPm.contains(balise.getNumber())) {
            Partiel partiel = new Partiel();
            partiel.setCode(balise.getNumber());
            time = new Date(time.getTime() + timeGapBetweenBalises.getTime());
            partiel.setTimeAsDate(time);
            punches.add(partiel);
        }
        return time;
    }

    @VisibleForTesting
    static Date _calculateStartTime(Date startTime, Etape etape, Puce puce) {
        Date time;
        if (etape.getStartType() == StartType.GROUPE) {
            Date startHour;
            time = startHour = etape.getStartHour();
            puce.setStartTime(startHour);
        } else {
            time = startTime;
        }
        return time;
    }

    @VisibleForTesting
    Equipe _createRandomEquipe(Raid raid) {
        Equipe equipe = new Equipe(raid.getPuceResultVector());
        equipe.setPuceIds(this._randomGenerator.nextUniquePuce(1, false));
        equipe.getEquipierVector().addEquipier(new Equipier(L10n.getString("lastname"), L10n.getString("firstname")));
        String bib = String.format("%02d", _dossardNumberCounter);
        equipe.setName(L10n.getString("equipe") + "-" + bib);
        equipe.setBib(bib);
        ResultData._incrementDossardCounter();
        if (raid.getCategorieVector().getSize() > 0) {
            int randCategorie = this._randomGenerator.nextNumberLowerThan(raid.getCategorieVector().getSize());
            equipe.setCategorie(raid.getCategorieVector().getCategorieVector().get(randCategorie));
        }
        return equipe;
    }

    private static void _resetDossardNumberCounter() {
        _dossardNumberCounter = 1;
    }

    private static void _incrementDossardCounter() {
        ++_dossardNumberCounter;
    }

    private void _generateRandomPuceResultsForEquipe(Parcours parcours, Equipe equipe, int totalRandomPmToGenerate, Set<Integer> codesToBeSetAsPm, Date startTime, Date timeGapBetweenBalises) {
        for (Etape etape : parcours.getEtapeVector()) {
            this._generateRandomPuceResultsFromEquipeInEtape(parcours, equipe, etape, totalRandomPmToGenerate, codesToBeSetAsPm, startTime, timeGapBetweenBalises);
        }
    }

    private static void _separateTimedAndUntimedEpreuves(EpreuveVector epreuves, EpreuveVector untimedEpreuves, EpreuveVector timedEpreuves) {
        for (Epreuve epreuve : epreuves.getEpreuveVector()) {
            if (epreuve.isToBeDoneAfterFinish()) {
                untimedEpreuves.addEpreuve(epreuve);
                continue;
            }
            timedEpreuves.addEpreuve(epreuve);
        }
    }

    private Date _calculateFinishTime(Date timeGapBetweenBalises, Date time) {
        return new Date(time.getTime() + timeGapBetweenBalises.getTime());
    }
}

