/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.simulation;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.simulation.RandomResultEditor;
import fr.geraidv3.desktop.simulation.RandomResultGeneratorDialog;
import fr.geraidv3.desktop.simulation.ResultData;
import fr.geraidv3.desktop.simulation.SimulationView;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.etape.EtapeResult;
import fr.geraidv3.result.parcours.ParcoursResult;
import fr.geraidv3.result.puce.PuceResult;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;

final class SimulationPresenter {
    private final SimulationView _view;
    private final ResultData _resultData;
    private final JComboBox<Parcours> _parcoursComboBox;
    private final JComboBox<Etape> _etapeComboBox;
    private final JList<Equipe> _equipeList;

    SimulationPresenter(SimulationView view, Raid raid, JComboBox<Parcours> parcoursComboBox, JComboBox<Etape> etapeComboBox, JList<Equipe> equipeList) {
        this._view = view;
        this._resultData = new ResultData(raid);
        this._parcoursComboBox = parcoursComboBox;
        this._etapeComboBox = etapeComboBox;
        this._equipeList = equipeList;
    }

    Vector<Parcours> getParcoursVector() {
        return this._resultData.getParcoursVector();
    }

    List<Categorie> getCategorieVector() {
        return this._resultData.getCategorieVector();
    }

    EtapeResult createEtapeResult(JComboBox<Categorie> categoryComboBox) {
        return this._resultData.createEtapeResult((Etape)this._etapeComboBox.getSelectedItem(), (Categorie)categoryComboBox.getSelectedItem());
    }

    ParcoursResult createParcoursResult(JComboBox<Categorie> categoryComboBox) {
        return this._resultData.createParcours((Parcours)this._parcoursComboBox.getSelectedItem(), (Categorie)categoryComboBox.getSelectedItem());
    }

    boolean isEtapeSelected() {
        return this._etapeComboBox.getSelectedIndex() > -1;
    }

    boolean isNotEmptyEquipeList() {
        return this._equipeList.getModel().getSize() > 0;
    }

    boolean isEquipeSelected() {
        return this._equipeList.getSelectedIndex() > -1;
    }

    void clearResultsForCurrentParcours() {
        Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
        assert (parcours != null);
        this._resultData.clearData(parcours);
        this._equipeList.setListData(new Vector());
        this.updateResult();
        this.refreshResultTable();
        this._view.updateButtonState();
    }

    void editResult() {
        PuceResult puceResult;
        if (this.isEtapeSelected() && this.isEquipeSelected() && (puceResult = this._resultData.getPuceResult((Etape)this._etapeComboBox.getSelectedItem(), this._equipeList.getSelectedValue())) != null) {
            RandomResultEditor dialog = new RandomResultEditor(this._view, puceResult);
            dialog.setLocationRelativeTo(GeRaidV3.getRootFrame());
            dialog.setVisible(true);
            this.updateResult();
            this.refreshResultTable();
            this._view.updateButtonState();
        }
    }

    void deleteResult() {
        if (this._isParcoursSelected() && this.isEtapeSelected() && this.isEquipeSelected()) {
            int reply;
            assert (this._etapeComboBox.getSelectedItem() != null);
            assert (this._equipeList.getSelectedValue() != null);
            assert (this._parcoursComboBox.getSelectedItem() != null);
            if (this._resultData.existsPuceResult(this._equipeList.getSelectedValue()) && (reply = JOptionPane.showConfirmDialog(this._view.getRootPane(), L10n.getString("simulator.delete.confirmation_message"), L10n.getString("simulator.delete.confirmation_title"), 0, 3)) == 0) {
                EquipeVector equipes = ((Parcours)this._parcoursComboBox.getSelectedItem()).getVarianteFromEquipe(this._equipeList.getSelectedValue()).getEquipeVector();
                this._resultData.removeEquipe(equipes, this._equipeList.getSelectedValue());
                Parcours selectedParcours = (Parcours)this._parcoursComboBox.getSelectedItem();
                this._equipeList.setListData(selectedParcours.getEquipeVector().getEquipeVector());
                this.updateResult();
                this.refreshResultTable();
                this._view.updateButtonState();
            }
        }
    }

    void selectParcours() {
        if (this._isParcoursSelected()) {
            assert (this._parcoursComboBox.getSelectedItem() != null);
            Parcours selectedParcours = (Parcours)this._parcoursComboBox.getSelectedItem();
            this._etapeComboBox.setModel(new DefaultComboBoxModel<Etape>(selectedParcours.getEtapeVector()));
            this._equipeList.setListData(selectedParcours.getEquipeVector().getEquipeVector());
        }
        this.updateResult();
        this.refreshResultTable();
    }

    void updateResult() {
        if (this.isEtapeSelected() && this.isEquipeSelected()) {
            Equipe equipe = this._equipeList.getSelectedValue();
            Etape etape = (Etape)this._etapeComboBox.getSelectedItem();
            String htmlCode = this._resultData.getPuceResultAsHtml(etape, equipe);
            this._view.updateResultView(htmlCode);
        } else {
            this._view.updateResultView(null);
        }
        this._equipeList.repaint();
    }

    void addRandomResults() {
        if (this._isParcoursSelected() && this.isEtapeSelected()) {
            RandomResultGeneratorDialog dialog = new RandomResultGeneratorDialog(this._view, this);
            dialog.setLocationRelativeTo(this._view);
            dialog.setVisible(true);
            this._view.updateButtonState();
        }
    }

    void refreshResultTable() {
        this._view.refreshClassificationTable();
    }

    void generateRandomResults(int totalEquipesToGenerate, int totalRandomPmToGenerate, Set<Integer> codesToBeSetAsPm, Date startTime, Date timeGapBetweenBalises) {
        if (this._isParcoursSelected()) {
            Parcours parcours = (Parcours)this._parcoursComboBox.getSelectedItem();
            assert (parcours != null);
            this._resultData.generateResultsToEquipes(parcours, totalEquipesToGenerate, totalRandomPmToGenerate, codesToBeSetAsPm, startTime, timeGapBetweenBalises);
            this._equipeList.setListData(parcours.getEquipeVector().getEquipeVector());
            this.updateResult();
            this.refreshResultTable();
        }
    }

    private boolean _isParcoursSelected() {
        return this._parcoursComboBox.getSelectedIndex() > -1;
    }
}

