/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.simulation;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.simulation.ClassificationView;
import fr.geraidv3.desktop.simulation.GenerationView;
import fr.geraidv3.desktop.simulation.SimulationPresenter;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

@ExcludeFromJacocoGeneratedReport
final class SimulationView
extends JFrame {
    private final ClassificationView _classificationView;
    private final GenerationView _generationView;

    SimulationView(Raid raid) {
        JList<Equipe> equipeList = new JList<Equipe>();
        JComboBox<Etape> etapeComboBox = new JComboBox<Etape>();
        JComboBox<Parcours> parcoursComboBox = new JComboBox<Parcours>();
        SimulationPresenter presenter = new SimulationPresenter(this, raid, parcoursComboBox, etapeComboBox, equipeList);
        this._generationView = new GenerationView(presenter, parcoursComboBox, etapeComboBox, equipeList);
        this._classificationView = new ClassificationView(presenter, parcoursComboBox);
        this._initializeUI();
        this._initializeValues(presenter, parcoursComboBox);
        this._addShortCutToCloseWindow();
    }

    void updateResultView(String htmlCode) {
        this._generationView.updateResultView(htmlCode);
    }

    void updateButtonState() {
        this._generationView.updateButtonState();
    }

    void refreshClassificationTable() {
        this._classificationView.refreshTable();
    }

    private void _addShortCutToCloseWindow() {
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        KeyStroke ctrlQKey = KeyStroke.getKeyStroke(81, 128);
        inputMap.put(ctrlQKey, ctrlQKey.toString());
        actionMap.put(ctrlQKey.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimulationView.this.dispose();
            }
        });
    }

    private void _initializeUI() {
        this.setTitle(L10n.getString("simulator.title"));
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this._createContentPanel(), "Center");
        pane.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(pane);
        this.pack();
        this.updateButtonState();
    }

    private void _initializeValues(SimulationPresenter presenter, JComboBox<Parcours> parcoursComboBox) {
        parcoursComboBox.setModel(new DefaultComboBoxModel<Parcours>(presenter.getParcoursVector()));
        parcoursComboBox.setSelectedIndex(0);
    }

    private JTabbedPane _createContentPanel() {
        JTabbedPane pane = new JTabbedPane();
        pane.add(L10n.getString("simulator.tab1.title"), this._createGenerationPanel());
        pane.add(L10n.getString("simulator.tab2.title"), this._createResultsPanel());
        return pane;
    }

    private JPanel _createGenerationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add(this._generationView);
        return panel;
    }

    private JPanel _createResultsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add(this._classificationView);
        return panel;
    }

    private JPanel _createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        buttonPanel.add(this._createPrintButton());
        buttonPanel.add(this._createQuitButton());
        return buttonPanel;
    }

    private JButton _createPrintButton() {
        JButton printButton = new JButton(L10n.getString("simulator.print"));
        printButton.addActionListener(event -> this._generationView.printResult());
        return printButton;
    }

    private JButton _createQuitButton() {
        JButton quitButton = new JButton(L10n.getString("simulator.quit"));
        quitButton.addActionListener(event -> this.dispose());
        return quitButton;
    }
}

