/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.sportident_panel;

import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.sportident_panel.SportIdentStationState;
import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.result.puce.Puce;
import fr.geraidv3.result.puce.PuceResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import net.gecosi.CommStatus;
import net.gecosi.SportIdentHandler;
import net.gecosi.SportIdentListener;
import net.gecosi.dataframe.SportIdentDataFrame;
import net.gecosi.dataframe.SportIdentPunch;

public final class SportIdentPuceReaderInResultPanel
implements SportIdentListener {
    private final DesktopPresenter _presenter;
    private String _portName = "";
    private long _zeroTimeInMilliseconds = 32400000L;
    private SportIdentHandler _portHandler;

    public SportIdentPuceReaderInResultPanel(DesktopPresenter presenter) {
        this._presenter = presenter;
    }

    @Override
    public void handleEcard(SportIdentDataFrame puce) {
        PuceResult result = this._presenter.getRaid().createPuceResultForCurrentEtape(puce.getSiNumber());
        this._setResultToPuce(puce, result);
        this._presenter.showSportIdentResulDialog(result, result.getEquipe() != null, false);
    }

    @Override
    public void notify(CommStatus status) {
        if (status == CommStatus.ON) {
            this._presenter.displayStationStatus(SportIdentStationState.READY);
        }
    }

    @Override
    public void notify(CommStatus errorStatus, String errorMessage) {
        this._presenter.displayStationStatus(SportIdentStationState.FAILED);
    }

    public void setPortName(String portName) {
        this._portName = portName;
    }

    public void setZeroTimeInMilliseconds(int hours, int minutes) {
        this._zeroTimeInMilliseconds = (long)hours * 3600L * 1000L + (long)minutes * 60L * 1000L;
    }

    public boolean start() {
        this._portHandler = new SportIdentHandler(this);
        this._portHandler.setZeroHourInMilliseconds(this._zeroTimeInMilliseconds);
        try {
            this._portHandler.connect(this._portName);
            return true;
        }
        catch (SerialPortInvalidPortException | IOException ignored) {
            return false;
        }
    }

    public void stop() {
        if (this._portHandler != null) {
            this._portHandler.stop();
        }
    }

    private void _setResultToPuce(SportIdentDataFrame card, PuceResult puceResult) {
        SportIdentPunch[] punches;
        Puce puce = puceResult.getPuce();
        puce.setId(card.getSiNumber());
        puce.setClearTime(new Date(card.getCheckTime()));
        puce.setCheckTime(new Date(card.getCheckTime()));
        puce.setStartTime(new Date(card.getStartTime()));
        puce.setFinishTime(new Date(card.getFinishTime()));
        puce.setReadTime(new Date());
        ArrayList<Partiel> partiels = new ArrayList<Partiel>();
        for (SportIdentPunch punch : punches = card.getPunches()) {
            Partiel partiel = new Partiel(punch.code(), new Date(punch.timestamp()));
            partiels.add(partiel);
        }
        puce.setPartiels(partiels);
    }
}

