/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.sportident_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.sportident_panel.DocumentRenderer;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.result.data.EtapePuceResult;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.text.html.HTMLDocument;

@ExcludeFromJacocoGeneratedReport
public final class SportIdentPuceResultDialog
extends GDialog {
    private final transient DesktopPresenter _presenter;
    private final transient PuceResult _puceResult;
    private final boolean _isSelectedEquipe;
    private final boolean _isReadOnly;
    private final boolean _isReducedResult;
    private JComboBox<Parcours> _parcoursComboBox;
    private JComboBox<Etape> _etapesComboBox;
    private JComboBox<Equipe> _equipesComboBox;
    private JPanel _resultIdentificationPanel;
    private JButton _validateButton;
    private JScrollPane _resultScrollPane;
    private JLabel _subTitleLabel;
    private JButton _printAndValidateButton;
    private JButton _newEquipeButton;
    private JLabel _labelMessage;
    private JEditorPane _resultPane;
    private JButton _printResultButton;
    private JButton _buttonRefresh;
    private JLabel _extraControlLabel;
    private JPanel _modificationMessageLabel;

    public SportIdentPuceResultDialog(DesktopPresenter presenter, PuceResult puceResult, boolean isSelectedEquipe, boolean isReadOnly, boolean isReducedResult) {
        super(presenter.getFrame());
        this._presenter = presenter;
        this._puceResult = puceResult;
        this._isSelectedEquipe = isSelectedEquipe;
        this._isReadOnly = isReadOnly;
        this._isReducedResult = isReducedResult;
        this._initializeUI();
        this._newEquipeButton.setEnabled(!isSelectedEquipe);
        if (this._isReadOnly) {
            this.setTitle(L10n.getString("sportident_puce_result_dialog.title2"));
            this._resultIdentificationPanel.setVisible(false);
            this._modificationMessageLabel.setVisible(false);
            this._labelMessage.setVisible(false);
            this._validateButton.setVisible(false);
            this._printAndValidateButton.setVisible(false);
            this._printResultButton.setVisible(true);
            this._newEquipeButton.setVisible(false);
            this._resultScrollPane.setBounds(5, 5 + this._buttonRefresh.getHeight(), 480, 380 - this._buttonRefresh.getHeight());
            this.setDefaultButton(this._printResultButton);
        } else {
            this.setDefaultButton(this._printAndValidateButton);
        }
        this._parcoursComboBox.setModel(new DefaultComboBoxModel<Parcours>(this._presenter.getRaid().getParcoursVector().getParcoursVector()));
        if (isSelectedEquipe) {
            this._subTitleLabel.setText(L10n.getString("sportident_puce_result_dialog.result.label", puceResult.getEquipe().getPuceIdsAsString()));
            this._parcoursComboBox.setSelectedItem(this._puceResult.getParcours());
            EtapePuceResult etapePuceResult = new EtapePuceResult(puceResult, 0, 0, false);
            this._extraControlLabel.setText(etapePuceResult.getCodeValidationStateVector().toHtml());
            String htmlCode = etapePuceResult.toHtml(this._presenter.getRaid(), isReducedResult);
            this._resultPane.setText(htmlCode);
            this._resultPane.setCaretPosition(0);
            if (this._presenter.getRaid().existsPuceResult(puceResult) != null) {
                this._labelMessage.setText(L10n.getString("sportident_puce_result_dialog.error1"));
                this._updateButtonsState(false);
            }
        } else {
            this._parcoursComboBox.setSelectedIndex(0);
            String message = L10n.getString("sportident_puce_result_dialog.error2");
            this._labelMessage.setText(message);
            this._updateButtonsState(false);
            JOptionPane.showMessageDialog(this, message, L10n.getString("sportident_puce_result_dialog.error3"), 2);
        }
    }

    private void _initializeUI() {
        this.setModal(true);
        this.setTitle(L10n.getString("sportident_puce_result_dialog.title1"));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)this._createResultIdentificationPanel(), "North");
        panel.add((Component)this._createResultPanel(), "Center");
        panel.add((Component)this._createButtonPanel(), "South");
        this.setContentPane(panel);
        this.pack();
    }

    private void _updateResult() {
        this._puceResult.setParcours((Parcours)this._parcoursComboBox.getSelectedItem());
        this._puceResult.setEtape((Etape)this._etapesComboBox.getSelectedItem());
        this._puceResult.setEquipe((Equipe)this._equipesComboBox.getSelectedItem());
        EtapePuceResult etapePuceResult = new EtapePuceResult(this._puceResult, 0, 0, false);
        this._extraControlLabel.setText(etapePuceResult.getCodeValidationStateVector().toHtml());
        String htmlCode = etapePuceResult.toHtml(this._presenter.getRaid(), this._isReducedResult);
        this._resultPane.setText(htmlCode);
        this._resultPane.setCaretPosition(0);
        if (this._isSelectedEquipe) {
            assert (this._equipesComboBox.getSelectedItem() != null);
            if (((Equipe)this._equipesComboBox.getSelectedItem()).containsPuceId(this._puceResult.getPuce().getId())) {
                if (this._presenter.getRaid().existsPuceResult(this._puceResult) != null) {
                    this._labelMessage.setText(L10n.getString("sportident_puce_result_dialog.error5"));
                    this._updateButtonsState(false);
                } else {
                    this._labelMessage.setText("");
                    this._updateButtonsState(false);
                }
            } else {
                this._labelMessage.setText(L10n.getString("sportident_puce_result_dialog.error6"));
                this._updateButtonsState(true);
            }
        } else {
            this._labelMessage.setText(L10n.getString("sportident_puce_result_dialog.error7"));
            this._updateButtonsState(false);
        }
    }

    private void _updateButtonsState(boolean oKImpossible) {
        if (this._isSelectedEquipe) {
            if (oKImpossible) {
                this._validateButton.setEnabled(false);
                this._printAndValidateButton.setEnabled(false);
                this._printResultButton.setEnabled(false);
            } else {
                this._validateButton.setEnabled(true);
                this._printAndValidateButton.setEnabled(true);
                this._printResultButton.setEnabled(true);
            }
            this._newEquipeButton.setEnabled(false);
        } else {
            this._validateButton.setEnabled(true);
            this._printAndValidateButton.setEnabled(true);
            this._printResultButton.setEnabled(true);
            this._newEquipeButton.setEnabled(true);
        }
        if (this._isReadOnly) {
            this._printResultButton.setEnabled(true);
        }
    }

    private void _printResult() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat minimumMarginPageFormat = this._getMinimumMarginPageFormat(printerJob);
        try {
            DocumentRenderer documentRenderer = new DocumentRenderer(this._resultPane);
            documentRenderer.setScale(0.66);
            printerJob.setPrintable(documentRenderer, minimumMarginPageFormat);
            printerJob.print();
        }
        catch (PrinterException e) {
            ErrorPane.showMessageDialog(this, L10n.getString("result_view.detailed_result.tools.print.error", e.getLocalizedMessage()));
        }
    }

    private PageFormat _getMinimumMarginPageFormat(PrinterJob printerJob) {
        PageFormat pf0 = printerJob.defaultPage();
        PageFormat pf1 = (PageFormat)pf0.clone();
        Paper paper = pf0.getPaper();
        paper.setImageableArea(0.0, 0.0, pf0.getWidth(), pf0.getHeight());
        pf1.setPaper(paper);
        return printerJob.validatePage(pf1);
    }

    private JComponent _createResultIdentificationPanel() {
        this._resultIdentificationPanel = new JPanel();
        this._resultIdentificationPanel.setLayout(new BoxLayout(this._resultIdentificationPanel, 1));
        JPanel panel2 = new JPanel(new GridBagLayout());
        Insets insets = new Insets(3, 3, 3, 3);
        GridBagConstraints constraints1 = new GridBagConstraints();
        constraints1.gridx = 0;
        constraints1.gridy = 0;
        constraints1.ipadx = 5;
        constraints1.insets = insets;
        panel2.add((Component)new JLabel(L10n.getString("parcours_semicolon")), constraints1);
        GridBagConstraints constraints2 = new GridBagConstraints();
        constraints2.gridx = 1;
        constraints2.gridy = 0;
        constraints2.fill = 2;
        constraints2.gridwidth = 0;
        constraints2.weightx = 1.0;
        constraints2.insets = insets;
        panel2.add(this._createParcoursComboBox(), constraints2);
        GridBagConstraints constraints3 = new GridBagConstraints();
        constraints3.gridx = 0;
        constraints3.gridy = 1;
        constraints3.ipadx = 5;
        constraints3.insets = insets;
        panel2.add((Component)new JLabel(L10n.getString("etape_semicolon")), constraints3);
        GridBagConstraints constraints4 = new GridBagConstraints();
        constraints4.gridx = 1;
        constraints4.gridy = 1;
        constraints4.fill = 2;
        constraints4.gridwidth = 0;
        constraints4.weightx = 1.0;
        constraints4.insets = insets;
        panel2.add(this._createEtapesComboBox(), constraints4);
        GridBagConstraints constraints5 = new GridBagConstraints();
        constraints5.gridx = 0;
        constraints5.gridy = 2;
        constraints5.ipadx = 5;
        constraints5.insets = insets;
        panel2.add((Component)new JLabel(L10n.getString("equipe_semicolon")), constraints5);
        GridBagConstraints constraints6 = new GridBagConstraints();
        constraints6.gridx = 1;
        constraints6.gridy = 2;
        constraints6.fill = 2;
        constraints6.gridwidth = 0;
        constraints6.weightx = 1.0;
        constraints6.insets = insets;
        panel2.add(this._createEquipesComboBox(), constraints6);
        GridBagConstraints constraints7 = new GridBagConstraints();
        constraints7.gridx = 0;
        constraints7.gridy = 3;
        constraints7.gridwidth = 2;
        constraints7.anchor = 21;
        constraints7.weightx = 1.0;
        constraints7.insets = insets;
        panel2.add((Component)this._createSubtitle(), constraints7);
        this._resultIdentificationPanel.add(panel2);
        return this._resultIdentificationPanel;
    }

    private JComboBox<Parcours> _createParcoursComboBox() {
        this._parcoursComboBox = new JComboBox();
        this._parcoursComboBox.setPreferredSize(new Dimension(200, 25));
        this._parcoursComboBox.addActionListener(event -> {
            if (this._parcoursComboBox.getSelectedIndex() != -1) {
                assert (this._parcoursComboBox.getSelectedItem() != null);
                this._etapesComboBox.setModel(new DefaultComboBoxModel<Etape>(((Parcours)this._parcoursComboBox.getSelectedItem()).getEtapeVector()));
                this._equipesComboBox.setModel(new DefaultComboBoxModel<Equipe>(((Parcours)this._parcoursComboBox.getSelectedItem()).getEquipeVector().getEquipeVector()));
                if (this._isSelectedEquipe) {
                    this._etapesComboBox.setSelectedItem(this._puceResult.getEtape());
                    this._equipesComboBox.setSelectedItem(this._puceResult.getEquipe());
                } else {
                    this._etapesComboBox.setSelectedIndex(0);
                    this._equipesComboBox.setSelectedIndex(0);
                }
                this._updateResult();
            }
        });
        return this._parcoursComboBox;
    }

    private JComboBox<Etape> _createEtapesComboBox() {
        this._etapesComboBox = new JComboBox();
        this._etapesComboBox.setPreferredSize(new Dimension(200, 25));
        this._etapesComboBox.addActionListener(event -> {
            if (this._isSelectedEquipe) {
                this._equipesComboBox.setSelectedItem(this._puceResult.getEquipe());
            } else {
                this._equipesComboBox.setSelectedIndex(0);
            }
            this._updateResult();
        });
        return this._etapesComboBox;
    }

    private JComboBox<Equipe> _createEquipesComboBox() {
        this._equipesComboBox = new JComboBox();
        this._equipesComboBox.addActionListener(event -> this._updateResult());
        return this._equipesComboBox;
    }

    private JPanel _createResultPanel() {
        this._labelMessage = new JLabel("");
        this._labelMessage.setForeground(Color.red);
        this._labelMessage.setHorizontalAlignment(2);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this._createResultSummaryPanel(), "North");
        panel.add((Component)this._createResultJScrollPane(), "Center");
        panel.add((Component)this._labelMessage, "South");
        return panel;
    }

    private JPanel _createSubtitle() {
        JPanel panel1 = new JPanel(new FlowLayout(0));
        this._subTitleLabel = new JLabel(L10n.getString("sportident_puce_result_dialog.label4"));
        this._subTitleLabel.setForeground(Color.blue);
        panel1.add(this._subTitleLabel);
        panel1.add(this._createRefreshButton());
        return panel1;
    }

    private JButton _createRefreshButton() {
        this._buttonRefresh = new IconButton("reload-24.png");
        this._buttonRefresh.setToolTipText(L10n.getString("sportident_puce_result_dialog.refresh.tooltip"));
        this._buttonRefresh.addActionListener(event -> {
            EtapePuceResult etapePuceResult = new EtapePuceResult(this._puceResult, 0, 0, false);
            String htmlCode = etapePuceResult.toHtml(this._presenter.getRaid(), this._isReducedResult);
            this._resultPane.setText(htmlCode);
            this._resultPane.setCaretPosition(0);
        });
        return this._buttonRefresh;
    }

    private JScrollPane _createResultJScrollPane() {
        this._resultScrollPane = new JScrollPane();
        this._resultScrollPane.setPreferredSize(new Dimension(700, 450));
        this._resultScrollPane.setViewportView(this._createResultEditorPane());
        return this._resultScrollPane;
    }

    private JEditorPane _createResultEditorPane() {
        this._resultPane = new JEditorPane();
        this._resultPane.setBackground(Color.white);
        this._resultPane.setContentType("text/html; charset=UTF-8");
        this._resultPane.setEditable(false);
        this._resultPane.setFocusable(false);
        this._resultPane.setDocument(new HTMLDocument());
        return this._resultPane;
    }

    private JComponent _createResultSummaryPanel() {
        this._extraControlLabel = new JLabel("");
        return this._extraControlLabel;
    }

    private JPanel _createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this._modificationMessageLabel = new JPanel(new FlowLayout(0));
        JLabel identificationLabel = new JLabel(L10n.getString("sportident_puce_result_dialog.confirmation"));
        this._modificationMessageLabel.add(identificationLabel);
        panel.add(this._modificationMessageLabel);
        JPanel panel2 = new JPanel(new FlowLayout(1, 5, 5));
        panel2.add(this._createValidateButton());
        panel2.add(this._createPrintAndValidateButton());
        panel2.add(this._createPrintButton());
        panel2.add(this._createNewEquipeButton());
        panel2.add(this._createCancelButton());
        panel.add(panel2);
        return panel;
    }

    private JButton _createValidateButton() {
        this._validateButton = new JButton(L10n.getString("sportident_puce_result_dialog.validate_button"));
        this._validateButton.setToolTipText(L10n.getString("sportident_puce_result_dialog.validate.tooltip"));
        this._validateButton.addActionListener(event -> {
            this._validatePuceResult();
            this._presenter.refreshResultTable();
            this.dispose();
        });
        return this._validateButton;
    }

    private JButton _createPrintAndValidateButton() {
        this._printAndValidateButton = new JButton(L10n.getString("sportident_puce_result_dialog.validate_and_print.button"));
        this._printAndValidateButton.setToolTipText(L10n.getString("sportident_puce_result_dialog.validate_and_print.tooltip"));
        this._printAndValidateButton.addActionListener(event -> {
            this._validatePuceResult();
            this._printResult();
            this._presenter.refreshResultTable();
            this.dispose();
        });
        return this._printAndValidateButton;
    }

    private JButton _createPrintButton() {
        this._printResultButton = new JButton(L10n.getString("sportident_puce_result_dialog.print.button"));
        this._printResultButton.setToolTipText(L10n.getString("sportident_puce_result_dialog.print.tooltip"));
        this._printResultButton.addActionListener(event -> this._printResult());
        return this._printResultButton;
    }

    private JButton _createNewEquipeButton() {
        this._newEquipeButton = new JButton(L10n.getString("sportident_puce_result_dialog.new_equipe.button"));
        this._newEquipeButton.setToolTipText(L10n.getString("sportident_puce_result_dialog.new_equipe.tooltip"));
        this._newEquipeButton.setEnabled(false);
        this._newEquipeButton.addActionListener(event -> {
            JComboBox<ParcoursVariante> varianteComboBox = new JComboBox<ParcoursVariante>();
            Parcours selectedItem = (Parcours)this._parcoursComboBox.getSelectedItem();
            assert (selectedItem != null);
            varianteComboBox.setModel(new DefaultComboBoxModel<ParcoursVariante>(selectedItem.getVarianteVector().getVarianteParcoursVector()));
            varianteComboBox.setSelectedIndex(0);
            if (varianteComboBox.getItemCount() == 0) {
                DesktopView.beep();
                this._labelMessage.setText(L10n.getString("sportident_puce_result_dialog.error8"));
                return;
            }
            JOptionPane.showMessageDialog(this.rootPane, varianteComboBox, L10n.getString("sportident_puce_result_dialog.variante_message"), 3);
            assert (this._parcoursComboBox.getSelectedItem() != null);
            ParcoursVariante selectedVariante = (ParcoursVariante)varianteComboBox.getSelectedItem();
            Equipe equipe = new Equipe(this._presenter.getRaid().getPuceResultVector());
            equipe.addPuceId(this._puceResult.getPuce().getId());
            equipe.setName(this._puceResult.getPuce().getId());
            equipe.setBib(this._puceResult.getPuce().getId());
            equipe.setCategorie(this._presenter.getRaid().getCategorieVector().getCategorieVector().get(0));
            this._puceResult.setParcours(selectedItem);
            this._puceResult.setEtape((Etape)this._etapesComboBox.getSelectedItem());
            this._puceResult.setEquipe(equipe);
            assert (selectedVariante != null);
            if (selectedVariante.getEquipeVector().addEquipeIfNotExistWithSamePuceAndBib(equipe)) {
                this._presenter.getRaid().getPuceResultVector().addPuceResult(this._puceResult);
                this._presenter.updateEquipes();
                this._presenter.saveCurrentRaid();
                this._presenter.refreshResultTable();
                this.dispose();
            } else {
                DesktopView.beep();
                this._labelMessage.setText(L10n.getString("sportident_puce_result_dialog.error4"));
            }
        });
        return this._newEquipeButton;
    }

    private void _validatePuceResult() {
        this._puceResult.setParcours((Parcours)this._parcoursComboBox.getSelectedItem());
        this._puceResult.setEtape((Etape)this._etapesComboBox.getSelectedItem());
        this._puceResult.setEquipe((Equipe)this._equipesComboBox.getSelectedItem());
        Equipe equipe = this._puceResult.getEquipe();
        assert (equipe != null);
        PuceResult puceResult = this._presenter.getRaid().existsPuceResult(this._puceResult);
        if (puceResult == null) {
            this._presenter.getRaid().getPuceResultVector().addPuceResult(this._puceResult);
            this._presenter.saveCurrentRaid();
        } else {
            this._presenter.getRaid().removePuceResult(puceResult);
            this._presenter.getRaid().addPuceResult(this._puceResult);
        }
    }

    private JButton _createCancelButton() {
        JButton button = new JButton(L10n.getString("sportident_puce_result_dialog.cancel.button"));
        button.setToolTipText(L10n.getString("sportident_puce_result_dialog.cancel.tooltip"));
        button.addActionListener(event -> this.dispose());
        this.setCancelButton(button);
        return button;
    }
}

