/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.sportident_panel;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopPresenter;
import fr.geraidv3.desktop.sportident_panel.CommunicationRail;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.desktop.swing_ext.IconButton;
import fr.geraidv3.desktop.swing_ext.StatefulComponent;
import fr.geraidv3.model.ZeroHour;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

@ExcludeFromJacocoGeneratedReport
public final class SportIdentPuceView
extends JPanel
implements StatefulComponent {
    private final transient DesktopPresenter _presenter;
    private JButton _sportIdentReaderButton;
    private JComboBox<String> _communicationPortsCombBox;
    private JSpinner _zeroHourSpinner;
    private JSpinner _zeroMinuteSpinner;
    private boolean _sportIdentReaderEnabled = false;

    public SportIdentPuceView(DesktopPresenter presenter) {
        this._presenter = presenter;
        this._createContent();
        this._updateCommunicationPortList();
    }

    public void changeStateToStart() {
        this._sportIdentReaderButton.setIcon(this._getIcon("play-24.png"));
        this._sportIdentReaderEnabled = false;
        this._zeroHourSpinner.setEnabled(true);
        this._zeroMinuteSpinner.setEnabled(true);
    }

    public void changeStateToStop() {
        this._sportIdentReaderButton.setIcon(this._getIcon("stop-24.png"));
    }

    public void changeStateToWaitForInitialization() {
        this._sportIdentReaderButton.setIcon(this._getIcon("wait-24.png"));
        this._sportIdentReaderEnabled = true;
        this._zeroHourSpinner.setEnabled(false);
        this._zeroMinuteSpinner.setEnabled(false);
    }

    public String getSelectedPort() {
        return (String)this._communicationPortsCombBox.getSelectedItem();
    }

    public void activateSportIdentButton() {
        this._presenter.activateSportIdentButton(this, this._sportIdentReaderEnabled, (Integer)this._zeroHourSpinner.getValue(), (Integer)this._zeroMinuteSpinner.getValue(), (String)this._communicationPortsCombBox.getSelectedItem());
    }

    public void setTime(ZeroHour timeZero) {
        this._zeroHourSpinner.setValue(timeZero.getHours());
        this._zeroMinuteSpinner.setValue(timeZero.getMinutes());
    }

    public void setSportIdentReaderButtonEnabled(boolean b) {
        this._sportIdentReaderButton.setEnabled(b);
    }

    public boolean isSportIdentReaderEnabled() {
        return this._sportIdentReaderEnabled;
    }

    public void displayNoPortErrorMessage() {
        ErrorPane.showMessageDialog(this.getRootPane(), L10n.getString("sportident_panel.error1"));
    }

    public void displayBadPortErrorMessage() {
        ErrorPane.showMessageDialog(this.getRootPane(), L10n.getString("sportident_panel.error2"));
    }

    @Override
    public void update(DesktopPresenter presenter) {
    }

    private void _createContent() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, L10n.getString("sportident_panel.subtitle1"), 4, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 17;
        c.fill = 3;
        c.weightx = 0.0;
        this.add((Component)this._createHourZeroPanel(), c);
        c.gridx = 1;
        this.add((Component)this._createSportIdentReaderPanel(), c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.add(Box.createHorizontalGlue(), c);
    }

    private JPanel _createHourZeroPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(new TitledBorder(null, L10n.getString("sportident_panel.subtitle2"), 4, 2));
        panel.add(this._createZeroHourSpinner());
        panel.add(new JLabel(L10n.getString("hour_abbreviation")));
        panel.add(this._createZeroMinuteSpinner());
        panel.add(new JLabel(L10n.getString("minute_abbreviation")));
        return panel;
    }

    private JPanel _createSportIdentReaderPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(new TitledBorder(null, L10n.getString("sportident_panel.title"), 4, 2));
        panel.add(this._createCommunicationPortsComboBox());
        panel.add(this._createReloadCommunicationPortsButton());
        panel.add(this._createSportIdentReaderButton());
        return panel;
    }

    private JButton _createReloadCommunicationPortsButton() {
        IconButton button = new IconButton("reload-24.png");
        button.setToolTipText(L10n.getString("sportident_panel.reset"));
        button.addActionListener(event -> this._updateCommunicationPortList());
        return button;
    }

    private JSpinner _createZeroHourSpinner() {
        this._zeroHourSpinner = new JSpinner();
        this._zeroHourSpinner.setEditor(new JSpinner.NumberEditor(this._zeroHourSpinner, "00"));
        this._zeroHourSpinner.setModel(new SpinnerNumberModel(0, 0, 23, 1));
        this._zeroHourSpinner.addChangeListener(event -> this._presenter.setZeroHour((Integer)this._zeroHourSpinner.getValue()));
        this._zeroHourSpinner.setToolTipText(L10n.getString("sportident_panel.tooltip2"));
        return this._zeroHourSpinner;
    }

    private JSpinner _createZeroMinuteSpinner() {
        this._zeroMinuteSpinner = new JSpinner();
        this._zeroMinuteSpinner.setEditor(new JSpinner.NumberEditor(this._zeroMinuteSpinner, "00"));
        this._zeroMinuteSpinner.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        this._zeroMinuteSpinner.addChangeListener(event -> this._presenter.setZeroMinute((Integer)this._zeroMinuteSpinner.getValue()));
        this._zeroMinuteSpinner.setToolTipText(L10n.getString("sportident_panel.tooltip2"));
        return this._zeroMinuteSpinner;
    }

    private JComboBox<String> _createCommunicationPortsComboBox() {
        this._communicationPortsCombBox = new JComboBox();
        Dimension preferredSize = this._communicationPortsCombBox.getPreferredSize();
        preferredSize.width = 150;
        this._communicationPortsCombBox.setPreferredSize(preferredSize);
        return this._communicationPortsCombBox;
    }

    private JButton _createSportIdentReaderButton() {
        this._sportIdentReaderButton = new IconButton("play-24.png");
        this._sportIdentReaderButton.setToolTipText(L10n.getString("sportident_panel.reader_button"));
        this._sportIdentReaderButton.addActionListener(event -> this.activateSportIdentButton());
        return this._sportIdentReaderButton;
    }

    private ImageIcon _getIcon(String iconName) {
        return new ImageIcon(this.getClass().getClassLoader().getResource("fr/geraidv3/icon/" + iconName));
    }

    private void _updateCommunicationPortList() {
        this._communicationPortsCombBox.setModel(new DefaultComboBoxModel<String>(CommunicationRail.getAvailablePortsRail()));
    }
}

