/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.swing_ext;

import fr.geraidv3.model.parcours.ParcoursVariante;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public final class MyComboBox<E>
extends JComboBox<E> {
    private final transient E _unselectableItem;
    private transient ComboBoxModel<E> _model;

    private MyComboBox(E unselectableItem) {
        this._unselectableItem = unselectableItem;
    }

    public static MyComboBox<ParcoursVariante> build(String label) {
        return new MyComboBox<ParcoursVariante>(new ParcoursVariante(label));
    }

    public int getSelectedItemIndex() {
        return super.getSelectedIndex() - 1;
    }

    public void setSelectedItemIndex(int index) {
        if (index < 0 || this.getModel().getSize() > 0) {
            super.setSelectedIndex(index);
        }
    }

    public Object getSelectedItemValue() {
        if (super.getSelectedIndex() == 0) {
            return null;
        }
        return super.getSelectedItem();
    }

    @Override
    public ComboBoxModel<E> getModel() {
        return this._model;
    }

    @Override
    public void setModel(ComboBoxModel<E> aModel) {
        this._model = aModel;
        this._setModelCopy(aModel);
        this._addUnselectableItemAsFirstItem();
    }

    public void setSelectedValue(E value) {
        super.setSelectedItem(value);
    }

    private void _addUnselectableItemAsFirstItem() {
        ParcoursVariante firstItem = (ParcoursVariante)super.getItemAt(0);
        ParcoursVariante unselectableItem = (ParcoursVariante)this._unselectableItem;
        if (firstItem != null && !unselectableItem.getName().equals(firstItem.getName())) {
            super.insertItemAt(this._unselectableItem, 0);
        }
    }

    private void _setModelCopy(ComboBoxModel<E> aModel) {
        super.setModel(new DefaultComboBoxModel());
        for (int i = 0; i < aModel.getSize(); ++i) {
            super.addItem(aModel.getElementAt(i));
        }
    }
}

