/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.swing_ext;

import fr.geraidv3.desktop.swing_ext.MultiLineCellRenderer;
import fr.geraidv3.desktop.swing_ext.TableModelWithHeaderTooltips;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class TableWithHeaderTooltips
extends JTable {
    private String[] _columnToolTips = null;

    public TableWithHeaderTooltips() {
        this.setDefaultRenderer(String.class, new MultiLineCellRenderer());
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setModel(@NotNull TableModel dataModel) {
        super.setModel(dataModel);
        if (this.getModel() instanceof TableModelWithHeaderTooltips) {
            this._columnToolTips = ((TableModelWithHeaderTooltips)this.getModel()).getColumnTooltips();
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return super.getScrollableTracksViewportWidth() && this.getPreferredSize().width < this.getParent().getWidth();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent event) {
                if (TableWithHeaderTooltips.this._columnToolTips != null) {
                    Point p = event.getPoint();
                    int index = this.columnModel.getColumnIndexAtX(p.x);
                    int realIndex = this.columnModel.getColumn(index).getModelIndex();
                    return TableWithHeaderTooltips.this._columnToolTips[realIndex];
                }
                return null;
            }
        };
    }
}

