/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.tools_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.tools_menu.TimeCalculatorModel;
import fr.geraidv3.utils.DateTimeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.undo.UndoManager;

public class TimeCalculator
extends JFrame {
    private final JTextField _textField;

    public TimeCalculator() {
        this.setTitle(L10n.getString("time_calculator.window.title"));
        this.setSize(500, 100);
        JPanel panel = new JPanel(new BorderLayout(8, 8));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this._textField = new JTextField();
        this._textField.setFont(new Font("Monospaced", 0, 18));
        this._textField.addActionListener(e -> this._calculate());
        panel.add((Component)new JLabel(L10n.getString("time_calculator.description.label")), "North");
        panel.add((Component)this._textField, "Center");
        this.add(panel);
        final UndoManager undoManager = new UndoManager();
        this._textField.getDocument().addUndoableEditListener(undoManager);
        AbstractAction undoAction = new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        };
        AbstractAction redoAction = new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (undoManager.canRedo()) {
                    undoManager.redo();
                }
            }
        };
        this._textField.getInputMap().put(KeyStroke.getKeyStroke(90, 128), "undo");
        this._textField.getActionMap().put("undo", undoAction);
        this._textField.getInputMap().put(KeyStroke.getKeyStroke(89, 128), "redo");
        this._textField.getActionMap().put("redo", redoAction);
        this._textField.getInputMap().put(KeyStroke.getKeyStroke(90, 192), "redo");
        this._addShortCutToCloseWindow();
    }

    private void _addShortCutToCloseWindow() {
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        KeyStroke ctrlQKey = KeyStroke.getKeyStroke(81, 128);
        inputMap.put(ctrlQKey, ctrlQKey.toString());
        actionMap.put(ctrlQKey.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeCalculator.this.dispose();
            }
        });
    }

    private void _calculate() {
        TimeCalculatorModel calculatorModel = new TimeCalculatorModel();
        String input = this._textField.getText();
        try {
            TimeCalculatorModel.Result result = calculatorModel._evaluate(input);
            if (result.isTime) {
                this._textField.setText(DateTimeUtils.millisecondsToString(result.value));
            } else {
                this._textField.setText(String.valueOf(result.value));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), "Error", 0);
        }
    }
}

