/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.tools_menu;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.VisibleForTesting;

class TimeCalculatorModel {
    private int _pos = 0;
    private List<String> _tokens;

    TimeCalculatorModel() {
    }

    @VisibleForTesting
    Result _evaluate(String expression) {
        this._tokens = this._tokenize(expression);
        this._pos = 0;
        if (this._tokens.isEmpty()) {
            return new Result(0L, false);
        }
        return this._parseExpression();
    }

    private List<String> _tokenize(String expression) {
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(\\d+:\\d+:\\d+)|(\\d+)|([+\\-*/()])");
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            tokens.add(matcher.group());
        }
        return tokens;
    }

    private Result _parseExpression() {
        String op;
        Result val = this._parseTerm();
        while (this._pos < this._tokens.size() && ((op = this._tokens.get(this._pos)).equals("+") || op.equals("-"))) {
            ++this._pos;
            Result right = this._parseTerm();
            if (op.equals("+")) {
                if (val.isTime && right.isTime) {
                    val = new Result(val.value + right.value, true);
                    continue;
                }
                if (!val.isTime && !right.isTime) {
                    val = new Result(val.value + right.value, false);
                    continue;
                }
                throw new IllegalArgumentException("Cannot add Time and Integer");
            }
            if (val.isTime && right.isTime) {
                val = new Result(val.value - right.value, true);
                continue;
            }
            if (!val.isTime && !right.isTime) {
                val = new Result(val.value - right.value, false);
                continue;
            }
            throw new IllegalArgumentException("Cannot subtract Time and Integer mixed");
        }
        return val;
    }

    private Result _parseTerm() {
        String op;
        Result val = this._parseFactor();
        while (this._pos < this._tokens.size() && ((op = this._tokens.get(this._pos)).equals("*") || op.equals("/"))) {
            ++this._pos;
            Result right = this._parseFactor();
            if (op.equals("*")) {
                if (val.isTime && !right.isTime) {
                    val = new Result(val.value * right.value, true);
                    continue;
                }
                if (!val.isTime && right.isTime) {
                    val = new Result(val.value * right.value, true);
                    continue;
                }
                if (!val.isTime) {
                    val = new Result(val.value * right.value, false);
                    continue;
                }
                throw new IllegalArgumentException("Cannot multiply Time by Time");
            }
            if (val.isTime && !right.isTime) {
                val = new Result(val.value / right.value, true);
                continue;
            }
            if (!val.isTime && !right.isTime) {
                val = new Result(val.value / right.value, false);
                continue;
            }
            throw new IllegalArgumentException("Cannot divide by Time or Time/Time");
        }
        return val;
    }

    private Result _parseFactor() {
        if (this._pos >= this._tokens.size()) {
            throw new IllegalArgumentException("Unexpected end of expression");
        }
        String token = this._tokens.get(this._pos);
        ++this._pos;
        if (token.equals("-")) {
            Result val = this._parseFactor();
            return new Result(-val.value, val.isTime);
        }
        if (token.equals("(")) {
            Result val = this._parseExpression();
            if (this._pos >= this._tokens.size() || !this._tokens.get(this._pos).equals(")")) {
                throw new IllegalArgumentException("Missing closing parenthesis");
            }
            ++this._pos;
            return val;
        }
        if (token.contains(":")) {
            long ms = this._parseTime(token);
            return new Result(ms, true);
        }
        try {
            long v = Long.parseLong(token);
            return new Result(v, false);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number or token: " + token);
        }
    }

    private long _parseTime(String timeStr) {
        String[] parts = timeStr.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid time format: " + timeStr);
        }
        try {
            long h = Long.parseLong(parts[0]);
            long m = Long.parseLong(parts[1]);
            long s = Long.parseLong(parts[2]);
            return (h * 3600L + m * 60L + s) * 1000L;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid time format: " + timeStr);
        }
    }

    static class Result {
        final long value;
        final boolean isTime;

        Result(long value, boolean isTime) {
            this.value = value;
            this.isTime = isTime;
        }
    }
}

