/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model;

import com.formdev.flatlaf.FlatLightLaf;
import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.categorie.CategorieVector;
import java.util.Base64;
import java.util.prefs.Preferences;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class GlobalSettings {
    private final Balise _baliseModel = new Balise();
    private final PublicationSettings _publicationSettings = new PublicationSettings();
    private boolean _isShortIndividualResultPrinting = true;
    private boolean _isShortGlobalResultPrinting = false;
    private boolean _tooltipsEnabled = true;
    private int _fontScale = 100;
    private String _clubName = L10n.getString("settings.club_name.template");
    private String _raidDirectoryPath = "";
    private String _backupDirectoryPath = "";
    private CategorieVector _categoriesTemplate = new CategorieVector();

    public String getIsShortIndividualResultPrintingAsString() {
        return this._isShortIndividualResultPrinting ? "1" : "0";
    }

    public boolean isShortIndividualResultPrinting() {
        return this._isShortIndividualResultPrinting;
    }

    public void setShortIndividualResultPrinting(boolean state) {
        this._isShortIndividualResultPrinting = state;
    }

    public String getIsShortGlobalResultPrintingAsString() {
        return this._isShortGlobalResultPrinting ? "1" : "0";
    }

    public boolean isShortGlobalResultPrinting() {
        return this._isShortGlobalResultPrinting;
    }

    public void setShortGlobalResultPrinting(boolean value) {
        this._isShortGlobalResultPrinting = value;
    }

    public boolean isTooltipsEnabled() {
        return this._tooltipsEnabled;
    }

    public void setTooltipsEnabled(boolean value) {
        ToolTipManager.sharedInstance().setEnabled(value);
        this._tooltipsEnabled = value;
    }

    public int getFontScale() {
        return this._fontScale;
    }

    public void setFontScale(int scale) {
        this._fontScale = scale;
        if (GeRaidV3.getRootFrame() != null) {
            try {
                System.setProperty("flatlaf.uiScale", scale + "%");
                UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
                SwingUtilities.updateComponentTreeUI(GeRaidV3.getRootFrame());
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                // empty catch block
            }
        }
    }

    public PublicationSettings getPublicationSettings() {
        return this._publicationSettings;
    }

    public String getClubName() {
        return this._clubName;
    }

    public void setClubName(String clubName) {
        this._clubName = clubName;
    }

    public String getWorkingDirectoryPath() {
        return this._raidDirectoryPath;
    }

    public void setWorkingDirectoryPath(String directory) {
        this._raidDirectoryPath = directory;
    }

    public String getBackupDirectoryPath() {
        return this._backupDirectoryPath;
    }

    public void setBackupDirectoryPath(String directory) {
        this._backupDirectoryPath = directory;
    }

    public CategorieVector getCategoriesTemplate() {
        return this._categoriesTemplate;
    }

    public void setCategoriesTemplate(CategorieVector categories) {
        this._categoriesTemplate = categories;
    }

    public CategorieVector getCategoriesTemplateCopy() {
        return new CategorieVector(this._categoriesTemplate);
    }

    public Balise getBaliseModel() {
        return this._baliseModel;
    }

    public int getPunchPointsBonus() {
        return this._baliseModel.getPunchPointsBonus();
    }

    public void setPunchPointsBonus(int points) {
        this._baliseModel.setPunchPointsBonus(points);
    }

    public int getPunchTimeBonusInS() {
        return this._baliseModel.getPunchTimeBonusInS();
    }

    public void setPunchTimeBonusInS(int time) {
        this._baliseModel.setPunchTimeBonusInS(time);
    }

    public int getMispunchPointsPenalty() {
        return this._baliseModel.getMispunchPointsPenalty();
    }

    public void setMispunchPointsPenalty(int points) {
        this._baliseModel.setMispunchPointsPenalty(points);
    }

    public int getMispunchTimePenaltyInS() {
        return this._baliseModel.getMispunchTimePenaltyInS();
    }

    public void setMispunchTimePenaltyInS(int time) {
        this._baliseModel.setMispunchTimePenaltyInS(time);
    }

    public void setDefaultValues() {
        this._categoriesTemplate.addCategorie(new Categorie(L10n.getString("settings.category.man"), L10n.getString("settings.category.man_abbreviation")));
        this._categoriesTemplate.addCategorie(new Categorie(L10n.getString("settings.category.woman"), L10n.getString("settings.category.woman_abbreviation")));
        this._categoriesTemplate.addCategorie(new Categorie(L10n.getString("settings.category.mixed"), L10n.getString("settings.category.mixed_abbreviation")));
    }

    public String getPublicationUrl() {
        Preferences preferences = GlobalSettings.getPreferences();
        return preferences.get("db_url", "");
    }

    public void setPublicationUrl(String url) {
        Preferences preferences = GlobalSettings.getPreferences();
        preferences.put("db_url", url);
    }

    private static Preferences getPreferences() {
        return Preferences.userNodeForPackage(GeRaidV3.class);
    }

    public static final class PublicationSettings {
        private String _host = "";
        private String _destinationFolder = "";
        private String _username = "";
        private String _password = "";

        public PublicationSettings() {
            Preferences preferences = GlobalSettings.getPreferences();
            this._host = this._loadHost(preferences);
            this._destinationFolder = this._loadDestinationFolder(preferences);
            this._username = this._loadUsername(preferences);
            this._password = this._loadPassword(preferences);
        }

        public PublicationSettings(String host, String destinationFolder, String username, String password) {
            this._host = host;
            this._destinationFolder = destinationFolder;
            this._username = username;
            this._password = password;
        }

        public boolean hasEmptyParameters() {
            return this._host.isEmpty() || this._username.isEmpty() || this._destinationFolder.isEmpty() || this._password.isEmpty();
        }

        public void save(PublicationSettings settings) {
            this._host = settings._host;
            this._destinationFolder = settings._destinationFolder;
            this._username = settings._username;
            this._password = settings._password;
            Preferences preferences = GlobalSettings.getPreferences();
            this._saveHost(preferences, this._host);
            this._saveDestinationFolder(preferences, this._destinationFolder);
            this._saveUsername(preferences, this._username);
            this._savePassword(preferences, this._password);
        }

        public String getHost() {
            return this._host;
        }

        public String getUsername() {
            return this._username;
        }

        public String getPassword() {
            return this._password;
        }

        public String getDestinationFolder() {
            return this._destinationFolder;
        }

        private String _loadHost(Preferences preferences) {
            return preferences.get("db_host", "");
        }

        private void _saveHost(Preferences preferences, String host) {
            preferences.put("db_host", host);
        }

        private String _loadDestinationFolder(Preferences preferences) {
            return preferences.get("db_path", "");
        }

        private void _saveDestinationFolder(Preferences preferences, String path) {
            preferences.put("db_path", path);
        }

        private String _loadUsername(Preferences preferences) {
            return preferences.get("db_username", "");
        }

        private void _saveUsername(Preferences preferences, String username) {
            preferences.put("db_username", username);
        }

        private String _loadPassword(Preferences preferences) {
            String encodedPassword = preferences.get("db_password", "");
            if (encodedPassword.isEmpty()) {
                return "";
            }
            try {
                return new String(Base64.getDecoder().decode(encodedPassword));
            }
            catch (IllegalArgumentException e) {
                return "";
            }
        }

        private void _savePassword(Preferences preferences, String password) {
            String encodedPassword = Base64.getEncoder().encodeToString(password.getBytes());
            preferences.put("db_password", encodedPassword);
        }
    }
}

