/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model;

import fr.geraidv3.model.InternalPenalitesIndividuelles;
import fr.geraidv3.model.RaidSettings;
import fr.geraidv3.model.ZeroHour;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.categorie.CategorieVector;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.model.parcours.ParcoursVector;
import fr.geraidv3.result.penalite.Penalite;
import fr.geraidv3.result.penalite.PenaliteIndividuelle;
import fr.geraidv3.result.penalite.PenaliteVector;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.result.puce.PuceResultVector;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public final class Raid {
    private final ParcoursVector _parcoursVector = new ParcoursVector();
    private final PuceResultVector _puceResultVector = new PuceResultVector();
    private final PenaliteVector _penaliteVector = new PenaliteVector();
    private final List<InternalPenalitesIndividuelles> _individualPenalties = new ArrayList<InternalPenalitesIndividuelles>();
    private final RaidSettings _raidSettings = new RaidSettings();
    private EquipeVector _equipeVector = new EquipeVector();
    private CategorieVector _categorieVector = new CategorieVector();

    public static Raid copyWithoutEquipes(Raid otherRaid) {
        Raid raid = new Raid();
        for (Parcours parcours : otherRaid.getParcoursVector().getParcoursVector()) {
            Parcours newParcours = new Parcours(parcours);
            newParcours.setName(parcours.getName());
            raid._parcoursVector.addParcours(newParcours);
            for (int i = 0; i < newParcours.getVarianteVector().getVarianteParcoursVector().size(); ++i) {
                String name = parcours.getVarianteVector().getVarianteParcoursVector().get(i).getName();
                newParcours.getVarianteVector().getVarianteParcoursVector().get(i).setName(name);
            }
        }
        raid._categorieVector = otherRaid.getCategorieVector();
        raid._raidSettings.setCurrentFilename(otherRaid.getCurrentFilename());
        raid._raidSettings.setEnabledDisplayTeammate(otherRaid.withTeammates());
        raid._raidSettings.setPrintFooter(otherRaid.getPrintFooter());
        raid._raidSettings.setPrintHeader(otherRaid.getPrintHeader());
        raid._raidSettings.setRaidName(otherRaid.getRaidName());
        return raid;
    }

    public String getRaidName() {
        return this._raidSettings.getRaidName();
    }

    public void setRaidName(String nom) {
        this._raidSettings.setRaidName(nom);
    }

    public String getCurrentFilename() {
        return this._raidSettings.getCurrentFilename();
    }

    public void setCurrentFilename(String filename) {
        this._raidSettings.setCurrentFilename(filename);
    }

    public String getPrintHeader() {
        return this._raidSettings.getPrintHeader();
    }

    public void setPrintHeader(String text) {
        this._raidSettings.setPrintHeader(text);
    }

    public String getPrintFooter() {
        return this._raidSettings.getPrintFooter();
    }

    public void setPrintFooter(String text) {
        this._raidSettings.setPrintFooter(text);
    }

    public ParcoursVector getParcoursVector() {
        return this._parcoursVector;
    }

    public void addParcours(Parcours parcours) {
        this._parcoursVector.addParcours(parcours);
    }

    public boolean existsAnotherParcoursWithSameName(String name, Parcours parcours) {
        return this._parcoursVector.existsAnotherParcoursWithSameName(name, parcours);
    }

    public void removeParcours(Parcours parcours) {
        this._parcoursVector.removeParcours(parcours);
        this._puceResultVector.removePuceResultForParcours(parcours);
    }

    public void addPuceResult(PuceResult puceResult) {
        this._puceResultVector.addPuceResult(puceResult);
    }

    public void addOrReplacePuceResult(PuceResult puceResult) {
        this._puceResultVector.andOrReplacePuceResult(puceResult);
    }

    public void removePuceResult(PuceResult puceResult) {
        this._puceResultVector.removePuceResult(puceResult);
    }

    public void resetData() {
        this._parcoursVector.clear();
        this._puceResultVector.clear();
        this._penaliteVector.clear();
        this._individualPenalties.clear();
        this._categorieVector.clear();
        this._raidSettings.reset();
    }

    public boolean addEquipe(ParcoursVariante variante, Equipe equipe) {
        return this._parcoursVector.addEquipeInParcours(variante, equipe);
    }

    public void removeEquipe(EquipeVector equipeVector, Equipe equipe) {
        equipeVector.removeEquipe(equipe);
        this._puceResultVector.removePuceResultForEquipe(equipe);
    }

    public void addCategorie(Categorie categorie) {
        this._categorieVector.addCategorie(categorie);
    }

    public CategorieVector getCategorieVector() {
        return this._categorieVector;
    }

    public void setCategorieVector(CategorieVector categorie) {
        this._categorieVector = categorie;
    }

    public PuceResult createPuceResultForCurrentEtape(String puceId) {
        PuceResult puceResult = new PuceResult();
        Vector<Parcours> parcoursVector = this._parcoursVector.getParcoursVector();
        for (Parcours parcours : parcoursVector) {
            Vector<ParcoursVariante> variantes = parcours.getVarianteVector().getVarianteParcoursVector();
            for (ParcoursVariante variante : variantes) {
                Etape etape;
                Equipe equipe = variante.getEquipeFromPuceId(puceId);
                if (equipe == null || (etape = variante.getCurrentEtape()) == null) continue;
                puceResult.setParcours(parcours);
                puceResult.setEtape(etape);
                puceResult.setEquipe(equipe);
                return puceResult;
            }
        }
        return puceResult;
    }

    public PuceResultVector getPuceResultVector() {
        return this._puceResultVector;
    }

    public Equipe getEquipeFromPuceId(String puceId) {
        return this._parcoursVector.getEquipeFromPuceId(puceId);
    }

    public Parcours getParcoursFromIdPuce(String idPuce) {
        return this._parcoursVector.getParcoursFromPuceId(idPuce);
    }

    public PuceResult existsPuceResult(PuceResult puceResult) {
        return this._puceResultVector.existsPuceResult(puceResult);
    }

    public boolean existsPuceResult(Equipe equipe) {
        return this._puceResultVector.existsPuceResult(equipe);
    }

    public boolean existsPuceResultForId(String puceId) {
        return this._puceResultVector.existsPuceResultForId(puceId);
    }

    public boolean notExistsPuceId(String puceId, Equipe equipe) {
        return !this._parcoursVector.existsPuceId(puceId, equipe);
    }

    public boolean existsPuce(String idPuce) {
        return this._parcoursVector.existsPuceFromId(idPuce);
    }

    public Parcours getParcoursFromEpreuve(Epreuve epreuve) {
        return this._parcoursVector.getParcoursFromEpreuve(epreuve);
    }

    public Parcours getParcoursFromEtape(Etape etape) {
        return this._parcoursVector.getParcoursFromEtape(etape);
    }

    public Equipe getEquipeWithoutPuceFromIndex(Parcours parcours, int index) {
        Vector<Equipe> equipeVector = parcours.getEquipeVector().getEquipeVector();
        for (int i = index; i < equipeVector.size(); ++i) {
            Equipe equipe = (Equipe)equipeVector.get(i);
            if (equipe.getPuceCount() >= equipe.getEquipierVector().getSize()) continue;
            return equipe;
        }
        return null;
    }

    public String[] getResultColumnNameHeaders(Etape etape) {
        return this._raidSettings.getResultColumnNameHeaders(etape, this._penaliteVector);
    }

    public Penalite getPenalite(Etape etape, int penaliteIndex) {
        return this._penaliteVector.getPenaliteAt(etape, penaliteIndex);
    }

    public PenaliteIndividuelle getPenaliteIndividuelle(Etape etape, int penaliteIndex, String puce) {
        Penalite penalite = this.getPenalite(etape, penaliteIndex);
        if (penalite == null) {
            return null;
        }
        return penalite.getPenaliteIndividuelle(puce);
    }

    public String exportAllParcoursAsHTML() {
        return this._parcoursVector.toHtml();
    }

    public void removePuceResultForEquipe(Equipe equipe) {
        this._puceResultVector.removePuceResultForEquipe(equipe);
    }

    public EquipeVector getAllEquipesThatNameContains(String pattern) {
        String lowercasePattern = pattern.trim().toLowerCase();
        if (lowercasePattern.isEmpty()) {
            return this.getEquipeVector();
        }
        this._equipeVector = new EquipeVector();
        for (Parcours parcours : this._parcoursVector.getParcoursVector()) {
            for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                List<Equipe> equipes = variante.getEquipeVector().getAllEquipesThatNameContains(lowercasePattern);
                this._equipeVector.getEquipeVector().addAll(equipes);
            }
        }
        return this._equipeVector;
    }

    public EquipeVector getAllEquipesThatPuceIdContains(String pattern) {
        if (pattern.isEmpty()) {
            return this.getEquipeVector();
        }
        this._equipeVector = new EquipeVector();
        for (Parcours parcours : this._parcoursVector.getParcoursVector()) {
            for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                List<Equipe> equipes = variante.getEquipeVector().getAllEquipeThatPuceIdContains(pattern);
                this._equipeVector.getEquipeVector().addAll(equipes);
            }
        }
        return this._equipeVector;
    }

    public EquipeVector getAllEquipesThatEquipierNameContains(String pattern) {
        String trimmedPattern = pattern.trim();
        if (trimmedPattern.isEmpty()) {
            return this.getEquipeVector();
        }
        this._equipeVector = new EquipeVector();
        for (Parcours parcours : this._parcoursVector.getParcoursVector()) {
            for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                List<Equipe> equipes = variante.getEquipeVector().getEquipeVectorThatEquipierNameContains(trimmedPattern);
                this._equipeVector.getEquipeVector().addAll(equipes);
            }
        }
        return this._equipeVector;
    }

    public EquipeVector getEquipeVector() {
        this._equipeVector = new EquipeVector();
        for (Parcours parcours : this._parcoursVector.getParcoursVector()) {
            Vector<ParcoursVariante> varianteVector = parcours.getVarianteVector().getVarianteParcoursVector();
            for (ParcoursVariante variante : varianteVector) {
                this._equipeVector.getEquipeVector().addAll(variante.getEquipeVector().getEquipeVector());
            }
        }
        return this._equipeVector;
    }

    public boolean withTeammates() {
        return this._raidSettings.isEnabledDisplayTeammate();
    }

    public void setEnabledDisplayTeammate(boolean value) {
        this._raidSettings.setEnabledDisplayTeammate(value);
    }

    public ZeroHour getHourZero() {
        return this._raidSettings.getZeroTime();
    }

    public PenaliteVector getPenaliteVector() {
        return this._penaliteVector;
    }

    public Object[][] getPenalitesIndividuellesAsTable(Parcours parcours, Etape etape) {
        int numberOfColumns = this._raidSettings.getResultNumberOfColumns();
        this._setPenalitesIndividuelles(parcours, etape);
        Object[][] result = new Object[this._individualPenalties.size()][numberOfColumns];
        for (int i = 0; i < this._individualPenalties.size(); ++i) {
            InternalPenalitesIndividuelles penalitesIndividuelles = this._individualPenalties.get(i);
            result[i][0] = penalitesIndividuelles.getBib();
            result[i][1] = penalitesIndividuelles.getEquipe();
            result[i][2] = penalitesIndividuelles.getPuce();
            for (int j = 3; j < numberOfColumns; j += 2) {
                result[i][j] = penalitesIndividuelles.getPoint((j - 3) / 2);
                result[i][j + 1] = penalitesIndividuelles.getTime((j - 3) / 2);
            }
        }
        return result;
    }

    public boolean existsAnotherVarianteWithSameName(String varianteName, ParcoursVariante variante) {
        return this._parcoursVector.existsAnotherVarianteWithSameName(varianteName, variante);
    }

    public void replaceBalise(Integer oldCode, Integer newCode) {
        for (Parcours parcours : this._parcoursVector.getParcoursVector()) {
            parcours.replaceBalise(oldCode, newCode);
        }
    }

    public void swapBalises(Integer code1, Integer code2) {
        for (Parcours parcours : this._parcoursVector.getParcoursVector()) {
            parcours.swapBalises(code1, code2);
        }
    }

    public boolean notExistsCategorieWithShortName(String shortName) {
        return !this._categorieVector.existsCategorieWithShortName(shortName);
    }

    private void _setPenalitesIndividuelles(Parcours parcours, Etape etape) {
        this._individualPenalties.clear();
        Vector<Equipe> equipeVector = parcours.getEquipeVector().getEquipeVector();
        for (Equipe equipe : equipeVector) {
            InternalPenalitesIndividuelles internalPenalitesIndividuelles = new InternalPenalitesIndividuelles();
            internalPenalitesIndividuelles.setBib(equipe.getBib());
            internalPenalitesIndividuelles.setPuce(equipe.getPuceIdsAsString());
            internalPenalitesIndividuelles.setEquipe(equipe.getName());
            this._individualPenalties.add(internalPenalitesIndividuelles);
        }
        List<Penalite> penaliteVector = this._penaliteVector.getPenaliteVector();
        for (Penalite penalite : penaliteVector) {
            if (penalite.getEtape() != etape) continue;
            for (InternalPenalitesIndividuelles penaliteIndividuelle : this._individualPenalties) {
                if (penalite.hasPuce(penaliteIndividuelle.getPuce())) {
                    penaliteIndividuelle.addPoint("" + penalite.getPoints(penaliteIndividuelle.getPuce()));
                    penaliteIndividuelle.addTime(DateTimeUtils.millisecondsToString((long)penalite.getTempsInS(penaliteIndividuelle.getPuce()) * 1000L));
                    continue;
                }
                penaliteIndividuelle.addPoint("");
                penaliteIndividuelle.addTime("");
            }
        }
    }
}

