/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model;

import fr.geraidv3.L10n;
import fr.geraidv3.model.ZeroHour;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.result.penalite.PenaliteVector;
import java.util.ArrayList;
import java.util.List;

final class RaidSettings {
    private final ZeroHour _zeroHour = new ZeroHour(0, 0);
    private final List<String> _resultColumnNameHeaders = new ArrayList<String>();
    private String _raidName = "";
    private String _printHeader = "";
    private String _printFooter = L10n.getString("settings.page_footer.template");
    private String _currentFilename = "";
    private boolean _withTeammateNames = false;

    RaidSettings() {
    }

    String getRaidName() {
        return this._raidName;
    }

    void setRaidName(String nom) {
        this._raidName = nom;
    }

    String getCurrentFilename() {
        return this._currentFilename;
    }

    void setCurrentFilename(String filename) {
        this._currentFilename = filename;
    }

    String getPrintHeader() {
        return this._printHeader;
    }

    void setPrintHeader(String text) {
        this._printHeader = text;
    }

    String getPrintFooter() {
        return this._printFooter;
    }

    void setPrintFooter(String text) {
        this._printFooter = text;
    }

    int getResultNumberOfColumns() {
        return this._resultColumnNameHeaders.size();
    }

    void reset() {
        this._currentFilename = "";
    }

    boolean isEnabledDisplayTeammate() {
        return this._withTeammateNames;
    }

    void setEnabledDisplayTeammate(boolean value) {
        this._withTeammateNames = value;
    }

    ZeroHour getZeroTime() {
        return this._zeroHour;
    }

    String[] getResultColumnNameHeaders(Etape etape, PenaliteVector penaliteVector) {
        this.createResultHeaders(etape, penaliteVector);
        return this._resultColumnNameHeaders.toArray(new String[0]);
    }

    private void createResultHeaders(Etape etape, PenaliteVector penaliteVector) {
        this._resultColumnNameHeaders.clear();
        this._resultColumnNameHeaders.add(L10n.getString("settings.category.bib").toUpperCase());
        this._resultColumnNameHeaders.add(L10n.getString("settings.category.team_name").toUpperCase());
        this._resultColumnNameHeaders.add(L10n.getString("settings.category.puce").toUpperCase());
        List<String> penaltyCount = penaliteVector.getPenaltyCountForEtape(etape);
        for (String nbPenalite : penaltyCount) {
            this._resultColumnNameHeaders.add(nbPenalite + L10n.getString("settings.category.penalty_points").toUpperCase());
            this._resultColumnNameHeaders.add(nbPenalite + L10n.getString("settings.category.penalty_time").toUpperCase());
        }
    }
}

