/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.balise;

import fr.geraidv3.L10n;
import fr.geraidv3.utils.DateTimeUtils;

public final class Balise {
    private int _number;
    private int _punchPointsBonus;
    private int _punchTimeBonusInS;
    private int _mispunchPointsPenalty;
    private int _mispunchTimePenaltyInS;
    private boolean _freezeTime;

    public Balise(int number) {
        this._number = number;
        this._punchPointsBonus = 0;
        this._punchTimeBonusInS = 0;
        this._mispunchPointsPenalty = 0;
        this._mispunchTimePenaltyInS = 0;
        this._freezeTime = false;
    }

    public Balise() {
        this(31);
    }

    public Balise(Balise balise) {
        this._number = balise._number;
        this._punchPointsBonus = balise._punchPointsBonus;
        this._punchTimeBonusInS = balise._punchTimeBonusInS;
        this._mispunchPointsPenalty = balise._mispunchPointsPenalty;
        this._mispunchTimePenaltyInS = balise._mispunchTimePenaltyInS;
        this._freezeTime = balise._freezeTime;
    }

    public int getNumber() {
        return this._number;
    }

    public void setNumber(int number) {
        this._number = number;
    }

    public boolean isPartOfGelEpreuve() {
        return this._freezeTime;
    }

    public void setFreezeTime(boolean freezeTime) {
        this._freezeTime = freezeTime;
    }

    public String getIsFreezeTimeAsString() {
        return this._freezeTime ? "1" : "0";
    }

    public int getPunchPointsBonus() {
        return this._punchPointsBonus;
    }

    public void setPunchPointsBonus(int points) {
        this._punchPointsBonus = points;
    }

    public int getPunchTimeBonusInS() {
        return this._punchTimeBonusInS;
    }

    public void setPunchTimeBonusInS(int time) {
        this._punchTimeBonusInS = time;
    }

    public int getMispunchPointsPenalty() {
        return this._mispunchPointsPenalty;
    }

    public void setMispunchPointsPenalty(int points) {
        this._mispunchPointsPenalty = points;
    }

    public int getMispunchTimePenaltyInS() {
        return this._mispunchTimePenaltyInS;
    }

    public void setMispunchTimePenaltyInS(int time) {
        this._mispunchTimePenaltyInS = time;
    }

    public String toString() {
        StringBuilder text = new StringBuilder(L10n.getString("balise.html.title", this._number)).append(" ");
        if (this._punchPointsBonus != 0) {
            text.append(L10n.getString("balise.html.bonus_points", this._punchPointsBonus));
            if (this._punchTimeBonusInS != 0) {
                text.append(" et ").append(DateTimeUtils.millisecondsToString((long)this._punchTimeBonusInS * 1000L));
            }
            text.append("; ");
        } else if (this._punchTimeBonusInS != 0) {
            text.append(L10n.getString("balise.html.bonus_time", DateTimeUtils.millisecondsToString((long)this._punchTimeBonusInS * 1000L)));
        }
        if (this._mispunchPointsPenalty != 0) {
            text.append(L10n.getString("balise.html.penalty_points", this._mispunchPointsPenalty));
            if (this._mispunchTimePenaltyInS != 0) {
                text.append(" et ").append(DateTimeUtils.millisecondsToString((long)this._mispunchTimePenaltyInS * 1000L));
            }
            text.append("; ");
        } else if (this._mispunchTimePenaltyInS != 0) {
            text.append(L10n.getString("balise.html.penalty_time", DateTimeUtils.millisecondsToString((long)this._mispunchTimePenaltyInS * 1000L)));
        }
        return text.toString();
    }

    public void applyModel(Balise balise) {
        this.setPunchPointsBonus(balise.getPunchPointsBonus());
        this.setPunchTimeBonusInS(balise.getPunchTimeBonusInS());
        this.setMispunchPointsPenalty(balise.getMispunchPointsPenalty());
        this.setMispunchTimePenaltyInS(balise.getMispunchTimePenaltyInS());
    }

    public boolean differsFrom(Balise balise) {
        if (balise == null) {
            return true;
        }
        return this._punchPointsBonus != balise._punchPointsBonus || this._punchTimeBonusInS != balise._punchTimeBonusInS || this._mispunchPointsPenalty != balise._mispunchPointsPenalty || this._mispunchTimePenaltyInS != balise._mispunchTimePenaltyInS;
    }

    String toHtml() {
        return "<li>" + String.valueOf(this) + "</li>";
    }
}

