/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.epreuve;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.GlobalSettings;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveFactory;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.epreuve.StandardEpreuveFactory;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.VisibleForTesting;

public final class CsvEpreuveHelper {
    public static final String CVS_DELIMITER = ";";

    public static void exportEpreuve(EpreuveVector epreuveVector, String filename) {
        File file = new File(filename);
        int option = 0;
        if (file.exists()) {
            option = JOptionPane.showConfirmDialog(GeRaidV3.getRootFrame(), L10n.getString("confirm_file_overwrite", file), L10n.getString("confirmation_title"), 0, 2);
        }
        if (option == 0) {
            CsvEpreuveHelper.exportEpreuve(epreuveVector, file);
        }
    }

    public static void importEpreuvesOfEtape(GlobalSettings globalSettings, Parcours parcours, Etape etape, String filename) {
        File filePath = CsvEpreuveHelper._getFile(filename);
        if (filePath == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            ArrayList<Integer> rows = new ArrayList<Integer>();
            ArrayList<String> codes = new ArrayList<String>();
            StandardEpreuveFactory factory = new StandardEpreuveFactory();
            String csvDelimiter = CsvEpreuveHelper._importDataRows(globalSettings, parcours, etape, reader, (EpreuveFactory)factory, codes, rows);
            if (!rows.isEmpty()) {
                StringBuilder message = new StringBuilder(L10n.getString("csv_epreuve_helper.import_error1"));
                for (Integer integer : rows) {
                    message.append(integer).append(csvDelimiter);
                }
                message.append(L10n.getString("csv_epreuve_helper.import_error2")).append("\n");
                if (!codes.isEmpty()) {
                    message.append(L10n.getString("csv_epreuve_helper.import_error3")).append("\n");
                }
                for (String code : codes) {
                    message.append(code).append(csvDelimiter);
                }
                JOptionPane.showMessageDialog(GeRaidV3.getRootFrame(), message.toString(), L10n.getString("csv_epreuve_helper.success_message"), 1);
            }
        }
        catch (IOException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("csv_epreuve_helper.error3", e.getClass().getName(), e.getMessage()));
        }
    }

    public static void importEpreuvesOfEtape(GlobalSettings globalSettings, ParcoursVariante variante, Etape etape, String filename) {
        File filePath = CsvEpreuveHelper._getFile(filename);
        if (filePath == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            ArrayList<Integer> rows = new ArrayList<Integer>();
            ArrayList<String> codes = new ArrayList<String>();
            StandardEpreuveFactory factory = new StandardEpreuveFactory();
            CsvEpreuveHelper._importDataRows(globalSettings, variante, etape, reader, (EpreuveFactory)factory, codes, rows);
            if (!rows.isEmpty()) {
                StringBuilder message = new StringBuilder(L10n.getString("csv_epreuve_helper.import_error1"));
                for (Integer integer : rows) {
                    message.append(integer).append(CVS_DELIMITER);
                }
                message.append(L10n.getString("csv_epreuve_helper.import_error2")).append("\n");
                if (!codes.isEmpty()) {
                    message.append(L10n.getString("csv_epreuve_helper.import_error3")).append("\n");
                }
                for (String code : codes) {
                    message.append(code).append(CVS_DELIMITER);
                }
                JOptionPane.showMessageDialog(GeRaidV3.getRootFrame(), message.toString(), L10n.getString("csv_epreuve_helper.success_message"), 1);
            }
        }
        catch (IOException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("csv_epreuve_helper.error3", e.getClass().getName(), e.getMessage()));
        }
    }

    @VisibleForTesting
    static void exportEpreuve(EpreuveVector epreuveVector, File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            for (int i = 0; i < epreuveVector.getSize(); ++i) {
                String buffer = epreuveVector.getEpreuveVector().get(i).toCSV();
                writer.write(buffer);
                writer.write(System.lineSeparator());
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("csv_epreuve_helper.error1", e.getClass().getName(), e.getMessage()));
        }
    }

    private static void _addBaliseInEpreuve(Epreuve epreuve, List<String> codes, String buffer) {
        try {
            Balise balise = new Balise(Integer.parseInt(buffer));
            balise.applyModel(epreuve.getBaliseModel());
            epreuve.addBalise(balise);
        }
        catch (NumberFormatException e) {
            codes.add(buffer);
        }
    }

    private static String _importDataRows(GlobalSettings globalSettings, Parcours parcours, Etape etape, BufferedReader reader, EpreuveFactory factory, List<String> codes, List<Integer> rows) throws IOException {
        int row = 1;
        String line = reader.readLine();
        if (line == null) {
            return CVS_DELIMITER;
        }
        String csvDelimiter = FileUtils.extractDelimiterFromCsvHeader(line);
        do {
            ++row;
            String[] buffer = line.trim().split(csvDelimiter);
            if (buffer.length > 0 && !buffer[0].isEmpty() && !parcours.existsEpreuveName(etape, buffer[0])) {
                Epreuve epreuve = factory.createEpreuve(globalSettings);
                epreuve.setName(buffer[0]);
                for (int i = 1; i < buffer.length; ++i) {
                    CsvEpreuveHelper._addBaliseInEpreuve(epreuve, codes, buffer[i]);
                }
                parcours.addEpreuveToEtape(etape, epreuve);
                continue;
            }
            rows.add(row);
        } while ((line = reader.readLine()) != null);
        return csvDelimiter;
    }

    private static void _importDataRows(GlobalSettings globalSettings, ParcoursVariante variante, Etape etape, BufferedReader reader, EpreuveFactory factory, List<String> codes, List<Integer> rows) throws IOException {
        String line;
        int row = 1;
        while ((line = reader.readLine()) != null) {
            ++row;
            String[] buffer = line.trim().split(CVS_DELIMITER);
            if (buffer.length > 0 && !buffer[0].isEmpty() && !variante.existsEpreuveName(etape, buffer[0])) {
                Epreuve epreuve = factory.createEpreuve(globalSettings);
                epreuve.setName(buffer[0]);
                for (int i = 1; i < buffer.length; ++i) {
                    CsvEpreuveHelper._addBaliseInEpreuve(epreuve, codes, buffer[i]);
                }
                epreuve.setVariante(true);
                variante.getEpreuvesOfEtape(etape).addEpreuve(epreuve);
                continue;
            }
            rows.add(row);
        }
    }

    private static File _getFile(String filename) {
        File filePath = new File(filename);
        try {
            boolean newFile;
            if (!filePath.exists() && !(newFile = filePath.createNewFile())) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString("csv_epreuve_helper.error2", filePath));
            return null;
        }
        return filePath;
    }
}

